/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.context;

import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.test.common.context.CloseableServiceObjects;
import org.osgi.test.common.exceptions.ConsumerWithException;
import org.osgi.test.common.exceptions.Exceptions;

public class CloseableBundleContext
implements AutoCloseable,
InvocationHandler {
    private static final Consumer<ServiceRegistration<?>> unregisterService = ConsumerWithException.asConsumerIgnoreException(ServiceRegistration::unregister);
    private static final Consumer<AutoCloseable> autoclose = ConsumerWithException.asConsumer(AutoCloseable::close);
    private static final Predicate<Bundle> installed = bundle -> (bundle.getState() & 1) != 1;
    private static final Consumer<Bundle> uninstallBundle = ConsumerWithException.asConsumer(Bundle::uninstall);
    static final ClassLoader PROXY_CLASS_LOADER = CloseableBundleContext.class.getClassLoader();
    private final BundleContext bundleContext;
    private final Set<ServiceRegistration<?>> regs = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<FrameworkListener> fwListeners = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<ServiceListener> sListeners = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<BundleListener> bListeners = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private final Set<Bundle> bundlesToBeUninstalledOnClose = Collections.synchronizedSet(new HashSet());
    private final Map<ServiceReference<?>, Integer> services = Collections.synchronizedMap(new HashMap());
    private final Set<ServiceObjects<?>> serviceobjects = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));
    private static final Map<Method, BiFunction<Object, Object[], Object>> methods = Arrays.stream(BundleContext.class.getMethods()).collect(Collectors.toMap(Function.identity(), method -> {
        try {
            return CloseableBundleContext.invoker(CloseableBundleContext.class.getMethod(method.getName(), method.getParameterTypes()), CloseableBundleContext::closeableBundleContext);
        }
        catch (NoSuchMethodException e) {
            return CloseableBundleContext.invoker(method, CloseableBundleContext::realBundleContext);
        }
    }));

    static BiFunction<Object, Object[], Object> invoker(Method method, Function<? super Object, Object> mapper) {
        try {
            MethodHandle mh = MethodHandles.publicLookup().unreflect(method);
            if (Modifier.isStatic(method.getModifiers())) {
                return (proxy, args) -> {
                    try {
                        return mh.invokeWithArguments(args);
                    }
                    catch (Throwable e) {
                        throw Exceptions.duck(e);
                    }
                };
            }
            return (proxy, args) -> {
                try {
                    return mh.bindTo(mapper.apply(proxy)).invokeWithArguments(args);
                }
                catch (Throwable e) {
                    throw Exceptions.duck(e);
                }
            };
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    public static BundleContext proxy(BundleContext bundleContext) {
        return (BundleContext)Proxy.newProxyInstance(PROXY_CLASS_LOADER, new Class[]{BundleContext.class, AutoCloseable.class}, (InvocationHandler)new CloseableBundleContext(bundleContext));
    }

    public CloseableBundleContext(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        BiFunction<Object, Object[], Object> invoker = methods.get(method);
        if (invoker == null) {
            throw new IllegalArgumentException();
        }
        return invoker.apply(proxy, args);
    }

    private static CloseableBundleContext closeableBundleContext(Object proxy) {
        InvocationHandler invocationHandler;
        try {
            invocationHandler = Proxy.getInvocationHandler(proxy);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (invocationHandler instanceof CloseableBundleContext) {
            return (CloseableBundleContext)invocationHandler;
        }
        return null;
    }

    private static BundleContext realBundleContext(Object proxy) {
        CloseableBundleContext closeableBundleContext = CloseableBundleContext.closeableBundleContext(proxy);
        if (closeableBundleContext == null) {
            return null;
        }
        BundleContext real = closeableBundleContext.bundleContext;
        while ((closeableBundleContext = CloseableBundleContext.closeableBundleContext(real)) != null) {
            real = closeableBundleContext.bundleContext;
        }
        return real;
    }

    private static Void delegatedClose(Object proxy, Object[] args) {
        CloseableBundleContext.closeableBundleContext(proxy).close();
        return null;
    }

    @Override
    public void close() {
        this.bundlesToBeUninstalledOnClose.stream().filter(installed).forEach(uninstallBundle);
        this.bundlesToBeUninstalledOnClose.clear();
        this.services.forEach((reference, useCount) -> {
            for (int i = useCount.intValue(); i > 0; --i) {
                this.bundleContext.ungetService(reference);
            }
        });
        this.services.clear();
        this.serviceobjects.stream().map(AutoCloseable.class::cast).forEach(autoclose);
        this.serviceobjects.clear();
        this.regs.forEach(unregisterService);
        this.regs.clear();
        this.bListeners.forEach(arg_0 -> ((BundleContext)this.bundleContext).removeBundleListener(arg_0));
        this.bListeners.clear();
        this.sListeners.forEach(arg_0 -> ((BundleContext)this.bundleContext).removeServiceListener(arg_0));
        this.sListeners.clear();
        this.fwListeners.forEach(arg_0 -> ((BundleContext)this.bundleContext).removeFrameworkListener(arg_0));
        this.fwListeners.clear();
    }

    private static String delegatedToString(Object proxy, Object[] args) {
        return "CloseableBundleContext[" + System.identityHashCode(proxy) + "]:" + CloseableBundleContext.realBundleContext(proxy).toString();
    }

    private static int delegatedHashCode(Object proxy, Object[] args) {
        return CloseableBundleContext.realBundleContext(proxy).hashCode();
    }

    private static boolean delegatedEquals(Object proxy, Object[] args) {
        BundleContext bundleContext = CloseableBundleContext.realBundleContext(proxy);
        BundleContext real = CloseableBundleContext.realBundleContext(args[0]);
        if (real != null) {
            return bundleContext.equals(real);
        }
        return bundleContext.equals(args[0]);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        Bundle bundle = this.bundleContext.getBundle(location);
        if (bundle == null) {
            bundle = this.bundleContext.installBundle(location, input);
            this.bundlesToBeUninstalledOnClose.add(bundle);
        }
        return bundle;
    }

    public Bundle installBundle(String location) throws BundleException {
        Bundle bundle = this.bundleContext.getBundle(location);
        if (bundle == null) {
            bundle = this.bundleContext.installBundle(location);
            this.bundlesToBeUninstalledOnClose.add(bundle);
        }
        return bundle;
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.bundleContext.addServiceListener(listener, filter);
        this.sListeners.add(listener);
    }

    public void addServiceListener(ServiceListener listener) {
        this.bundleContext.addServiceListener(listener);
        this.sListeners.add(listener);
    }

    public void removeServiceListener(ServiceListener listener) {
        this.bundleContext.removeServiceListener(listener);
        this.sListeners.remove(listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.bundleContext.addBundleListener(listener);
        this.bListeners.add(listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.bundleContext.removeBundleListener(listener);
        this.bListeners.remove(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.bundleContext.addFrameworkListener(listener);
        this.fwListeners.add(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.bundleContext.removeFrameworkListener(listener);
        this.fwListeners.remove(listener);
    }

    public <S> S getService(ServiceReference<S> reference) {
        Object service = this.bundleContext.getService(reference);
        Integer count = this.services.merge(reference, 1, (oldValue, dummy) -> oldValue + 1);
        return (S)service;
    }

    public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
        ServiceObjects so = this.bundleContext.getServiceObjects(reference);
        ServiceObjects serviceObjects = CloseableServiceObjects.proxy(so);
        this.serviceobjects.add(serviceObjects);
        return serviceObjects;
    }

    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazzes, service, properties);
        this.regs.add(reg);
        return reg;
    }

    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazz, service, properties);
        this.regs.add(reg);
        return reg;
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazz, service, properties);
        this.regs.add(reg);
        return reg;
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
        ServiceRegistration reg = this.bundleContext.registerService(clazz, factory, properties);
        this.regs.add(reg);
        return reg;
    }

    public boolean ungetService(ServiceReference<?> reference) {
        Integer count = this.services.compute(reference, (key, oldValue) -> {
            if (oldValue == null || oldValue == 0) {
                return null;
            }
            return oldValue - 1;
        });
        if (count != null) {
            this.bundleContext.ungetService(reference);
            return true;
        }
        return false;
    }

    static {
        try {
            methods.put(AutoCloseable.class.getMethod("close", new Class[0]), CloseableBundleContext::delegatedClose);
            methods.put(Object.class.getMethod("toString", new Class[0]), CloseableBundleContext::delegatedToString);
            methods.put(Object.class.getMethod("hashCode", new Class[0]), CloseableBundleContext::delegatedHashCode);
            methods.put(Object.class.getMethod("equals", Object.class), CloseableBundleContext::delegatedEquals);
        }
        catch (NoSuchMethodException e) {
            throw Exceptions.duck(e);
        }
    }
}

