/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editors;

import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.core.InstancesForMetaclass;
import org.eclipse.modisco.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.modisco.infra.browser.editors.MetaclassUnwrappingSelectionProvider;
import org.eclipse.modisco.infra.browser.editors.MetaclassViewerMenuManager;
import org.eclipse.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.modisco.infra.browser.uicore.internal.customization.CustomizationEngine;
import org.eclipse.modisco.infra.browser.uicore.internal.extensions.IconProvidersRegistry;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MetaclassViewer
implements ISelectionProvider {
    public static final String MENU_ID = "org.eclipse.modisco.infra.browser.editorID.MetaclassViewer.menu";
    private final TreeViewer treeViewer;
    private final BrowserConfiguration browserConfiguration;
    private static final RGB RGB_GRAY = new RGB(128, 128, 128);
    private static final RGB RGB_GREEN = new RGB(0, 128, 0);
    private final IWorkbenchPartSite site;

    public MetaclassViewer(Composite parent, BrowserConfiguration browserConfiguration, FormToolkit formToolkit, IWorkbenchPartSite site) {
        this.browserConfiguration = browserConfiguration;
        this.site = site;
        Tree tree = formToolkit.createTree(parent, 2050);
        this.treeViewer = new TreeViewer(tree);
        this.initViewer();
        this.createContextMenu((Control)tree);
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    protected void createContextMenu(Control control) {
        MetaclassViewerMenuManager menuManager = new MetaclassViewerMenuManager(this, this.browserConfiguration);
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        this.site.registerContextMenu(MENU_ID, (MenuManager)menuManager, (ISelectionProvider)new MetaclassUnwrappingSelectionProvider(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectRootElement() {
        this.treeViewer.setSelection(null);
        EList resources = this.browserConfiguration.getResourceSet().getResources();
        if (resources.size() > 0) {
            Resource resource;
            Resource resource2 = resource = (Resource)resources.get(0);
            synchronized (resource2) {
                EList contents = resource.getContents();
                if (contents.size() > 0) {
                    EObject object = (EObject)contents.get(0);
                    this.selectMetaclass(object.eClass());
                }
            }
        }
    }

    public void selectMetaclass(EClass eClass) {
        InstancesForMetaclasses instancesForMetaclasses;
        InstancesForMetaclass instancesForMetaclass;
        Object input = this.treeViewer.getInput();
        if (input instanceof InstancesForMetaclasses && (instancesForMetaclass = (instancesForMetaclasses = (InstancesForMetaclasses)input).getInstancesForMetaclass(eClass)) != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)instancesForMetaclass), true);
        }
    }

    public String[] getSelectedMetaclassesQualifiedNames() {
        ArrayList<String> selectedMetaclasses = new ArrayList<String>();
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof InstancesForMetaclass)) continue;
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)selectedElement;
                selectedMetaclasses.add(instancesForMetaclass.getClassQualifiedName());
            }
        }
        return selectedMetaclasses.toArray(new String[selectedMetaclasses.size()]);
    }

    public EClass[] getSelectedMetaclasses() {
        ArrayList<EClass> selectedMetaclasses = new ArrayList<EClass>();
        ISelection selection = this.treeViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof InstancesForMetaclass)) continue;
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)selectedElement;
                selectedMetaclasses.add(instancesForMetaclass.getEClass());
            }
        }
        return selectedMetaclasses.toArray(new EClass[selectedMetaclasses.size()]);
    }

    public String getFirstSelectedMetaclassQualifiedName() {
        String[] selectedMetaclassesQualifiedNames = this.getSelectedMetaclassesQualifiedNames();
        String firstSelectedMetaclass = null;
        if (selectedMetaclassesQualifiedNames.length > 0) {
            firstSelectedMetaclass = selectedMetaclassesQualifiedNames[0];
        }
        return firstSelectedMetaclass;
    }

    public EClass getFirstSelectedMetaclass() {
        EClass[] selectedMetaclasses = this.getSelectedMetaclasses();
        EClass firstSelectedMetaclass = null;
        if (selectedMetaclasses.length > 0) {
            firstSelectedMetaclass = selectedMetaclasses[0];
        }
        return firstSelectedMetaclass;
    }

    private void initViewer() {
        this.treeViewer.setContentProvider((IContentProvider)new MetaclassContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MetaclassLabelProvider());
        this.treeViewer.addFilter((ViewerFilter)new EmptyMetaclassesFilter());
        this.treeViewer.addFilter((ViewerFilter)new HiddenMetaclassesFilter(this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine()));
        this.setSortMode(this.browserConfiguration.getAppearanceConfiguration().getMetaclassesSortMode());
    }

    public Object[] groupByPackage(InstancesForMetaclass[] instancesByMetaclass) {
        ArrayList<Object> toplevelItems = new ArrayList<Object>();
        InstancesForMetaclass[] instancesForMetaclassArray = instancesByMetaclass;
        int n = instancesByMetaclass.length;
        int n2 = 0;
        while (n2 < n) {
            InstancesForMetaclass instancesForMetaclass = instancesForMetaclassArray[n2];
            EClass eClass = instancesForMetaclass.getEClass();
            ArrayList<String> pathSegments = new ArrayList<String>();
            pathSegments.add(eClass.getName());
            EPackage ePackage = eClass.getEPackage();
            while (ePackage != null) {
                pathSegments.add(ePackage.getName());
                ePackage = ePackage.getESuperPackage();
            }
            String[] path = new String[pathSegments.size()];
            int i = pathSegments.size() - 1;
            for (String segment : pathSegments) {
                path[i--] = segment;
            }
            this.addToPackage(instancesForMetaclass, path, 0, toplevelItems, null);
            ++n2;
        }
        return toplevelItems.toArray(new Object[toplevelItems.size()]);
    }

    private void addToPackage(InstancesForMetaclass instancesForMetaclass, String[] path, int index, ArrayList<Object> items, Object parent) {
        if (path.length - index == 1) {
            instancesForMetaclass.setParent(parent);
            items.add(instancesForMetaclass);
        } else if (path.length - index > 1) {
            for (Object item : items) {
                if (!(item instanceof PackageGroup)) continue;
                PackageGroup packageGroup = (PackageGroup)item;
                try {
                    if (!packageGroup.getName().equals(path[index])) continue;
                    this.addToPackage(instancesForMetaclass, path, index + 1, packageGroup, packageGroup);
                    return;
                }
                catch (Exception e) {
                    MoDiscoLogger.logError((Throwable)e, (String)("Failed to deal with: " + packageGroup.toString()), (Plugin)MoDiscoBrowserPlugin.getPlugin());
                }
            }
            PackageGroup packageGroup = new PackageGroup(parent, path[index]);
            items.add(packageGroup);
            this.addToPackage(instancesForMetaclass, path, index + 1, packageGroup, packageGroup);
        }
    }

    public void refresh() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public void reload() {
        InstancesForMetaclasses instancesForMetaclasses = this.browserConfiguration.getInstancesForMetaclasses();
        this.treeViewer.setInput((Object)instancesForMetaclasses);
        this.refresh();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void clearSelection() {
        this.treeViewer.setSelection(null);
    }

    public ISelection getSelection() {
        return MetaclassViewer.unwrapSelection(this.treeViewer.getSelection());
    }

    public static ISelection unwrapSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<Object> elements = new ArrayList<Object>();
            for (Object element : structuredSelection) {
                if (element instanceof InstancesForMetaclass) {
                    InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                    elements.add(instancesForMetaclass.getEClass());
                    continue;
                }
                elements.add(element);
            }
            return new StructuredSelection(elements);
        }
        return selection;
    }

    public void setSortMode(AppearanceConfiguration.MetaclassesSortMode mode) {
        this.browserConfiguration.getAppearanceConfiguration().setMetaclassesSortMode(mode);
        if (mode == AppearanceConfiguration.MetaclassesSortMode.ByName) {
            this.treeViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    String first = MetaclassViewer.this.getDisplayedName(e1);
                    String second = MetaclassViewer.this.getDisplayedName(e2);
                    if (first == null) {
                        first = "null";
                    }
                    return first.compareToIgnoreCase(second);
                }
            });
        } else if (mode == AppearanceConfiguration.MetaclassesSortMode.ByCount) {
            this.treeViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    int first = MetaclassViewer.this.getCount(e1);
                    int second = MetaclassViewer.this.getCount(e2);
                    return first - second;
                }
            });
        }
    }

    public void setShowMetaclassesFullQualifiedNames(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowMetaclassesFullQualifiedNames(value);
        this.treeViewer.refresh();
    }

    public void setShowEmptyMetaclasses(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowEmptyMetaclasses(value);
        this.refresh();
    }

    public void setGroupByPackage(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setGroupByPackage(value);
        this.refresh();
    }

    public void setDisplayInstancesOfSubclasses(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setDisplayInstancesOfSubclasses(value);
        this.refresh();
        if (!this.treeViewer.getSelection().isEmpty()) {
            this.treeViewer.setSelection(this.treeViewer.getSelection());
        }
    }

    public void setShowDerivationTree(boolean value) {
        this.browserConfiguration.getAppearanceConfiguration().setShowDerivationTree(value);
        this.refresh();
    }

    private String getDisplayedName(Object object) {
        String name = "";
        if (object instanceof InstancesForMetaclass) {
            InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)object;
            name = this.browserConfiguration.getAppearanceConfiguration().isShowMetaclassesFullQualifiedNames() ? instancesForMetaclass.getClassQualifiedName() : instancesForMetaclass.getEClass().getName();
        }
        return name;
    }

    private int getCount(Object object) {
        int count = 0;
        if (object instanceof InstancesForMetaclass) {
            InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)object;
            count = this.browserConfiguration.getAppearanceConfiguration().isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
        }
        return count;
    }

    public void setFont(Font font) {
        this.treeViewer.getTree().setFont(font);
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    protected class EmptyMetaclassesFilter
    extends ViewerFilter {
        protected EmptyMetaclassesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowEmptyMetaclasses()) {
                if (element instanceof InstancesForMetaclass) {
                    InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                    int count = this.getInstanceCountFor(instancesForMetaclass);
                    if (count == 0) {
                        if (MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree()) {
                            return this.isOneSubclassNonEmpty(instancesForMetaclass);
                        }
                        return false;
                    }
                } else if (element instanceof PackageGroup) {
                    return !this.isEmpty((PackageGroup)element);
                }
            }
            return true;
        }

        private boolean isEmpty(PackageGroup packageGroup) {
            for (Object element : packageGroup) {
                InstancesForMetaclass instancesForMetaclass;
                PackageGroup p;
                if (!(element instanceof PackageGroup ? !this.isEmpty(p = (PackageGroup)element) : element instanceof InstancesForMetaclass && this.getInstanceCountFor(instancesForMetaclass = (InstancesForMetaclass)element) != 0)) continue;
                return false;
            }
            return true;
        }

        private boolean isOneSubclassNonEmpty(InstancesForMetaclass instancesForMetaclass) {
            InstancesForMetaclass[] subclasses;
            InstancesForMetaclass[] instancesForMetaclassArray = subclasses = instancesForMetaclass.getSubclasses();
            int n = subclasses.length;
            int n2 = 0;
            while (n2 < n) {
                InstancesForMetaclass subclass = instancesForMetaclassArray[n2];
                if (this.getInstanceCountFor(subclass) > 0 || this.isOneSubclassNonEmpty(subclass)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private int getInstanceCountFor(InstancesForMetaclass instancesForMetaclass) {
            int count = 0;
            count = MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
            return count;
        }
    }

    protected static class HiddenMetaclassesFilter
    extends ViewerFilter {
        private final CustomizationEngine customizationEngine;

        public HiddenMetaclassesFilter(CustomizationEngine customizationEngine) {
            this.customizationEngine = customizationEngine;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                EClass eClass = instancesForMetaclass.getEClass();
                return this.customizationEngine.isMetaclassVisible(eClass);
            }
            return true;
        }
    }

    protected class MetaclassContentProvider
    implements ITreeContentProvider {
        protected MetaclassContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == EcoreBrowser.LOADING_MESSAGE) {
                return new Object[]{EcoreBrowser.LOADING_MESSAGE};
            }
            InstancesForMetaclasses instancesForMetaclasses = (InstancesForMetaclasses)inputElement;
            Object[] instancesByMetaclass = instancesForMetaclasses.getInstancesForMetaclasses();
            if (MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree()) {
                instancesByMetaclass = instancesForMetaclasses.getRootMetaclasses();
            }
            if (MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isGroupByPackage() && !MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree()) {
                return MetaclassViewer.this.groupByPackage((InstancesForMetaclass[])instancesByMetaclass);
            }
            return instancesByMetaclass;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)parentElement;
                return packageGroup.toArray(new Object[packageGroup.size()]);
            }
            if (MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree() && parentElement instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)parentElement;
                return instancesForMetaclass.getSubclasses();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)element;
                return packageGroup.getParent();
            }
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                if (MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree()) {
                    EList superTypes = instancesForMetaclass.getEClass().getESuperTypes();
                    if (superTypes.size() > 0) {
                        InstancesForMetaclass superclass = MetaclassViewer.this.browserConfiguration.getInstancesForMetaclasses().getInstancesForMetaclass((EClass)superTypes.get(0));
                        return superclass;
                    }
                } else if (MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isGroupByPackage()) {
                    return instancesForMetaclass.getParent();
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)element;
                return packageGroup.size() > 0;
            }
            if (MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowDerivationTree() && element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                return instancesForMetaclass.getSubclasses().length > 0;
            }
            return false;
        }
    }

    protected class MetaclassLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        private final Color colorGrayedOut = new Color((Device)Display.getDefault(), RGB_GRAY);
        private final Color colorFacets = new Color((Device)Display.getDefault(), RGB_GREEN);

        public String getText(Object element) {
            if (element == EcoreBrowser.LOADING_MESSAGE) {
                return EcoreBrowser.LOADING_MESSAGE;
            }
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                int count = 0;
                count = MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
                String name = MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isShowMetaclassesFullQualifiedNames() ? instancesForMetaclass.getClassQualifiedName() : instancesForMetaclass.getEClass().getName();
                return name + " (" + count + ")";
            }
            if (element instanceof PackageGroup) {
                PackageGroup packageGroup = (PackageGroup)element;
                return packageGroup.getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            try {
                if (element instanceof InstancesForMetaclass) {
                    InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                    EClass eClass = instancesForMetaclass.getEClass();
                    CustomizationEngine customizationEngine = MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine();
                    Image metaclassIcon = customizationEngine.getMetaclassIcon(null, eClass);
                    if (metaclassIcon != null) {
                        return metaclassIcon;
                    }
                    Image customizedIcon = customizationEngine.getTypeIcon(null, eClass);
                    if (customizedIcon != null) {
                        return customizedIcon;
                    }
                    if (!eClass.isAbstract()) {
                        EObject dummyInstance = eClass.getEPackage().getEFactoryInstance().create(eClass);
                        IconProvidersRegistry iconProvidersRegistry = IconProvidersRegistry.getInstance();
                        Image icon = iconProvidersRegistry.getIcon(dummyInstance);
                        if (icon != null) {
                            return icon;
                        }
                        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().getAdapterFactory().adapt((Notifier)dummyInstance, IItemLabelProvider.class);
                        if (itemLabelProvider != null) {
                            return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage((Object)dummyInstance));
                        }
                    }
                    if (eClass instanceof Facet) {
                        return ImageProvider.getInstance().getFacetIcon();
                    }
                    String className = eClass.getName();
                    URI imageURI = URI.createURI((String)(EMFEditPlugin.INSTANCE.getImage("full/obj16/Item").toString() + "#" + className));
                    return ExtendedImageRegistry.getInstance().getImage((Object)imageURI);
                }
                if (element instanceof PackageGroup) {
                    return ImageProvider.getInstance().getPackageIcon();
                }
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException("Error retrieving image", e);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof InstancesForMetaclass) {
                InstancesForMetaclass instancesForMetaclass = (InstancesForMetaclass)element;
                int count = 0;
                count = MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().isDisplayInstancesOfSubclasses() ? instancesForMetaclass.totalSize() : instancesForMetaclass.size();
                if (count == 0) {
                    return this.colorGrayedOut;
                }
                if (instancesForMetaclass.getEClass() instanceof Facet) {
                    return this.colorFacets;
                }
            }
            return null;
        }

        public Font getFont(Object element) {
            InstancesForMetaclass instancesForMetaclass;
            if (element instanceof InstancesForMetaclass && (instancesForMetaclass = (InstancesForMetaclass)element).getEClass().isAbstract()) {
                return MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().getCustomItalicFont();
            }
            return MetaclassViewer.this.browserConfiguration.getAppearanceConfiguration().getCustomFont();
        }

        public void dispose() {
            this.colorGrayedOut.dispose();
            this.colorFacets.dispose();
            super.dispose();
        }
    }

    protected static class PackageGroup
    extends ArrayList<Object> {
        private final String name;
        private final Object parent;

        public PackageGroup(Object parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public Object getParent() {
            return this.parent;
        }

        public String getName() {
            if (this.name == null) {
                return "";
            }
            return this.name;
        }
    }
}

