/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.Serializable;

public class Range
implements Cloneable,
Serializable {
    public final int start;
    public final int end;
    public final int length;
    private static final long serialVersionUID = 1L;

    public Range(int start, int end) {
        this.start = Math.min(start, end);
        this.end = Math.max(start, end);
        this.length = this.end - this.start + 1;
    }

    public boolean includes(int index) {
        return this.start <= index && index <= this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range otherRange = (Range)o;
        return this.start == otherRange.start && this.end == otherRange.end;
    }

    public int hashCode() {
        return this.start ^ this.end;
    }

    public Range clone() {
        try {
            return (Range)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append('[');
        sb.append(this.start);
        sb.append(", ");
        sb.append(this.end);
        sb.append(']');
    }
}

