/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.sources;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.tcl.core.packages.TclModuleInfo;
import org.eclipse.dltk.tcl.core.packages.TclProjectInfo;
import org.eclipse.dltk.tcl.core.packages.TclSourceEntry;
import org.eclipse.dltk.tcl.core.packages.UserCorrection;
import org.eclipse.emf.common.util.EList;

public class TclSourcesSourceModule
extends ExternalSourceModule {
    private String originalName;

    public TclSourcesSourceModule(ModelElement parent, String name, WorkingCopyOwner owner, IStorage storage, String originalName) {
        super(parent, name, owner, storage);
        this.originalName = originalName;
    }

    public IPath getPath() {
        IPath parentPath = this.getParent().getPath();
        return parentPath.append(this.getElementName());
    }

    public IPath getFullPath() {
        return this.getStorage().getFullPath();
    }

    public IPath getBufferPath() {
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)this);
        if (environment != null) {
            return EnvironmentPathUtils.getFullPath((IEnvironment)environment, (IPath)this.getStorage().getFullPath());
        }
        return this.getStorage().getFullPath();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    protected IStatus validateSourceModule(IDLTKLanguageToolkit toolkit, IResource resource) {
        return IModelStatus.VERIFIED_OK;
    }

    public void delete(boolean force, IProgressMonitor monitor) {
        IScriptProject scriptProject = this.getScriptProject();
        IEnvironment environment = EnvironmentManager.getEnvironment((IModelElement)scriptProject);
        TclProjectInfo project = TclPackagesManager.getTclProject(scriptProject.getElementName());
        EList<TclModuleInfo> modules = project.getModules();
        String path = environment.convertPathToString(this.getFullPath()).toString();
        for (TclModuleInfo tclModuleInfo : modules) {
            EList<UserCorrection> corrections = tclModuleInfo.getSourceCorrections();
            EList<TclSourceEntry> sourced = tclModuleInfo.getSourced();
            EList<UserCorrection> sourceCorrections = tclModuleInfo.getSourceCorrections();
            for (TclSourceEntry tclSourceEntry : sourced) {
                String value = tclSourceEntry.getValue();
                if (!value.contains("$") || !value.equals(this.getOriginalName())) continue;
                for (UserCorrection userCorrection : sourceCorrections) {
                    if (!userCorrection.getOriginalValue().equals(value)) continue;
                    userCorrection.getUserValue().remove((Object)path);
                }
            }
        }
        TclPackagesManager.save();
        try {
            ModelManager.getModelManager().getDeltaProcessor().checkExternalChanges(new IModelElement[]{this.getScriptProject()}, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ModelException e) {
            DLTKCore.error((String)"Failed to call for model update:", (Throwable)e);
        }
    }

    public String getElementName() {
        return super.getElementName();
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes((int)super.getElementName().hashCode(), (int)this.parent.hashCode());
    }
}

