/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.display;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.display.DebugConsole;
import org.eclipse.dltk.debug.ui.display.DebugScriptInterpreter;
import org.eclipse.dltk.debug.ui.display.IEvaluateConsole;
import org.eclipse.dltk.debug.ui.display.IEvaluateConsoleFactory;
import org.eclipse.dltk.debug.ui.display.IEvaluateConsoleListener;
import org.eclipse.dltk.debug.ui.display.Messages;
import org.eclipse.dltk.debug.ui.display.internal.ConsoleDropDownAction;
import org.eclipse.dltk.debug.ui.display.internal.ConsoleWorkbenchPart;
import org.eclipse.dltk.debug.ui.display.internal.EvaluateConsoleFactoryManager;
import org.eclipse.dltk.debug.ui.display.internal.OpenConsoleAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.PinConsoleAction;
import org.eclipse.ui.internal.console.ShowConsoleAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.PageSwitcher;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ScriptDisplayView
extends PageBookView
implements IConsoleView,
IPropertyChangeListener,
IPartListener2 {
    private boolean fPinned = false;
    private List<IConsole> fStack = new ArrayList<IConsole>();
    private IConsole fActiveConsole = null;
    private Map<IConsole, ConsoleWorkbenchPart> fConsoleToPart;
    private Map<IConsole, ListenerList<IConsolePageParticipant>> fConsoleToPageParticipants;
    private Map<ConsoleWorkbenchPart, IConsole> fPartToConsole;
    private boolean fActive = false;
    private IContextActivation fActivatedContext;
    private PinConsoleAction fPinAction = null;
    private ConsoleDropDownAction fDisplayConsoleAction = null;
    private OpenConsoleAction fOpenConsoleAction = null;
    private boolean fScrollLock;
    private final ListenerList<IEvaluateConsoleListener> consoleListeners = new ListenerList();

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    public boolean getWordWrap() {
        return false;
    }

    public void setWordWrap(boolean wordWrap) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof IConsole && event.getProperty().equals("org.eclipse.jface.text") && source.equals(this.getConsole())) {
            this.updateTitle();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        super.partClosed(part);
        this.fPinAction.update();
    }

    public IConsole getConsole() {
        return this.fActiveConsole;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        if (this.fActiveConsole != null && pageRec.page != this.getDefaultPage() && this.fPinned && this.fConsoleToPart.size() > 1) {
            IConsole console = this.fPartToConsole.get(pageRec.part);
            if (!this.fStack.contains(console)) {
                this.fStack.add(console);
            }
            return;
        }
        IConsole recConsole = this.fPartToConsole.get(pageRec.part);
        if (recConsole != null && recConsole.equals(this.fActiveConsole)) {
            return;
        }
        super.showPageRec(pageRec);
        this.fActiveConsole = recConsole;
        IConsole tos = null;
        if (!this.fStack.isEmpty()) {
            tos = this.fStack.get(0);
        }
        if (tos != null && !tos.equals(this.fActiveConsole)) {
            this.deactivateParticipants(tos);
        }
        if (this.fActiveConsole != null && !this.fActiveConsole.equals(tos)) {
            this.fStack.remove(this.fActiveConsole);
            this.fStack.add(0, this.fActiveConsole);
            this.activateParticipants(this.fActiveConsole);
        }
        this.updateTitle();
        this.updateHelp();
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
    }

    private void activateParticipants(IConsole console) {
        ListenerList<IConsolePageParticipant> listeners;
        if (console != null && this.fActive && (listeners = this.getParticipants(console)) != null) {
            for (final IConsolePageParticipant participant : listeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        participant.activated();
                    }

                    public void handleException(Throwable exception) {
                        DLTKDebugUIPlugin.log(exception);
                        listeners.remove((Object)participant);
                    }
                });
            }
        }
    }

    public List<IConsole> getConsoleStack() {
        return this.fStack;
    }

    protected void updateTitle() {
        IConsole console = this.getConsole();
        if (console == null) {
            this.setContentDescription(ConsoleMessages.ConsoleView_0);
        } else {
            String newName = console.getName();
            String oldName = this.getContentDescription();
            if (newName != null && !newName.equals(oldName)) {
                this.setContentDescription(console.getName());
            }
        }
    }

    protected void updateHelp() {
        IConsole console = this.getConsole();
        String helpContextId = null;
        if (console instanceof AbstractConsole) {
            AbstractConsole abs = (AbstractConsole)console;
            helpContextId = abs.getHelpContextId();
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IConsole console = this.fPartToConsole.get(part);
        ListenerList<IConsolePageParticipant> listeners = this.fConsoleToPageParticipants.remove(console);
        if (listeners != null) {
            for (final IConsolePageParticipant participant : listeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        participant.dispose();
                    }

                    public void handleException(Throwable exception) {
                        DLTKDebugUIPlugin.log(exception);
                    }
                });
            }
        }
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        console.removePropertyChangeListener((IPropertyChangeListener)this);
        if (console instanceof AbstractConsole) {
            ((AbstractConsole)console).destroy();
        }
        this.fPartToConsole.remove(part);
        this.fConsoleToPart.remove(console);
        if (this.fPartToConsole.isEmpty()) {
            this.fActiveConsole = null;
        }
        this.fPinAction.update();
    }

    private ListenerList<IConsolePageParticipant> getParticipants(IConsole console) {
        return this.fConsoleToPageParticipants.get(console);
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        ConsoleWorkbenchPart part = (ConsoleWorkbenchPart)dummyPart;
        final IConsole console = part.getConsole();
        final IPageBookViewPage page = console.createPage((IConsoleView)this);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        console.addPropertyChangeListener((IPropertyChangeListener)this);
        final ListenerList participants = new ListenerList();
        IConsolePageParticipant[] consoleParticipants = this.getPageParticipants(console);
        int i = 0;
        while (i < consoleParticipants.length) {
            participants.add((Object)consoleParticipants[i]);
            ++i;
        }
        this.fConsoleToPageParticipants.put(console, (ListenerList<IConsolePageParticipant>)participants);
        for (final IConsolePageParticipant participant : participants) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    participant.init(page, console);
                }

                public void handleException(Throwable exception) {
                    DLTKDebugUIPlugin.log(exception);
                    participants.remove((Object)participant);
                }
            });
        }
        PageBookView.PageRec rec = new PageBookView.PageRec(dummyPart, (IPage)page);
        return rec;
    }

    private IConsolePageParticipant[] getPageParticipants(IConsole console) {
        return new IConsolePageParticipant[0];
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof ConsoleWorkbenchPart;
    }

    public void dispose() {
        IViewSite site = this.getViewSite();
        if (site != null) {
            site.getPage().removePartListener((IPartListener2)this);
        }
        super.dispose();
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    public void addConsole(IEvaluateConsole console) {
        if (this.isAvailable()) {
            ConsoleWorkbenchPart part = new ConsoleWorkbenchPart(console, this.getSite());
            this.fConsoleToPart.put(console, part);
            this.fPartToConsole.put(part, console);
            this.partActivated(part);
            for (IEvaluateConsoleListener listener : this.consoleListeners) {
                listener.consoleAdded(console);
            }
        }
    }

    public void consolesRemoved(IConsole[] consoles) {
        if (this.isAvailable()) {
            Runnable r = () -> {
                int i = 0;
                while (i < consoles.length) {
                    if (this.isAvailable()) {
                        IConsole[] available;
                        IConsole console = consoles[i];
                        this.fStack.remove(console);
                        ConsoleWorkbenchPart part = this.fConsoleToPart.get(console);
                        if (part != null) {
                            this.partClosed(part);
                        }
                        if (this.getConsole() == null && (available = new IConsole[0]).length > 0) {
                            this.display(available[available.length - 1]);
                        }
                    }
                    ++i;
                }
            };
            this.asyncExec(r);
        }
    }

    public ScriptDisplayView() {
        this.fConsoleToPart = new LinkedHashMap<IConsole, ConsoleWorkbenchPart>();
        this.fPartToConsole = new HashMap<ConsoleWorkbenchPart, IConsole>();
        this.fConsoleToPageParticipants = new HashMap<IConsole, ListenerList<IConsolePageParticipant>>();
    }

    protected void createActions() {
        this.fPinAction = new PinConsoleAction((IConsoleView)this);
        this.fDisplayConsoleAction = new ConsoleDropDownAction(this);
        IEvaluateConsoleFactory[] extensions = (IEvaluateConsoleFactory[])EvaluateConsoleFactoryManager.getManager().getInstances();
        if (extensions.length > 0) {
            this.fOpenConsoleAction = new OpenConsoleAction(this, extensions);
        }
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.add((IContributionItem)new Separator("launchGroup"));
        mgr.add((IContributionItem)new Separator("outputGroup"));
        mgr.add((IContributionItem)new Separator("fixedGroup"));
        mgr.add((IAction)this.fPinAction);
        mgr.add((IAction)this.fDisplayConsoleAction);
        if (this.fOpenConsoleAction != null) {
            mgr.add((IAction)this.fOpenConsoleAction);
            if (mgr instanceof ToolBarManager) {
                ToolBarManager tbm = (ToolBarManager)mgr;
                final ToolBar tb = tbm.getControl();
                tb.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        ActionContributionItem actionContributionItem;
                        IAction action;
                        ToolItem ti = tb.getItem(new Point(e.x, e.y));
                        if (ti != null && ti.getData() instanceof ActionContributionItem && (action = (actionContributionItem = (ActionContributionItem)ti.getData()).getAction()) == ScriptDisplayView.this.fOpenConsoleAction) {
                            Event event = new Event();
                            event.widget = ti;
                            event.x = e.x;
                            event.y = e.y;
                            action.runWithEvent(event);
                        }
                    }
                });
            }
        }
    }

    public void display(IConsole console) {
        if (this.fPinned && this.fActiveConsole != null) {
            return;
        }
        if (console.equals(this.fActiveConsole)) {
            return;
        }
        ConsoleWorkbenchPart part = this.fConsoleToPart.get(console);
        if (part != null) {
            this.partActivated(part);
        }
    }

    public void setPinned(boolean pin) {
        this.fPinned = pin;
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
    }

    public boolean isPinned() {
        return this.fPinned;
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(r);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.configureToolBar(tbm);
        this.updateForExistingConsoles();
        this.getViewSite().getActionBars().updateActionBars();
        this.getViewSite().getPage().addPartListener((IPartListener2)this);
        this.initPageSwitcher();
        this.createDebugConsole();
    }

    private void createDebugConsole() {
        this.addConsole(new DebugConsole(Messages.ScriptDisplayView_consoleName, DebugConsole.class.getName(), new DebugScriptInterpreter((IViewPart)this)));
    }

    private void initPageSwitcher() {
        new PageSwitcher((IWorkbenchPart)this){

            public void activatePage(Object page) {
                ShowConsoleAction.showConsole((IConsole)((IConsole)page), (IConsoleView)ScriptDisplayView.this);
            }

            public ImageDescriptor getImageDescriptor(Object page) {
                return ((IConsole)page).getImageDescriptor();
            }

            public String getName(Object page) {
                return ((IConsole)page).getName();
            }

            public Object[] getPages() {
                return ScriptDisplayView.this.getConsoles();
            }

            public int getCurrentPageIndex() {
                IConsole currentConsole = ScriptDisplayView.this.getConsole();
                IConsole[] consoles = ScriptDisplayView.this.getConsoles();
                int i = 0;
                while (i < consoles.length) {
                    if (consoles[i].equals(currentConsole)) {
                        return i;
                    }
                    ++i;
                }
                return super.getCurrentPageIndex();
            }
        };
    }

    public IConsole[] getConsoles() {
        return this.fConsoleToPart.keySet().toArray(new IConsole[this.fConsoleToPart.size()]);
    }

    private void updateForExistingConsoles() {
    }

    public void warnOfContentChange(IConsole console) {
        IWorkbenchSiteProgressService service;
        IWorkbenchPart part = this.fConsoleToPart.get(console);
        if (part != null && (service = (IWorkbenchSiteProgressService)part.getSite().getAdapter(IWorkbenchSiteProgressService.class)) != null) {
            service.warnOfContentChange();
        }
    }

    public <T> T getAdapter(Class<T> key) {
        ListenerList<IConsolePageParticipant> listeners;
        IConsole console;
        Object adpater = super.getAdapter(key);
        if (adpater == null && (console = this.getConsole()) != null && (listeners = this.getParticipants(console)) != null) {
            for (IConsolePageParticipant participant : listeners) {
                adpater = participant.getAdapter(key);
                if (adpater == null) continue;
                return (T)adpater;
            }
        }
        return (T)adpater;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.fActive = true;
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            if (contextService != null) {
                this.fActivatedContext = contextService.activateContext("org.eclipse.ui.console.ConsoleView");
                this.activateParticipants(this.fActiveConsole);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        if (this.isThisPart(partRef)) {
            this.fActive = false;
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            if (contextService != null) {
                contextService.deactivateContext(this.fActivatedContext);
                this.deactivateParticipants(this.fActiveConsole);
            }
        }
    }

    protected boolean isThisPart(IWorkbenchPartReference partRef) {
        if (partRef instanceof IViewReference) {
            IViewReference viewRef = (IViewReference)partRef;
            if (this.getViewSite() != null && viewRef.getId().equals(this.getViewSite().getId())) {
                String secId = viewRef.getSecondaryId();
                String mySec = null;
                if (this.getSite() instanceof IViewSite) {
                    mySec = ((IViewSite)this.getSite()).getSecondaryId();
                }
                if (mySec == null) {
                    return secId == null;
                }
                return mySec.equals(secId);
            }
        }
        return false;
    }

    private void deactivateParticipants(IConsole console) {
        ListenerList<IConsolePageParticipant> listeners;
        if (console != null && (listeners = this.getParticipants(console)) != null) {
            for (final IConsolePageParticipant participant : listeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        participant.deactivated();
                    }

                    public void handleException(Throwable exception) {
                        DLTKDebugUIPlugin.log(exception);
                        listeners.remove((Object)participant);
                    }
                });
            }
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void setScrollLock(boolean scrollLock) {
        this.fScrollLock = scrollLock;
        IPage page = this.getCurrentPage();
    }

    public boolean getScrollLock() {
        return this.fScrollLock;
    }

    public void pin(IConsole console) {
        if (console == null) {
            this.setPinned(false);
        } else {
            if (this.isPinned()) {
                this.setPinned(false);
            }
            this.display(console);
            this.setPinned(true);
        }
    }

    public void addConsoleListener(IEvaluateConsoleListener listener) {
        this.consoleListeners.add((Object)listener);
    }

    public void removeConsoleListener(IEvaluateConsoleListener listener) {
        this.consoleListeners.remove((Object)listener);
    }

    public void setAutoScrollLock(boolean scrollLock) {
    }

    public boolean getAutoScrollLock() {
        return false;
    }
}

