/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.SourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.VariableSourceGenerator;

public class AnnotationSourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = -6466348844734237149L;
    private TypeDeclarationSourceGenerator type;
    private String name;
    private BodySourceGenerator body;

    public AnnotationSourceGenerator(String simpleName) {
        this.name = simpleName;
    }

    public static AnnotationSourceGenerator create(String name) {
        return new AnnotationSourceGenerator(name);
    }

    public static AnnotationSourceGenerator create(Class<?> cls) {
        AnnotationSourceGenerator annotation = new AnnotationSourceGenerator(cls.getSimpleName());
        annotation.type = TypeDeclarationSourceGenerator.create(cls);
        return annotation;
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        ArrayList<TypeDeclarationSourceGenerator> types = new ArrayList<TypeDeclarationSourceGenerator>();
        Optional.ofNullable(this.body).ifPresent(hirearchyElements -> types.addAll(this.body.getTypeDeclarations()));
        Optional.ofNullable(this.type).ifPresent(hirearchyElement -> types.add(this.type));
        return types;
    }

    public AnnotationSourceGenerator addParameter(VariableSourceGenerator ... parameters) {
        return this.addParameter((String)null, parameters);
    }

    public AnnotationSourceGenerator addParameter(String name, VariableSourceGenerator ... parameters) {
        return this.addParameter(name, false, parameters);
    }

    public AnnotationSourceGenerator addParameter(String name, boolean isArray, VariableSourceGenerator ... parameters) {
        Optional.ofNullable(this.body).orElseGet(() -> {
            this.body = BodySourceGenerator.createSimple().setDelimiters("(\n", "\n)").setBodyElementSeparator(",\n").setElementPrefix("\t");
            return this.body;
        });
        BodySourceGenerator innBody = BodySourceGenerator.createSimple().setBodyElementSeparator(",\n").setElementPrefix("\t");
        if (name != null) {
            if (isArray) {
                innBody.setDelimiters(name + " = {\n", "\n}");
            } else {
                innBody.setDelimiters(name + " = ", null);
            }
        } else if (isArray) {
            innBody.setDelimiters("{", "}");
        } else {
            innBody.setElementPrefix(null);
        }
        for (VariableSourceGenerator parameter : parameters) {
            innBody.addElement(parameter.setDelimiter(null));
        }
        this.body.addElement(innBody);
        return this;
    }

    public AnnotationSourceGenerator addParameter(AnnotationSourceGenerator ... parameters) {
        return this.addParameter(null, false, parameters);
    }

    public AnnotationSourceGenerator addParameter(boolean isArray, AnnotationSourceGenerator ... parameters) {
        return this.addParameter(null, isArray, parameters);
    }

    public AnnotationSourceGenerator addParameter(String name, AnnotationSourceGenerator ... parameters) {
        return this.addParameter(name, false, parameters);
    }

    public AnnotationSourceGenerator addParameter(String name, boolean isArray, AnnotationSourceGenerator ... parameters) {
        Optional.ofNullable(this.body).orElseGet(() -> {
            this.body = BodySourceGenerator.createSimple().setDelimiters("(\n", "\n)").setBodyElementSeparator(",\n").setElementPrefix("\t");
            return this.body;
        });
        BodySourceGenerator innBody = BodySourceGenerator.createSimple().setBodyElementSeparator(",\n").setElementPrefix("\t");
        if (name != null) {
            if (isArray) {
                innBody.setDelimiters(name + " = {\n", "\n}");
            } else {
                innBody.setDelimiters(name + " = ", null);
            }
        } else if (isArray) {
            innBody.setDelimiters("{", "}");
        } else {
            innBody.setElementPrefix(null);
        }
        for (AnnotationSourceGenerator parameter : parameters) {
            innBody.addElement(parameter);
        }
        this.body.addElement(innBody);
        return this;
    }

    public AnnotationSourceGenerator useType(Class<?> ... classes) {
        Optional.ofNullable(this.body).orElseGet(() -> {
            this.body = BodySourceGenerator.createSimple().setDelimiters("(\n", "\n)").setBodyElementSeparator(",\n").setElementPrefix("\t");
            return this.body;
        });
        this.body.useType(classes);
        return this;
    }

    @Override
    public String make() {
        return this.getOrEmpty("@" + this.name, this.body);
    }
}

