/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.common;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.common.CollapseableSection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CompositeEditSection
extends CollapseableSection {
    protected Button[] _buttons;
    protected Composite _left;
    protected Composite _buttonComp;
    protected String[] _buttonTexts;
    protected String _despText;
    private int _buttonWidth;
    public static final int BUTTON_WIDTH = 80;

    public CompositeEditSection(FormToolkit toolkit, String title, Display display, boolean isCollapseable, boolean isCollapsed, int estyle, String[] buttonTexts, int buttonWidth) {
        super(toolkit, title, display, isCollapseable, isCollapsed, estyle);
        this._buttonTexts = buttonTexts;
        this._buttonWidth = buttonWidth;
    }

    public CompositeEditSection(FormToolkit toolkit, String title, Display display, boolean isCollapseable, boolean isCollapsed, int estyle, String[] buttonTexts, int buttonWidth, String despText) {
        this(toolkit, title, display, isCollapseable, isCollapsed, estyle | (despText != null && !despText.trim().equals("") ? 128 : 0), buttonTexts, buttonWidth);
        this._despText = despText;
    }

    @Override
    protected void createSectionContent(Composite parent) {
        Assert.isNotNull((Object)this._buttonTexts);
        this.getSection().setLayout((Layout)new GridLayout());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        if (this._despText != null && !this._despText.trim().equals("")) {
            this.getSection().setDescription(this._despText);
        }
        this._left = this._toolkit.createComposite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 1;
        this._left.setLayout((Layout)layout);
        this._left.setLayoutData((Object)new GridData(1808));
        this._buttonComp = this._toolkit.createComposite(parent);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this._buttonComp.setLayout((Layout)layout);
        this._buttonComp.setLayoutData((Object)new GridData(1040));
        if (this._buttonWidth < 0) {
            this._buttonWidth = 80;
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        int i = 0;
        while (i < this._buttonTexts.length) {
            if (this._buttonTexts[i] != null) {
                Button b = this._toolkit.createButton(this._buttonComp, "", 0);
                b.setText(this._buttonTexts[i]);
                GridData gd = new GridData();
                gd.widthHint = this._buttonWidth;
                b.setLayoutData((Object)gd);
                b.setData((Object)i);
                b.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                        CompositeEditSection.this.buttonSelected(e, (Integer)e.widget.getData());
                    }

                    public void widgetSelected(SelectionEvent e) {
                        CompositeEditSection.this.buttonSelected(e, (Integer)e.widget.getData());
                    }
                });
                buttons.add(b);
            }
            ++i;
        }
        Composite blankComp = this._toolkit.createComposite(this._buttonComp, 0);
        blankComp.setLayoutData((Object)new GridData(1808));
        this._toolkit.paintBordersFor(parent);
        this._buttons = buttons.toArray(new Button[buttons.size()]);
    }

    public Composite getLeftComposite() {
        return this._left;
    }

    public Button[] getButtons() {
        return this._buttons;
    }

    public Composite getButtonComp() {
        return this._buttonComp;
    }

    public void enableButton(boolean enable, int buttonIndex) {
        if (this._buttons == null || buttonIndex < 0 || buttonIndex > this._buttons.length - 1) {
            return;
        }
        this._buttons[buttonIndex].setEnabled(enable);
    }

    public boolean isButtonEnabled(boolean enable, int buttonIndex) {
        if (this._buttons == null || buttonIndex < 0 || buttonIndex > this._buttons.length - 1) {
            return false;
        }
        return this._buttons[buttonIndex].isEnabled();
    }

    protected void buttonSelected(SelectionEvent e, int buttonIndex) {
    }
}

