/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.cm;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.osgi.test.common.annotation.config.WithConfiguration;
import org.osgi.test.common.annotation.config.WithConfigurations;
import org.osgi.test.common.annotation.config.WithFactoryConfiguration;
import org.osgi.test.common.annotation.config.WithFactoryConfigurations;

class AnnotationUtil {
    private static Predicate<Annotation> ANY_WITH_CONF_ANNNOTATIONS = t -> t.annotationType().equals(WithFactoryConfiguration.class) || t.annotationType().equals(WithFactoryConfigurations.class) || t.annotationType().equals(WithConfiguration.class) || t.annotationType().equals(WithConfigurations.class);

    private AnnotationUtil() {
    }

    public static List<Annotation> findAllConfigAnnotations(AnnotatedElement annotatedElement) {
        return AnnotationUtil.findAllAnnotationsMatching(annotatedElement, ANY_WITH_CONF_ANNNOTATIONS);
    }

    private static List<Annotation> findAllAnnotationsMatching(AnnotatedElement annotatedElement, Predicate<Annotation> test) {
        ArrayList<Annotation> found = new ArrayList<Annotation>();
        AnnotationUtil.findAllAnnotationsMatching(annotatedElement, test, found, new HashSet<Map.Entry<AnnotatedElement, Annotation>>());
        return found;
    }

    private static void findAllAnnotationsMatching(AnnotatedElement annotatedElement, Predicate<Annotation> test, ArrayList<? super Annotation> found, Set<Map.Entry<AnnotatedElement, Annotation>> visited) {
        Annotation[] annotations;
        for (Annotation ann : annotations = annotatedElement.getAnnotations()) {
            if (AnnotationUtil.isJavaLangAnnotation(ann) || AnnotationUtil.isJunitAnnotation(ann)) continue;
            if (visited.add(new AbstractMap.SimpleEntry<AnnotatedElement, Annotation>(annotatedElement, ann))) {
                AnnotationUtil.findAllAnnotationsMatching(ann.annotationType(), test, found, visited);
            }
            if (!test.test(ann)) continue;
            found.add(ann);
        }
    }

    private static boolean isJavaLangAnnotation(Annotation annotation) {
        return annotation.annotationType().getName().startsWith("java.lang.annotation");
    }

    private static boolean isJunitAnnotation(Annotation annotation) {
        return annotation.annotationType().getName().startsWith("org.junit");
    }
}

