/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.event;

import java.util.function.ToIntFunction;
import org.assertj.core.api.AbstractAssert;
import org.osgi.test.common.bitmaps.Bitmap;

public abstract class AbstractBitmappedTypeEventAssert<SELF extends AbstractBitmappedTypeEventAssert<SELF, ACTUAL>, ACTUAL>
extends AbstractAssert<SELF, ACTUAL> {
    protected final ToIntFunction<ACTUAL> getType;
    protected final Bitmap bitmap;

    protected AbstractBitmappedTypeEventAssert(ACTUAL actual, Class<SELF> selfType, ToIntFunction<ACTUAL> getType, Bitmap bitmap) {
        super(actual, selfType);
        this.getType = getType;
        this.bitmap = bitmap;
    }

    protected int actualType() {
        return this.getType.applyAsInt(this.actual);
    }

    public SELF isOfType(int expected) {
        this.isNotNull();
        if ((expected & expected - 1) != 0) {
            throw new IllegalArgumentException("Multiple bits set in expected (" + expected + ") - do you mean to use isOfTypeMaskedBy()?");
        }
        if ((this.actualType() & expected) == 0) {
            throw this.failure("%nExpecting%n <%s>%nto be of type:%n <%d:%s>%n but was of type:%n <%s>", new Object[]{this.actual, expected, this.bitmap.toString(expected), this.bitmap.maskToString(this.actualType())});
        }
        return (SELF)((Object)((AbstractBitmappedTypeEventAssert)this.myself));
    }

    public SELF isNotOfType(int expected) {
        this.isNotNull();
        if ((this.actualType() & expected) != 0) {
            throw this.failure("%nExpecting%n <%s>%nnot to be of type:%n <%d:%s>%nbut it was", new Object[]{this.actual, expected, this.bitmap.toString(expected)});
        }
        return (SELF)((Object)((AbstractBitmappedTypeEventAssert)this.myself));
    }

    public SELF isOfTypeMaskedBy(int mask) {
        this.isNotNull();
        if (mask <= 0 || mask >= this.bitmap.getKnownMask()) {
            throw new IllegalArgumentException("Mask testing for an illegal type: " + mask);
        }
        if ((this.actualType() & mask) == 0) {
            throw this.failure("%nExpecting%n <%s>%nto be of one of types:%n [%s]%n but was of type:%n <%s>", new Object[]{this.actual, this.bitmap.maskToString(mask), this.bitmap.maskToString(this.actualType())});
        }
        return (SELF)((Object)((AbstractBitmappedTypeEventAssert)this.myself));
    }

    public SELF isNotOfTypeMaskedBy(int mask) {
        this.isNotNull();
        if (mask <= 0 || mask >= this.bitmap.getKnownMask()) {
            throw new IllegalArgumentException("Mask testing for an illegal type: " + mask);
        }
        if ((this.actualType() & mask) != 0) {
            throw this.failure("%nExpecting%n <%s>%nto not be of one of types:%n [%s]%n but was of type:%n <%s>", new Object[]{this.actual, this.bitmap.maskToString(mask), this.bitmap.maskToString(this.actualType())});
        }
        return (SELF)((Object)((AbstractBitmappedTypeEventAssert)this.myself));
    }
}

