/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.item;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class RepresentationDescriptionItemImpl
implements RepresentationDescriptionItem,
Comparable<RepresentationDescriptionItemImpl>,
IAdaptable {
    private final Session session;
    private final RepresentationDescription representationDescription;
    private Resource resource;
    private boolean filterForResource;
    private final Object parent;
    private Viewpoint viewpoint;

    public RepresentationDescriptionItemImpl(Session session, RepresentationDescription representationDescription, Object parent) {
        this.session = session;
        this.representationDescription = representationDescription;
        this.parent = parent;
    }

    public RepresentationDescriptionItemImpl(Session session, RepresentationDescription representationDescription, Object parent, Viewpoint descriptionViewpoint) {
        this.session = session;
        this.representationDescription = representationDescription;
        this.parent = parent;
        this.viewpoint = descriptionViewpoint;
    }

    public RepresentationDescriptionItemImpl(Session session, RepresentationDescription representationDescription, Resource resource, Object parent) {
        this(session, representationDescription, parent);
        this.resource = resource;
        this.filterForResource = true;
    }

    public Viewpoint getViewpoint() {
        return this.viewpoint;
    }

    @Override
    public Object getWrappedObject() {
        return this.representationDescription;
    }

    @Override
    public int compareTo(RepresentationDescriptionItemImpl o) {
        if (this.representationDescription != null && this.representationDescription.getName() != null && o.representationDescription != null && o.representationDescription.getName() != null) {
            return this.representationDescription.getName().compareTo(o.representationDescription.getName());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (this == obj) {
            result = true;
        } else if (obj instanceof RepresentationDescriptionItemImpl) {
            RepresentationDescriptionItemImpl rdiObj = (RepresentationDescriptionItemImpl)obj;
            result = EqualityHelper.areEquals((EObject)this.representationDescription, (EObject)rdiObj.representationDescription);
            result = result && this.parent.equals(rdiObj.parent);
        }
        return result;
    }

    public int hashCode() {
        return (this.representationDescription != null ? this.representationDescription.hashCode() : 0) + this.parent.hashCode();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == EObject.class) {
            return this.representationDescription;
        }
        return null;
    }

    @Override
    public Option<Session> getSession() {
        return Options.newSome((Object)this.session);
    }

    public Collection<?> getChildren() {
        Collection repDescriptorsCandidates = DialectManager.INSTANCE.getRepresentationDescriptors(this.representationDescription, this.session);
        ArrayList<RepresentationItemImpl> representations = new ArrayList<RepresentationItemImpl>();
        if (this.filterForResource) {
            for (DRepresentationDescriptor repDescriptor : repDescriptorsCandidates) {
                Resource representationResource = repDescriptor.eResource();
                if (representationResource == null || !representationResource.equals(this.resource)) continue;
                representations.add(new RepresentationItemImpl(repDescriptor, this));
            }
        } else {
            for (DRepresentationDescriptor repDescriptor : repDescriptorsCandidates) {
                representations.add(new RepresentationItemImpl(repDescriptor, this));
            }
        }
        Collections.sort(representations, Ordering.natural().onResultOf((Function)new Function<RepresentationItemImpl, String>(){

            public String apply(RepresentationItemImpl from) {
                return from.getDRepresentationDescriptor().getName();
            }
        }));
        return representations;
    }

    public boolean isFilterForResource() {
        return this.filterForResource;
    }

    public void setFilterForResource(boolean filterForResource) {
        this.filterForResource = filterForResource;
    }

    public Object getParent() {
        return this.parent;
    }
}

