/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtresourceprovider.DTResourceProviderFactory;
import org.eclipse.jst.pagedesigner.dtresourceprovider.DTSkinManager;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTResourceProvider;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTSkin;
import org.eclipse.jst.pagedesigner.ui.dialogs.DialogsMessages;
import org.eclipse.jst.pagedesigner.utils.EditorUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class WPEPropertyPage
extends PropertyPage {
    private IProject project;
    private TableViewer taglibTable;
    private TableViewer skinsTable;
    private Button currentButton;
    private Map<String, IDTSkin> localCurrentSkinMap = new HashMap<String, IDTSkin>();

    public String getDescription() {
        return DialogsMessages.getString("WPEPropertyPage.Description");
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginWidth = 0;
        top.setLayout((Layout)topLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, true));
        Label taglibLabel = new Label(top, 0);
        taglibLabel.setText(DialogsMessages.getString("WPEPropertyPage.TagLibs.Label"));
        taglibLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(top, 0).setVisible(false);
        this.taglibTable = new TableViewer(top, 2820);
        this.taglibTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.taglibTable.getTable().addSelectionListener((SelectionListener)new TaglibSelectionListener());
        this.taglibTable.setContentProvider((IContentProvider)new TaglibContentProvider());
        this.taglibTable.setLabelProvider((IBaseLabelProvider)new TaglibLabelProvider());
        this.taglibTable.setInput((Object)this.project);
        new Label(top, 0).setVisible(false);
        Label skinsLabel = new Label(top, 0);
        skinsLabel.setText(DialogsMessages.getString("WPEPropertyPage.Skins.Label"));
        skinsLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        new Label(top, 0).setVisible(false);
        this.skinsTable = new TableViewer(top, 2820);
        this.skinsTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.skinsTable.getTable().addSelectionListener((SelectionListener)new SkinSelectionListener());
        this.skinsTable.setContentProvider((IContentProvider)new SkinContentProvider());
        this.skinsTable.setLabelProvider((IBaseLabelProvider)new SkinLabelProvider());
        Composite buttons = new Composite(top, 0);
        GridLayout buttonsLayout = new GridLayout(1, true);
        buttonsLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonsLayout);
        buttons.setLayoutData((Object)new GridData(4, 4, false, false));
        this.currentButton = new Button(buttons, 0);
        this.currentButton.setText(DialogsMessages.getString("WPEPropertyPage.Current.Button"));
        this.currentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String nsURI = WPEPropertyPage.this.getCurrentNSURI();
                IStructuredSelection selection = (IStructuredSelection)WPEPropertyPage.this.skinsTable.getSelection();
                IDTSkin dtSkin = (IDTSkin)selection.getFirstElement();
                if (dtSkin != null) {
                    WPEPropertyPage.this.localCurrentSkinMap.put(nsURI, dtSkin);
                    WPEPropertyPage.this.skinsTable.refresh();
                    WPEPropertyPage.this.updateButtons();
                }
            }
        });
        this.updateButtons();
        return top;
    }

    public void setElement(IAdaptable element) {
        Object objElement = element.getAdapter(IProject.class);
        if (objElement != null) {
            this.project = (IProject)objElement;
            if (this.taglibTable != null) {
                this.taglibTable.setInput(objElement);
            }
        }
        super.setElement(element);
    }

    protected void performDefaults() {
        List<TaglibData> taglibDataList = this.getTaglibDataList();
        for (TaglibData taglibData : taglibDataList) {
            String nsURI = taglibData.getNSURI();
            IDTSkin defaultDTSkin = DTSkinManager.getInstance(this.project).getDefaultSkin(nsURI);
            this.localCurrentSkinMap.put(nsURI, defaultDTSkin);
        }
        this.skinsTable.refresh();
        this.updateButtons();
        super.performDefaults();
    }

    public boolean performOk() {
        Set<String> keys = this.localCurrentSkinMap.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key;
            String nsURI = key = iterator.next();
            IDTSkin dtSkin = this.localCurrentSkinMap.get(nsURI);
            DTSkinManager.getInstance(this.project).setCurrentSkin(nsURI, dtSkin);
        }
        EditorUtil.refreshAllWPEDesignViewers();
        return super.performOk();
    }

    private IDTSkin getLocalCurrentSkin() {
        IDTSkin localCurrentSkin = null;
        String nsURI = this.getCurrentNSURI();
        localCurrentSkin = this.localCurrentSkinMap.get(nsURI);
        if (localCurrentSkin == null) {
            localCurrentSkin = DTSkinManager.getInstance(this.project).getCurrentSkin(nsURI);
        }
        return localCurrentSkin;
    }

    private String getCurrentNSURI() {
        Object objInput;
        String nsURI = null;
        if (this.skinsTable != null && (objInput = this.skinsTable.getInput()) instanceof TaglibData) {
            nsURI = ((TaglibData)objInput).getNSURI();
        }
        return nsURI;
    }

    private List<TaglibData> getTaglibDataList() {
        ArrayList<TaglibData> taglibDataList = new ArrayList<TaglibData>();
        List<IDTResourceProvider> resourceProviders = DTResourceProviderFactory.getInstance().getActiveDTResourceProviders(this.project);
        for (IDTResourceProvider resourceProvider : resourceProviders) {
            TaglibData taglibData = new TaglibData(resourceProvider.getId());
            if (taglibDataList.contains(taglibData)) continue;
            taglibDataList.add(taglibData);
        }
        return taglibDataList;
    }

    private void updateButtons() {
        IDTSkin localCurrentSkin;
        Object selectedObject;
        IStructuredSelection selection;
        boolean currentButtonEnabled = false;
        if (this.skinsTable != null && (selection = (IStructuredSelection)this.skinsTable.getSelection()) != null && (selectedObject = selection.getFirstElement()) instanceof IDTSkin && (IDTSkin)selectedObject != (localCurrentSkin = this.getLocalCurrentSkin())) {
            currentButtonEnabled = true;
        }
        this.currentButton.setEnabled(currentButtonEnabled);
    }

    private class SkinContentProvider
    implements IStructuredContentProvider {
        private SkinContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List<IDTSkin> skinList = inputElement instanceof TaglibData ? DTSkinManager.getInstance(WPEPropertyPage.this.project).getSkins(((TaglibData)inputElement).getNSURI()) : Collections.EMPTY_LIST;
            return skinList.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
            WPEPropertyPage.this.updateButtons();
        }

        public void dispose() {
        }
    }

    private class SkinLabelProvider
    extends LabelProvider {
        private SkinLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof IDTSkin) {
                image = PDPlugin.getDefault().getImage("skin.png");
            }
            return image;
        }

        public String getText(Object element) {
            Object text = null;
            if (element instanceof IDTSkin) {
                IDTSkin dtSkin = (IDTSkin)element;
                text = dtSkin.getName();
                if (dtSkin == WPEPropertyPage.this.getLocalCurrentSkin()) {
                    text = (String)text + " " + DialogsMessages.getString("WPEPropertyPage.Skins.Item.Current");
                }
            }
            return text;
        }
    }

    private class SkinSelectionListener
    implements SelectionListener {
        private SkinSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            WPEPropertyPage.this.updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private class TaglibContentProvider
    implements IStructuredContentProvider {
        private TaglibContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return WPEPropertyPage.this.getTaglibDataList().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public void dispose() {
        }
    }

    private class TaglibData {
        private String nsURI;
        private String name;

        public TaglibData(String nsURI) {
            this.nsURI = nsURI;
            IMetaDataDomainContext mdcontext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(WPEPropertyPage.this.project);
            ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(mdcontext);
            Model model = query.findTagLibraryModel(nsURI);
            Trait trait = query.findTrait((Entity)model, "display-label");
            this.name = TraitValueHelper.getValueAsString((Trait)trait);
        }

        public String getNSURI() {
            return this.nsURI;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int nsURIHashCode = 0;
            if (this.nsURI != null) {
                nsURIHashCode = this.nsURI.hashCode();
            }
            int nameHashCode = 0;
            if (this.name != null) {
                nameHashCode = this.name.hashCode();
            }
            return nameHashCode | nsURIHashCode;
        }
    }

    private class TaglibLabelProvider
    extends LabelProvider {
        private TaglibLabelProvider() {
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof TaglibData) {
                image = PDPlugin.getDefault().getImage("library_obj.gif");
            }
            return image;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof TaglibData) {
                TaglibData taglibData = (TaglibData)element;
                text = taglibData.getName() != null ? taglibData.getName() : taglibData.getNSURI();
            }
            return text;
        }
    }

    private class TaglibSelectionListener
    implements SelectionListener {
        private TaglibSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            Object obj = event.item.getData();
            if (obj instanceof TaglibData) {
                WPEPropertyPage.this.skinsTable.setInput(obj);
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }
}

