/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class ArrayEvaluator
implements IExpressionEvaluator {
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (expression instanceof ArrayCreation) {
            ArrayCreation creation = (ArrayCreation)expression;
            ArrayInitializer initializer = creation.getInitializer();
            Object array = initializer != null ? AstEvaluationEngine.evaluate(context, (Expression)initializer) : ArrayEvaluator.evaluateEmpty(context, typeBinding, creation);
            List<Assignment> assignments = ExecutionFlowUtils2.getAssignmentValue0(expression);
            for (Assignment assignment : assignments) {
                ExecutionUtils.runLog(() -> ArrayEvaluator.evaluateArrayAssignment(array, context, assignment));
            }
            return array;
        }
        if (expression instanceof ArrayInitializer) {
            ArrayInitializer initializer = (ArrayInitializer)expression;
            return ArrayEvaluator.evaluateInitializer(context, typeBinding, initializer);
        }
        if (expression instanceof ArrayAccess) {
            ArrayAccess arrayAccess = (ArrayAccess)expression;
            Expression arrayExpression = arrayAccess.getArray();
            Expression indexExpression = arrayAccess.getIndex();
            Object arrayObject = AstEvaluationEngine.evaluate(context, arrayExpression);
            Object indexObject = AstEvaluationEngine.evaluate(context, indexExpression);
            if (indexObject instanceof Integer) {
                int index = (Integer)indexObject;
                return Array.get(arrayObject, index);
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static void evaluateArrayAssignment(Object arrayObject, EvaluationContext context, Assignment assignment) throws Exception {
        ArrayAccess arrayAccess = (ArrayAccess)assignment.getLeftHandSide();
        Expression indexExpression = arrayAccess.getIndex();
        Expression valueExpression = assignment.getRightHandSide();
        Object indexObject = AstEvaluationEngine.evaluate(context, indexExpression);
        Object valueObject = AstEvaluationEngine.evaluate(context, valueExpression);
        if (indexObject instanceof Integer) {
            Integer index = (Integer)indexObject;
            Array.set(arrayObject, index, valueObject);
        }
    }

    private static Object evaluateEmpty(EvaluationContext context, ITypeBinding typeBinding, ArrayCreation creation) throws Exception {
        ITypeBinding elementTypeBinding = typeBinding.getElementType();
        Assert.isNotNull((Object)elementTypeBinding);
        String elementTypeName = AstNodeUtils.getFullyQualifiedName(elementTypeBinding, false);
        Class elementType = ReflectionUtils.getClassByName((ClassLoader)context.getClassLoader(), (String)elementTypeName);
        List<Expression> dimensionExpressions = DomGenerics.dimensions(creation);
        int[] dimensions = new int[dimensionExpressions.size()];
        int i = 0;
        while (i < dimensions.length) {
            Expression dimensionExpression = dimensionExpressions.get(i);
            dimensions[i] = (Integer)AstEvaluationEngine.evaluate(context, dimensionExpression);
            ++i;
        }
        return Array.newInstance(elementType, dimensions);
    }

    private static Object evaluateInitializer(EvaluationContext context, ITypeBinding typeBinding, ArrayInitializer initializer) throws Exception {
        ITypeBinding elementTypeBinding = typeBinding.getElementType();
        Assert.isNotNull((Object)elementTypeBinding);
        String elementTypeName = AstNodeUtils.getFullyQualifiedName(elementTypeBinding, false);
        Class elementType = ReflectionUtils.getClassByName((ClassLoader)context.getClassLoader(), (String)elementTypeName);
        List<Expression> expressions = DomGenerics.expressions(initializer);
        int length = expressions.size();
        int[] dimensions = new int[typeBinding.getDimensions()];
        dimensions[0] = length;
        if (typeBinding.getDimensions() == 1 && elementTypeBinding.isPrimitive()) {
            Object values = Array.newInstance(elementType, dimensions);
            int index = 0;
            while (index < length) {
                Expression element = expressions.get(index);
                Object elementValue = AstEvaluationEngine.evaluate(context, element);
                if (elementType == Boolean.TYPE) {
                    Array.setBoolean(values, index, (Boolean)elementValue);
                } else if (elementType == Character.TYPE) {
                    char charValue = elementValue instanceof Number ? (char)((Number)elementValue).intValue() : ((Character)elementValue).charValue();
                    Array.setChar(values, index, charValue);
                } else {
                    Number number = (Number)elementValue;
                    if (elementType == Byte.TYPE) {
                        Array.setByte(values, index, number.byteValue());
                    } else if (elementType == Short.TYPE) {
                        Array.setShort(values, index, number.shortValue());
                    } else if (elementType == Integer.TYPE) {
                        Array.setInt(values, index, number.intValue());
                    } else if (elementType == Long.TYPE) {
                        Array.setLong(values, index, number.longValue());
                    } else if (elementType == Float.TYPE) {
                        Array.setFloat(values, index, number.floatValue());
                    } else if (elementType == Double.TYPE) {
                        Array.setDouble(values, index, number.doubleValue());
                    }
                }
                ++index;
            }
            return values;
        }
        Object[] values = (Object[])Array.newInstance(elementType, dimensions);
        int index = 0;
        while (index < length) {
            Object value;
            Expression element = expressions.get(index);
            values[index] = value = AstEvaluationEngine.evaluate(context, element);
            ++index;
        }
        return values;
    }
}

