/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.weightedtree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.analysis.profiling.core.tree.WeightedTree;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.weightedtree.WeightedTreePieChartViewer;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.weightedtree.WeightedTreeViewer;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;

public class WeightedTreeView
extends TmfView {
    public static final String ID = "org.eclipse.tracecompass.analysis.profiling.ui.weightedtree";
    private @Nullable AbstractTmfTreeViewer fWeightedTreeViewer = null;
    private @Nullable WeightedTreePieChartViewer fPieChartViewer = null;
    private @Nullable String fAnalysisId = null;
    private @Nullable SashForm fSash = null;

    public WeightedTreeView() {
        super("WeightedTreeView");
    }

    public void createPartControl(@Nullable Composite parent) {
        String analysisId;
        super.createPartControl(parent);
        this.fAnalysisId = analysisId = NonNullUtils.nullToEmptyString((Object)this.getViewSite().getSecondaryId());
        this.fSash = new SashForm(parent, 256);
        WeightedTreeViewer weightedTreeViewer = new WeightedTreeViewer((Composite)this.fSash, this);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            weightedTreeViewer.loadTrace(trace);
        }
        this.fWeightedTreeViewer = weightedTreeViewer;
        WeightedTreePieChartViewer pieChartViewer = new WeightedTreePieChartViewer((Composite)this.fSash, this);
        if (trace != null) {
            pieChartViewer.loadTrace(trace);
        }
        this.fPieChartViewer = pieChartViewer;
    }

    Set<IWeightedTreeProvider<?, ?, WeightedTree<?>>> getWeightedTrees(ITmfTrace trace) {
        String analysisId = this.fAnalysisId;
        if (analysisId == null) {
            return Collections.emptySet();
        }
        Iterable callgraphModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, IWeightedTreeProvider.class);
        HashSet set = new HashSet();
        for (IWeightedTreeProvider treeProvider : callgraphModules) {
            if (!(treeProvider instanceof IAnalysisModule) || !((IAnalysisModule)treeProvider).getId().equals(analysisId)) continue;
            set.add(treeProvider);
        }
        return set;
    }

    public void setFocus() {
        AbstractTmfTreeViewer treeViewer = this.fWeightedTreeViewer;
        if (treeViewer != null) {
            treeViewer.getControl().setFocus();
        }
    }

    public void dispose() {
        WeightedTreePieChartViewer pieChartViewer;
        super.dispose();
        AbstractTmfTreeViewer treeViewer = this.fWeightedTreeViewer;
        if (treeViewer != null) {
            treeViewer.dispose();
        }
        if ((pieChartViewer = this.fPieChartViewer) != null) {
            pieChartViewer.dispose();
        }
    }

    public void elementSelected(Set<WeightedTree<?>> trees, IWeightedTreeProvider<?, ?, WeightedTree<?>> treeProvider) {
        WeightedTreePieChartViewer pieChartViewer = this.fPieChartViewer;
        if (pieChartViewer != null) {
            pieChartViewer.elementSelected(trees, treeProvider);
        }
    }
}

