/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.qttest;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.eclipse.cdt.testsrunner.internal.qttest.QtTestsRunnerMessages;
import org.eclipse.cdt.testsrunner.internal.qttest.QtXmlLogHandler;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.eclipse.cdt.testsrunner.model.TestingException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QtTestsRunnerProvider
implements ITestsRunnerProvider {
    private boolean isSpecialTestPath(String[] testPath) {
        if (testPath.length <= 1) {
            return true;
        }
        String testName = testPath[testPath.length - 1];
        return testName.equals("initTestCase") || testName.equals("cleanupTestCase");
    }

    private int getNonSpecialTestsCount(String[][] testPaths) {
        int result = 0;
        int i = 0;
        while (i < testPaths.length) {
            String[] testPath = testPaths[i];
            result += this.isSpecialTestPath(testPath) ? 0 : 1;
            ++i;
        }
        return result;
    }

    public String[] getAdditionalLaunchParameters(String[][] testPaths) throws TestingException {
        String[] qtParameters;
        String[] result = qtParameters = new String[]{"-xml"};
        if (testPaths != null) {
            int testPathsLength = this.getNonSpecialTestsCount(testPaths);
            if (testPathsLength == 0 != (testPaths.length == 0)) {
                throw new TestingException(QtTestsRunnerMessages.QtTestsRunner_no_test_cases_to_rerun);
            }
            if (testPathsLength >= 1) {
                result = new String[qtParameters.length + testPathsLength];
                System.arraycopy(qtParameters, 0, result, 0, qtParameters.length);
                int resultIdx = qtParameters.length;
                int i = 0;
                while (i < testPaths.length) {
                    String[] testPath = testPaths[i];
                    if (!this.isSpecialTestPath(testPath)) {
                        result[resultIdx] = testPath[testPath.length - 1];
                        ++resultIdx;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private String getErrorText(String prefix, String description) {
        return MessageFormat.format(QtTestsRunnerMessages.QtTestsRunner_error_format, prefix, description);
    }

    public void run(ITestModelUpdater modelUpdater, InputStream inputStream) throws TestingException {
        try {
            SAXParser sp = XmlProcessorFactoryCdt.createSAXParserWithErrorOnDOCTYPE();
            sp.parse(inputStream, (DefaultHandler)new QtXmlLogHandler(modelUpdater));
        }
        catch (IOException e) {
            throw new TestingException(this.getErrorText(QtTestsRunnerMessages.QtTestsRunner_io_error_prefix, e.getLocalizedMessage()));
        }
        catch (ParserConfigurationException e) {
            throw new TestingException(this.getErrorText(QtTestsRunnerMessages.QtTestsRunner_xml_error_prefix, e.getLocalizedMessage()));
        }
        catch (SAXException e) {
            throw new TestingException(this.getErrorText(QtTestsRunnerMessages.QtTestsRunner_xml_error_prefix, e.getLocalizedMessage()));
        }
    }
}

