/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.DoubleClickDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;

public class MappingBasedToolDescriptionQuery {
    private MappingBasedToolDescription toolDescription;

    public MappingBasedToolDescriptionQuery(MappingBasedToolDescription toolDescription) {
        this.toolDescription = toolDescription;
    }

    public Collection<RepresentationElementMapping> getMappings() {
        LinkedHashSet<RepresentationElementMapping> mappings = new LinkedHashSet<RepresentationElementMapping>();
        if (this.toolDescription instanceof ContainerCreationDescription) {
            ContainerCreationDescription ccd = (ContainerCreationDescription)this.toolDescription;
            mappings.addAll((Collection<RepresentationElementMapping>)ccd.getContainerMappings());
            mappings.addAll((Collection<RepresentationElementMapping>)ccd.getExtraMappings());
        }
        if (this.toolDescription instanceof ContainerDropDescription) {
            mappings.addAll((Collection<RepresentationElementMapping>)((ContainerDropDescription)this.toolDescription).getMappings());
        }
        if (this.toolDescription instanceof DeleteElementDescription) {
            mappings.addAll((Collection<RepresentationElementMapping>)((DeleteElementDescription)this.toolDescription).getMappings());
        }
        if (this.toolDescription instanceof DirectEditLabel) {
            mappings.addAll((Collection<RepresentationElementMapping>)((DirectEditLabel)this.toolDescription).getMapping());
        }
        if (this.toolDescription instanceof DoubleClickDescription) {
            mappings.addAll((Collection<RepresentationElementMapping>)((DoubleClickDescription)this.toolDescription).getMappings());
        }
        if (this.toolDescription instanceof EdgeCreationDescription) {
            EdgeCreationDescription ecd = (EdgeCreationDescription)this.toolDescription;
            mappings.addAll((Collection<RepresentationElementMapping>)ecd.getEdgeMappings());
            mappings.addAll((Collection<RepresentationElementMapping>)ecd.getExtraSourceMappings());
        }
        if (this.toolDescription instanceof NodeCreationDescription) {
            NodeCreationDescription ncd = (NodeCreationDescription)this.toolDescription;
            mappings.addAll((Collection<RepresentationElementMapping>)ncd.getNodeMappings());
            mappings.addAll((Collection<RepresentationElementMapping>)ncd.getExtraMappings());
        }
        if (this.toolDescription instanceof ReconnectEdgeDescription) {
            mappings.addAll((Collection<RepresentationElementMapping>)((ReconnectEdgeDescription)this.toolDescription).getMappings());
        }
        return mappings;
    }
}

