/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.parts;

import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.ui.parts.IDirtyStateProvider;
import org.eclipse.ui.services.IDisposable;

public class HistoryBasedDirtyStateProvider
implements IDirtyStateProvider,
IDisposable {
    private ReadOnlyBooleanWrapper dirtyProperty = new ReadOnlyBooleanWrapper(false);
    private IOperationHistoryListener operationHistoryListener;
    private IOperationHistory operationHistory;
    private IUndoContext undoContext;
    private IUndoableOperation saveLocation = null;

    public HistoryBasedDirtyStateProvider(IOperationHistory operationHistory, IUndoContext undoContext) {
        this.operationHistory = operationHistory;
        this.undoContext = undoContext;
        if (undoContext == null) {
            throw new IllegalArgumentException("WorkbenchPart needs to be adaptable to IUndoContext");
        }
        this.operationHistoryListener = this.createOperationHistoryListener();
        operationHistory.addOperationHistoryListener(this.operationHistoryListener);
    }

    protected IOperationHistoryListener createOperationHistoryListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                IUndoableOperation[] undoHistory = event.getHistory().getUndoHistory(HistoryBasedDirtyStateProvider.this.getUndoContext());
                if (event.getEventType() == 10 || event.getEventType() == 9 || event.getEventType() == 5 || event.getEventType() == 8) {
                    HistoryBasedDirtyStateProvider.this.dirtyProperty.set(HistoryBasedDirtyStateProvider.this.getMostRecentDirtyRelevantOperation(undoHistory) != HistoryBasedDirtyStateProvider.this.saveLocation);
                }
            }
        };
    }

    @Override
    public ReadOnlyBooleanProperty dirtyProperty() {
        return this.dirtyProperty.getReadOnlyProperty();
    }

    public void dispose() {
        IOperationHistory operationHistory = this.getOperationHistory();
        if (operationHistory != null) {
            operationHistory.removeOperationHistoryListener(this.operationHistoryListener);
        }
        this.operationHistoryListener = null;
        this.saveLocation = null;
    }

    private IUndoableOperation getMostRecentDirtyRelevantOperation(IUndoableOperation[] undoHistory) {
        int i = undoHistory.length - 1;
        while (i >= 0) {
            if (this.isContentsRelated(undoHistory[i])) {
                return undoHistory[i];
            }
            --i;
        }
        return null;
    }

    private IOperationHistory getOperationHistory() {
        return this.operationHistory;
    }

    private IUndoContext getUndoContext() {
        return this.undoContext;
    }

    protected boolean isContentsRelated(IUndoableOperation operation) {
        return operation instanceof ITransactionalOperation && !((ITransactionalOperation)operation).isNoOp() && ((ITransactionalOperation)operation).isContentRelevant();
    }

    @Override
    public boolean isDirty() {
        return this.dirtyProperty.get();
    }

    @Override
    public void markNonDirty() {
        IUndoableOperation[] undoHistory = this.getOperationHistory().getUndoHistory(this.getUndoContext());
        this.saveLocation = this.getMostRecentDirtyRelevantOperation(undoHistory);
        this.dirtyProperty.set(false);
    }
}

