/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.internal.client.LMNamingStrategy;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class RenameChangeAction
extends LMAction<Change> {
    private ISystemDescriptor systemDescriptor;
    private Text labelText;
    private String labelString;

    public RenameChangeAction(IWorkbenchPage page, Change change) {
        super(page, "Rename Change" + INTERACTIVE, "Rename the change '" + change.getLabel() + "'", OM.getImageDescriptor("icons/Rename.gif"), "Rename the change '" + change.getLabel() + "'.", "icons/wizban/RenameChange.png", change);
    }

    @Override
    protected void preRun() throws Exception {
        Change change = (Change)this.getContext();
        System system = change.getSystem();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor((EObject)system);
        super.preRun();
    }

    @Override
    protected void fillDialogArea(LMAction.LMDialog dialog, Composite parent) {
        Change change = (Change)this.getContext();
        String label = change.getLabel();
        Label oldLabel = new Label(parent, 0);
        oldLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        oldLabel.setText("Current label:");
        Text oldLabelText = new Text(parent, 2056);
        oldLabelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        oldLabelText.setText(label);
        Label newLabel = new Label(parent, 0);
        newLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        newLabel.setText("New label:");
        this.labelText = new Text(parent, 2048);
        this.labelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelText.setText(label);
        this.labelText.setFocus();
        this.labelText.addModifyListener(e -> {
            this.labelString = this.labelText.getText();
            this.validateDialog();
        });
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label note = new Label(parent, 0);
        note.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        note.setText("Note that checkouts will be removed.");
    }

    @Override
    protected String doValidate(LMAction.LMDialog dialog) {
        if (StringUtil.isEmpty((String)this.labelString)) {
            return "A new label must be entered.";
        }
        Change change = (Change)this.getContext();
        String moduleName = change.getModule().getName();
        boolean[] branchExists = new boolean[1];
        this.systemDescriptor.withModuleSession(moduleName, session -> {
            CDOBranchPoint branchPoint = change.getBranchPoint().resolve(session.getBranchManager());
            String branchName = LMNamingStrategy.getChangeBranchName((String)this.labelString);
            blArray[0] = branchPoint.getBranch().getBase().getBranch().getBranch(branchName) != null;
        });
        if (branchExists[0]) {
            return "A change with the same label already exists.";
        }
        return super.doValidate(dialog);
    }

    @Override
    protected void doRun(Change change, IProgressMonitor monitor) throws Exception {
        this.systemDescriptor.renameChange(change, this.labelString, monitor);
        IAssemblyDescriptor[] iAssemblyDescriptorArray = IAssemblyManager.INSTANCE.getDescriptors((Baseline)change);
        int n = iAssemblyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAssemblyDescriptor assemblyDescriptor = iAssemblyDescriptorArray[n2];
            CDOCheckout checkout = assemblyDescriptor.getCheckout();
            checkout.delete(true);
            ++n2;
        }
    }
}

