/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding.editors;

import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.dialogfields.ListDialogField;

public class StringListEditor
implements IDataEditor {
    private final ListDialogField<String> m_field;
    private final String m_separator;

    public StringListEditor(ListDialogField<String> field, String separator) {
        this.m_field = field;
        this.m_separator = separator;
    }

    @Override
    public Object getValue() {
        StringBuffer buffer = new StringBuffer();
        int count = this.m_field.getSize();
        int last = count - 1;
        int i = 0;
        while (i < count) {
            buffer.append(this.m_field.getElement(i));
            if (i != last) {
                buffer.append(this.m_separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public void setValue(Object value) {
        String stringValue = ObjectUtils.toString((Object)value);
        Object[] values = StringUtils.split((String)stringValue, (String)this.m_separator);
        ArrayList elements = new ArrayList();
        CollectionUtils.addAll(elements, (Object[])values);
        this.m_field.setElements(elements);
    }
}

