/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.handles;

import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;

public class SideResizeHandle
extends Handle {
    public SideResizeHandle(GraphicalEditPart owner, int side, int width, boolean center) {
        super(owner, new ResizeHandleLocator(owner.getFigure(), side, width, center));
        if (side == 1 || side == 4) {
            this.setCursor(Cursors.SIZEE);
        } else {
            this.setCursor(Cursors.SIZEN);
        }
    }

    private static class ResizeHandleLocator
    implements Locator {
        private final Figure m_reference;
        private final int m_side;
        private final int m_width;
        private final boolean m_center;

        public ResizeHandleLocator(Figure reference, int side, int width, boolean center) {
            this.m_reference = reference;
            this.m_side = side;
            this.m_width = width;
            this.m_center = center;
        }

        public void relocate(IFigure target) {
            int locationOffset;
            Rectangle bounds = this.m_reference.getBounds().getCopy();
            FigureUtils.translateFigureToFigure((IFigure)this.m_reference, target, (Translatable)bounds);
            int n = locationOffset = this.m_center ? this.m_width / 2 : this.m_width;
            if (this.m_side == 1) {
                bounds.x -= locationOffset;
                bounds.width = this.m_width;
            } else if (this.m_side == 4) {
                bounds.x = bounds.right() - locationOffset;
                bounds.width = this.m_width;
            } else if (this.m_side == 8) {
                bounds.y -= locationOffset;
                bounds.height = this.m_width;
            } else {
                bounds.y = bounds.bottom() - locationOffset;
                bounds.height = this.m_width;
            }
            target.setBounds(bounds);
        }
    }
}

