/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.execute;

import java.io.InputStream;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.AccessCycleConfiguration;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.BaseFramework;
import org.eclipse.passage.lic.base.InvalidLicensedProduct;
import org.eclipse.passage.lic.equinox.LicensedApplication;
import org.eclipse.passage.lic.equinox.io.FileFromBundle;
import org.eclipse.passage.lic.execute.FocusedAccessCycleConfiguration;
import org.eclipse.passage.lic.internal.execute.Logging;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultFramework
extends BaseFramework {
    private final Logger log;
    private final AccessCycleConfiguration configuration;

    public DefaultFramework(Supplier<Bundle> bundle) {
        this.configureLogging();
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.logConfiguration();
        this.configuration = new FocusedAccessCycleConfiguration.Personal(() -> ((DefaultFramework)this).product(), bundle);
    }

    protected final LicensedProduct productRead() {
        LicensedProduct prod;
        try {
            prod = new LicensedApplication().product();
        }
        catch (LicensingException e) {
            prod = new InvalidLicensedProduct();
        }
        return prod;
    }

    public AccessCycleConfiguration accessCycleConfiguration() {
        return this.configuration;
    }

    private void configureLogging() {
        new Logging(this::logConfig).configure();
    }

    private InputStream logConfig() throws Exception {
        return new FileFromBundle(FrameworkUtil.getBundle(((Object)((Object)this)).getClass()), "config/log4j2.xml").get();
    }

    private void logConfiguration() {
        this.log.debug(String.format("%s runs for %s", ((Object)((Object)this)).getClass().getName(), this.product()));
    }
}

