/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.m2m.atl.emftvm.util.DuplicateEntryException;
import org.eclipse.m2m.atl.emftvm.util.TypeMap;

public class TypeHashMap<K, V>
extends HashMap<K, V>
implements TypeMap<K, V> {
    private static final long serialVersionUID = -4866974440115920626L;
    private Map<Object, Object> cachedKeys = new HashMap<Object, Object>();

    @Override
    public Object findKey(Object key) {
        Class<?> result;
        if (this.cachedKeys.containsKey(key) && this.containsKey(result = this.cachedKeys.get(key))) {
            return result;
        }
        if (key instanceof EClass) {
            EClass eCls = (EClass)key;
            Object result2 = this.findEClassKey((EClass)key);
            if (result2 == null) {
                Class ic = eCls.getInstanceClass();
                result2 = ic != null ? this.findClassKey(ic) : this.findClassKey(Object.class);
            }
            this.cachedKeys.put(key, result2);
            return result2;
        }
        if (key instanceof Class) {
            result = this.findClassKey((Class)key);
            this.cachedKeys.put(key, result);
            return result;
        }
        if (this.containsKey(key)) {
            return key;
        }
        return null;
    }

    private EClass findEClassKey(EClass key) {
        HashSet<EClass> keys = new HashSet<EClass>();
        this.findEClassKeys(key, keys);
        EClass mostSpecificKey = null;
        for (EClass superKey : keys) {
            if (mostSpecificKey == null || mostSpecificKey.isSuperTypeOf(superKey)) {
                mostSpecificKey = superKey;
                continue;
            }
            if (superKey.isSuperTypeOf(mostSpecificKey)) continue;
            throw new DuplicateEntryException(String.format("Superkeys %s and %s both have an entry in %s", mostSpecificKey, superKey, this));
        }
        return mostSpecificKey;
    }

    private void findEClassKeys(EClass key, Set<EClass> result) {
        if (this.containsKey(key)) {
            result.add(key);
        } else {
            for (EClass eSuperType : key.getESuperTypes()) {
                this.findEClassKeys(eSuperType, result);
            }
        }
    }

    private Class<?> findClassKey(Class<?> key) {
        if (this.containsKey(key)) {
            return key;
        }
        Class<Object> mostSpecificKey = null;
        Class<?> superType = key.getSuperclass();
        if (superType != null) {
            mostSpecificKey = this.findClassKey(superType);
        } else if (key != Object.class) {
            mostSpecificKey = this.findClassKey(Object.class);
        }
        Class<?>[] classArray = key.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            Class<?> ifaceKey = this.findClassKey(iface);
            if (ifaceKey != null && (mostSpecificKey == null || mostSpecificKey.isAssignableFrom(ifaceKey))) {
                mostSpecificKey = ifaceKey;
            }
            ++n2;
        }
        return mostSpecificKey;
    }

    @Override
    public void findAllKeys(Object key, Set<Object> keys) {
        if (key instanceof EClass) {
            EClass eCls = (EClass)key;
            Class ic = eCls.getInstanceClass();
            this.findAllEClassKeys(eCls, keys);
            if (ic != null) {
                this.findAllClassKeys(ic, keys);
            } else {
                this.findAllClassKeys(Object.class, keys);
            }
        } else if (key instanceof Class) {
            this.findAllClassKeys((Class)key, keys);
        } else if (this.containsKey(key)) {
            keys.add(key);
        }
    }

    private void findAllEClassKeys(EClass key, Set<Object> result) {
        if (this.containsKey(key)) {
            result.add(key);
        }
        for (EClass eSuperType : key.getESuperTypes()) {
            this.findAllEClassKeys(eSuperType, result);
        }
    }

    private void findAllClassKeys(Class<?> key, Set<Object> result) {
        Class<?> superType;
        if (this.containsKey(key)) {
            result.add(key);
        }
        if ((superType = key.getSuperclass()) != null) {
            this.findAllClassKeys(superType, result);
        } else if (key != Object.class) {
            this.findAllClassKeys(Object.class, result);
        }
        Class<?>[] classArray = key.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            this.findAllClassKeys(iface, result);
            ++n2;
        }
    }

    @Override
    public V put(K key, V value) {
        this.cachedKeys.clear();
        return super.put(key, value);
    }
}

