/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.draw2d.Label;

public final class VerticalLabel
extends Label {
    private Dimension m_preferredSize;

    @Override
    protected void paintClientArea(Graphics graphics) {
        VerticalLabel.drawVerticalText(this.getText(), 0, 0, graphics, false);
    }

    @Override
    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.m_preferredSize == null) {
            this.m_preferredSize = FigureUtils.calculateTextSize(this.getText(), this.getFont());
            Insets insets = this.getInsets();
            this.m_preferredSize.expand(insets.getWidth(), insets.getHeight());
            this.m_preferredSize.transpose();
        }
        return this.m_preferredSize;
    }

    @Override
    public void invalidate() {
        this.m_preferredSize = null;
        super.invalidate();
    }

    private static void drawVerticalText(String string, int x, int y, Graphics graphics, boolean isUp) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = ((GC)ReflectionUtils.getFieldObject(graphics, "gc")).textExtent(string);
        Image stringImage = new Image((Device)display, pt.x, pt.y);
        GC stringGc = new GC((Drawable)stringImage);
        stringGc.setForeground(graphics.getForegroundColor());
        stringGc.setBackground(graphics.getBackgroundColor());
        stringGc.setFont(graphics.getFont());
        stringGc.drawText(string, 0, 0);
        Image rotatedImage = VerticalLabel.rotateImage(stringImage, isUp);
        graphics.drawImage(rotatedImage, x, y);
        rotatedImage.dispose();
        stringGc.dispose();
        stringImage.dispose();
    }

    private static Image rotateImage(Image image, boolean up) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        return new Image((Device)display, dd);
    }
}

