/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.graphical.tools;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.tools.TargetingTool;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.tools.MarqueeDragTracker;

public class SelectionTool
extends TargetingTool {
    private DragTracker m_dragTracker;

    public void setDragTrackerTool(DragTracker dragTracker) {
        if (this.m_dragTracker != dragTracker) {
            if (this.m_dragTracker != null) {
                this.m_dragTracker.deactivate();
            }
            this.m_dragTracker = dragTracker;
            this.refreshCursor();
            if (this.m_dragTracker != null) {
                this.m_dragTracker.setEditDomain((EditDomain)this.getDomain());
                this.m_dragTracker.setViewer((EditPartViewer)this.getCurrentViewer());
                this.m_dragTracker.activate();
            }
        }
    }

    @Override
    public void deactivate() {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.deactivate();
            this.m_dragTracker = null;
        }
        super.deactivate();
    }

    public void refreshCursor() {
        if (this.m_dragTracker == null) {
            super.refreshCursor();
        }
    }

    protected boolean handleButtonDown(int button) {
        if (this.m_state == 1) {
            this.m_state = 2;
            if (this.m_dragTracker != null) {
                this.m_dragTracker.deactivate();
            }
            if ((this.m_stateMask & 0x10000) != 0) {
                this.setDragTrackerTool(new MarqueeDragTracker());
                return true;
            }
            Point current = this.getCurrentInput().getMouseLocation();
            Handle handle = this.getCurrentViewer().findTargetHandle(current.x, current.y);
            if (handle != null) {
                this.setDragTrackerTool(handle.getDragTrackerTool());
                return true;
            }
            this.updateTargetRequest();
            ((SelectionRequest)this.getTargetRequest()).setLastButtonPressed(button);
            this.updateTargetUnderMouse();
            EditPart editPart = this.getTargetEditPart();
            if (editPart == null) {
                this.setDragTrackerTool(null);
                this.getCurrentViewer().deselectAll();
            } else {
                this.setDragTrackerTool(editPart.getDragTracker(this.getTargetRequest()));
                this.lockTargetEditPart(editPart);
            }
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        ((SelectionRequest)this.getTargetRequest()).setLastButtonPressed(0);
        this.setDragTrackerTool(null);
        this.m_state = 1;
        this.unlockTargetEditPart();
        return true;
    }

    protected boolean handleMove() {
        if (this.m_state == 2) {
            this.m_state = 1;
            this.setDragTrackerTool(null);
        }
        if (this.m_state == 1) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showTargetFeedback();
        }
        return true;
    }

    @Override
    protected boolean handleViewerExited() {
        if (this.m_state == 2 || this.m_state == 4) {
            Event event = new Event();
            event.x = this.getCurrentInput().getMouseLocation().x;
            event.y = this.getCurrentInput().getMouseLocation().y;
            event.stateMask = this.m_stateMask;
            event.button = this.m_button;
            event.widget = this.getCurrentViewer().getControl();
            this.mouseUp(new MouseEvent(event), this.getCurrentViewer());
        }
        super.handleViewerExited();
        return true;
    }

    @Override
    protected Request createTargetRequest() {
        SelectionRequest request = new SelectionRequest();
        request.setType((Object)"selection");
        return request;
    }

    @Override
    protected void updateTargetRequest() {
        super.updateTargetRequest();
        SelectionRequest request = (SelectionRequest)this.getTargetRequest();
        request.setLocation(this.getLocation());
    }

    @Override
    protected IEditPartViewer.IConditional getTargetingConditional() {
        return editPart -> editPart.isSelectable();
    }

    @Override
    public void mouseDown(MouseEvent event, EditPartViewer viewer) {
        super.mouseDown(event, viewer);
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseDown(event, viewer);
        }
    }

    @Override
    public void mouseUp(MouseEvent event, EditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseUp(event, viewer);
        }
        super.mouseUp(event, viewer);
    }

    @Override
    public void mouseDrag(MouseEvent event, EditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseDrag(event, viewer);
        }
        super.mouseDrag(event, viewer);
    }

    @Override
    public void mouseMove(MouseEvent event, EditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseMove(event, viewer);
        }
        super.mouseMove(event, viewer);
    }

    @Override
    public void mouseDoubleClick(MouseEvent event, EditPartViewer viewer) {
        super.mouseDoubleClick(event, viewer);
        if (this.m_dragTracker != null) {
            this.m_dragTracker.mouseDoubleClick(event, viewer);
        }
    }

    public void keyDown(KeyEvent event, EditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.keyDown(event, viewer);
        } else {
            List selection = viewer.getSelectedEditParts();
            if (event.keyCode == 27) {
                org.eclipse.gef.EditPart part;
                org.eclipse.gef.EditPart parent;
                if (!selection.isEmpty() && (parent = (part = (org.eclipse.gef.EditPart)selection.get(0)).getParent()) != null && !(parent instanceof RootEditPart)) {
                    viewer.select(parent);
                }
            } else {
                SelectionTool.handleKeyEvent(true, event, selection);
            }
        }
    }

    public void keyUp(KeyEvent event, EditPartViewer viewer) {
        if (this.m_dragTracker != null) {
            this.m_dragTracker.keyUp(event, viewer);
        } else if (event.keyCode != 27) {
            SelectionTool.handleKeyEvent(false, event, viewer.getSelectedEditParts());
        }
    }

    private static void handleKeyEvent(boolean pressed, KeyEvent event, List<? extends org.eclipse.gef.EditPart> selection) {
        KeyRequest request = new KeyRequest(pressed, event);
        for (org.eclipse.gef.EditPart editPart : selection) {
            editPart.performRequest((Request)request);
        }
    }
}

