/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.gef.core.EditDomain;

public abstract class Tool
extends AbstractTool
implements DragTracker {
    private static final int FLAG_ACTIVE = 8;
    private static final int FLAG_PAST_THRESHOLD = 1;
    private List<EditPart> m_operationSet;
    private Command m_command;
    private static final int DRAG_THRESHOLD = 5;
    protected int m_stateMask;
    protected int m_button;
    protected int m_state;

    public void activate() {
        this.resetState();
        this.m_state = 1;
        this.setFlag(8, true);
    }

    public void deactivate() {
        this.setFlag(8, false);
        this.setCommand(null);
        this.m_operationSet = null;
    }

    public final boolean isActive() {
        return this.getFlag(8);
    }

    public final IEditPartViewer getCurrentViewer() {
        return (IEditPartViewer)super.getCurrentViewer();
    }

    public final EditDomain getDomain() {
        return (EditDomain)super.getDomain();
    }

    protected void handleFinished() {
        if (this.unloadWhenFinished()) {
            this.getDomain().loadDefaultTool();
        } else {
            Event event = null;
            if (this.getCurrentViewer() != null) {
                event = new Event();
                event.display = Display.getCurrent();
                event.widget = this.getCurrentViewer().getControl();
                event.type = 5;
                event.x = this.getCurrentInput().getMouseLocation().x;
                event.y = this.getCurrentInput().getMouseLocation().y;
                event.button = this.m_button;
                event.stateMask = this.m_stateMask;
            }
            this.deactivate();
            this.activate();
            if (this.getCurrentViewer() != null) {
                this.mouseMove(new MouseEvent(event), this.getCurrentViewer());
            }
        }
    }

    protected String getCommandName() {
        return null;
    }

    protected final List<EditPart> getOperationSet() {
        if (this.m_operationSet == null) {
            this.m_operationSet = this.createOperationSet();
        }
        return this.m_operationSet;
    }

    protected List<EditPart> createOperationSet() {
        return new ArrayList<EditPart>(this.getCurrentViewer().getSelectedEditParts());
    }

    protected final void executeCommand() {
        if (this.m_command != null) {
            Command command = this.m_command;
            this.setCommand(null);
            this.getDomain().executeCommand(command);
        }
    }

    protected final void setCommand(Command command) {
        this.m_command = command;
        this.refreshCursor();
    }

    protected Command getCommand() {
        return null;
    }

    protected final void updateCommand() {
        this.setCommand(this.getCommand());
    }

    protected Cursor calculateCursor() {
        if (this.m_state == 0x40000000) {
            return null;
        }
        if (this.m_command == null) {
            return this.getDisabledCursor();
        }
        return this.getDefaultCursor();
    }

    private void setEvent(MouseEvent event) {
        this.getCurrentInput().setInput(event);
        this.m_stateMask = event.stateMask;
        this.m_button = event.button;
    }

    protected boolean movedPastThreshold() {
        if (!this.getFlag(1)) {
            Point start = this.getStartLocation();
            Point end = this.getLocation();
            this.setFlag(1, Math.abs(start.x - end.x) > 5 || Math.abs(start.y - end.y) > 5);
        }
        return this.getFlag(1);
    }

    public void mouseDown(MouseEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        this.setStartLocation(new Point(event.x, event.y));
        this.handleButtonDown(event.button);
    }

    public void mouseUp(MouseEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        this.handleButtonUp(event.button);
    }

    public void mouseDrag(MouseEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        boolean wasDragging = this.movedPastThreshold();
        this.setEvent(event);
        this.handleDrag();
        if (this.movedPastThreshold()) {
            if (!wasDragging) {
                this.handleDragStarted();
            }
            this.handleDragInProgress();
        }
    }

    public void mouseMove(MouseEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        if (this.m_state == 4) {
            this.handleDragInProgress();
        } else {
            this.handleMove();
        }
    }

    public void mouseDoubleClick(MouseEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        this.setEvent(event);
        this.handleDoubleClick(event.button);
    }

    public void viewerEntered(MouseEvent event, EditPartViewer viewer) {
        this.setEvent(event);
        if (this.getCurrentViewer() != null) {
            this.handleViewerExited();
        }
        this.setViewer(viewer);
        this.handleViewerEntered();
    }

    public void viewerExited(MouseEvent event, EditPartViewer viewer) {
        if (this.getCurrentViewer() == viewer) {
            this.setEvent(event);
            this.handleViewerExited();
            this.setViewer(null);
        }
    }

    public final Point getLocation() {
        return new Point(this.getCurrentInput().getMouseLocation().x + this.getCurrentViewer().getHOffset(), this.getCurrentInput().getMouseLocation().y + this.getCurrentViewer().getVOffset());
    }

    protected Point getStartLocation() {
        return new Point(super.getStartLocation().x + this.getCurrentViewer().getHOffset(), super.getStartLocation().y + this.getCurrentViewer().getVOffset());
    }

    protected void resetState() {
        this.getCurrentInput().setMouseLocation(0, 0);
        this.m_stateMask = 0;
        this.m_button = 0;
        this.setStartLocation(new Point(0, 0));
        this.setFlag(1, false);
    }
}

