/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.AbstractStage;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Stage;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class BodyStage
extends AbstractStage {
    private final @NonNull Iterable<@NonNull Node> visibleIteratorNodes;
    private final @NonNull Iterable<@NonNull Node> realizedNodes;
    private final @NonNull Iterable<@NonNull Node> allHeadNodes;
    private final @NonNull Iterable<@NonNull Node> directlyRequiredNodes;
    private final @NonNull Iterable<@NonNull Node> deadNodes;
    private final @NonNull Iterable<@NonNull Node> indirectlyRequiredNodes;

    private static void computeOperationSources(Set<@NonNull Node> nodes, @NonNull Node node) {
        if (nodes.add(node)) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isExpression()) continue;
                BodyStage.computeOperationSources(nodes, edge.getEdgeSource());
            }
        }
    }

    public BodyStage(@NonNull SplitterAnalysis splitter, @NonNull Iterable<@NonNull Stage> stages) {
        super(splitter);
        this.visibleIteratorNodes = this.computedVisibleIteratorNodes(stages);
        this.realizedNodes = this.computeNewNodes();
        Iterable<@NonNull Node> requiredNodes = this.computeRequiredNodes();
        this.allHeadNodes = this.computeAllHeadNodes(requiredNodes);
        this.directlyRequiredNodes = this.computeDirectlyRequiredNodes(requiredNodes);
        Iterable<@NonNull Node> allNodes = this.computeAllNodes();
        this.deadNodes = this.computeDeadNodes(allNodes);
        this.indirectlyRequiredNodes = this.computeIndirectlyRequiredNodes(allNodes);
    }

    @Override
    protected @NonNull String buildContents(@NonNull StringBuilder s) {
        this.build(s, "all head nodes", this.allHeadNodes);
        this.build(s, "realized nodes", this.realizedNodes);
        this.build(s, "directly required nodes", this.directlyRequiredNodes);
        this.build(s, "indirectly required nodes", this.indirectlyRequiredNodes);
        this.build(s, "dead nodes", this.deadNodes);
        return "body";
    }

    @Override
    public void check() {
        HashSet<@NonNull Node> accumulator = new HashSet<Node>();
        this.checkAccumulate(accumulator, this.allHeadNodes);
        this.checkAccumulate(accumulator, this.realizedNodes);
        this.checkAccumulate(accumulator, this.directlyRequiredNodes);
        this.checkAccumulate(accumulator, this.indirectlyRequiredNodes);
        this.checkAccumulate(accumulator, this.deadNodes);
        this.checkAccumulated(accumulator, QVTscheduleUtil.getOwnedNodes((Region)this.splitter.getRegion()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull Node> computeAllHeadNodes(@NonNull Iterable<@NonNull Node> requiredNodes) {
        @NonNull HashSet nodeSet = Sets.newHashSet(this.visibleIteratorNodes);
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)this.splitter.getRegion())) {
            if (!headNode.isSpeculated() && !headNode.isPredicated()) continue;
            nodeSet.add(headNode);
        }
        for (Node node : requiredNodes) {
            if (!node.isHead()) continue;
            nodeSet.add(node);
        }
        @NonNull ArrayList nodes = Lists.newArrayList((Iterable)nodeSet);
        Collections.sort(nodes, NameUtil.NAMEABLE_COMPARATOR);
        return nodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull Node> computeAllNodes() {
        Set<@NonNull Node> navigableNodes = SplitterUtil.computeNavigableNodes(this.allHeadNodes);
        Set<@NonNull Node> computableNodes = SplitterUtil.computeComputableTargetNodes(navigableNodes);
        @NonNull HashSet allNodes = Sets.newHashSet(navigableNodes);
        allNodes.addAll(computableNodes);
        return allNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull Node> computeDirectlyRequiredNodes(@NonNull Iterable<@NonNull Node> requiredNodes) {
        @NonNull ArrayList nodes = Lists.newArrayList(requiredNodes);
        CompilerUtil.removeAll(nodes, this.allHeadNodes);
        Collections.sort(nodes, NameUtil.NAMEABLE_COMPARATOR);
        return nodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull Node> computeIndirectlyRequiredNodes(@NonNull Iterable<@NonNull Node> allNodes) {
        @NonNull HashSet nodeSet = Sets.newHashSet(allNodes);
        CompilerUtil.removeAll(nodeSet, this.allHeadNodes);
        CompilerUtil.removeAll(nodeSet, this.deadNodes);
        CompilerUtil.removeAll(nodeSet, this.directlyRequiredNodes);
        CompilerUtil.removeAll(nodeSet, this.realizedNodes);
        @NonNull ArrayList nodesList = Lists.newArrayList((Iterable)nodeSet);
        Collections.sort(nodesList, NameUtil.NAMEABLE_COMPARATOR);
        return nodesList;
    }

    protected @NonNull Iterable<@NonNull Node> computeNewNodes() {
        Region region = this.splitter.getRegion();
        ArrayList<@NonNull Node> newNodes = new ArrayList<Node>();
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)region)) {
            if (!node.isNew()) continue;
            newNodes.add(node);
        }
        Collections.sort(newNodes, NameUtil.NAMEABLE_COMPARATOR);
        return newNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull Node> computeReachableNodes(@NonNull Iterable<@NonNull Node> requiredNodes) {
        Set<@NonNull Node> reachableNodes = SplitterUtil.computeNavigableNodes(this.allHeadNodes);
        for (Node node : requiredNodes) {
            reachableNodes.remove(node);
        }
        @NonNull ArrayList reachableNodesList = Lists.newArrayList(reachableNodes);
        Collections.sort(reachableNodesList, NameUtil.NAMEABLE_COMPARATOR);
        return reachableNodesList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull Node> computeRequiredNodes() {
        HashSet<@NonNull Node> requiredNodeSet = new HashSet<Node>();
        for (Node node : this.realizedNodes) {
            if (!node.isOperation()) continue;
            BodyStage.computeOperationSources(requiredNodeSet, node);
        }
        Region region = this.splitter.getRegion();
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)region)) {
            if (!edge.isRealized()) continue;
            requiredNodeSet.add(edge.getEdgeSource());
            requiredNodeSet.add(edge.getEdgeTarget());
        }
        for (Node node : this.realizedNodes) {
            requiredNodeSet.remove(node);
        }
        @NonNull ArrayList nodes = Lists.newArrayList(requiredNodeSet);
        Collections.sort(nodes, NameUtil.NAMEABLE_COMPARATOR);
        return nodes;
    }

    protected @NonNull Iterable<@NonNull Node> computedVisibleIteratedNodes(Iterable<@NonNull Stage> stages) {
        ArrayList<@NonNull Node> nodes = new ArrayList<Node>();
        for (Stage stage : stages) {
            Node node = stage.getIteratedNode();
            if (node == null) continue;
            nodes.add(node);
        }
        Collections.sort(nodes, NameUtil.NAMEABLE_COMPARATOR);
        return nodes;
    }

    protected @NonNull Iterable<@NonNull Node> computedVisibleIteratorNodes(Iterable<@NonNull Stage> stages) {
        ArrayList<@NonNull Node> nodes = new ArrayList<Node>();
        for (Stage stage : stages) {
            Node node = stage.getIteratorNode();
            if (node == null) continue;
            nodes.add(node);
        }
        Collections.sort(nodes, NameUtil.NAMEABLE_COMPARATOR);
        return nodes;
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getHeadNodes() {
        return this.allHeadNodes;
    }

    @Override
    protected boolean isLive(@NonNull Node node, @NonNull Set<@NonNull Node> deadNodes) {
        if (node.isHead()) {
            return true;
        }
        if (node.isRealized()) {
            return true;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isRealized()) continue;
            return true;
        }
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            Node targetNode = edge.getEdgeTarget();
            if (deadNodes.contains(targetNode) || targetNode.isHead()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toString(@NonNull StringBuilder s, int depth) {
        CompilerUtil.indent(s, depth);
        s.append("body");
    }
}

