/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.AbstractVariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.VariablesAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class RelationVariableAnalysis
extends AbstractVariableAnalysis {
    protected final @NonNull VariableDeclaration rVariable;
    private @Nullable TypedModel rEnforcedTypedModel = null;
    private @Nullable Key rKey = null;
    private @Nullable TemplateExp rTemplateExp = null;
    private boolean isEnforcedBound = false;
    private boolean isEnforcedReferred = false;
    private @Nullable TypedModel rOtherBound = null;
    private @Nullable TypedModel rOtherReferred = null;
    private boolean isRoot = false;
    private @Nullable TypedModel rWhenTypedModel = null;
    private @Nullable TypedModel rWhereTypedModel = null;
    private @Nullable TypedModel rPredicateTypedModel = null;
    private @Nullable Strategy strategy = null;

    public RelationVariableAnalysis(@NonNull VariablesAnalysis variablesAnalysis, @NonNull VariableDeclaration rVariable) {
        super(variablesAnalysis);
        assert (!"this".equals(rVariable.getName()));
        this.rVariable = rVariable;
        assert (!(rVariable instanceof IteratorVariable));
        assert (!(rVariable instanceof LetVariable));
    }

    private @NonNull Strategy computeStrategy() {
        if (!(this.rWhenTypedModel != null || this.variablesAnalysis.isInvoked() && this.isRoot || !this.isEnforcedBound || this.rKey == null)) {
            assert (this.rEnforcedTypedModel != null);
            assert (this.rKey != null);
            assert (this.isEnforcedBound);
            assert (this.rOtherBound == null);
            assert (this.rOtherReferred == null);
            return Strategy.KEYED;
        }
        if (!(this.rWhenTypedModel != null || this.variablesAnalysis.isWhered() && this.isRoot || !this.isEnforcedBound || this.rKey != null)) {
            assert (this.rEnforcedTypedModel != null);
            assert (this.rKey == null);
            assert (this.rTemplateExp != null);
            assert (this.isEnforcedBound);
            assert (this.rOtherBound == null);
            assert (this.rOtherReferred == null);
            return Strategy.REALIZED_BOTTOM;
        }
        if (this.rEnforcedTypedModel != null) {
            assert (this.rEnforcedTypedModel != null);
            assert (this.isEnforcedBound);
            assert (this.rOtherBound == null);
            return Strategy.ENFORCED_GUARD;
        }
        if (this.rVariable instanceof Variable && ((Variable)this.rVariable).getOwnedInit() != null) {
            return Strategy.SHARED_BOTTOM;
        }
        if (this.rWhenTypedModel != null || this.isEnforcedBound && this.variablesAnalysis.isInvoked() && this.isRoot || !this.isEnforcedBound && this.rOtherBound != null && this.isRoot) {
            assert (this.rEnforcedTypedModel == null);
            assert (!this.isEnforcedBound);
            assert (this.rOtherBound != null || this.rOtherReferred != null || this.rWhenTypedModel != null || this.rWhereTypedModel != null);
            return Strategy.OTHER_GUARD;
        }
        if (this.rOtherBound != null) {
            assert (this.rEnforcedTypedModel == null);
            assert (this.rKey == null);
            assert (!this.isEnforcedBound);
            assert (this.rOtherBound != null);
            assert (!this.isRoot);
            return Strategy.OTHER_BOTTOM;
        }
        if (this.isEnforcedReferred && this.rOtherReferred != null) {
            assert (this.rEnforcedTypedModel == null);
            assert (this.rKey == null);
            assert (this.rTemplateExp == null);
            assert (!this.isEnforcedBound);
            assert (this.isEnforcedReferred);
            assert (this.rOtherBound == null);
            assert (this.rOtherReferred != null);
            assert (!this.isRoot);
            return Strategy.SHARED_BOTTOM;
        }
        if (this.isEnforcedReferred && this.rOtherReferred == null) {
            assert (this.rEnforcedTypedModel == null);
            assert (this.rKey == null);
            assert (this.rTemplateExp == null);
            assert (!this.isEnforcedBound);
            assert (this.isEnforcedReferred);
            assert (this.rOtherBound == null);
            assert (this.rOtherReferred == null);
            assert (!this.isRoot);
            return Strategy.ENFORCED_BOTTOM;
        }
        assert (this.rEnforcedTypedModel == null);
        assert (this.rKey == null);
        assert (!this.isEnforcedBound);
        assert (!this.isEnforcedReferred);
        assert (this.rOtherBound != null || this.rOtherReferred != null || this.rPredicateTypedModel != null || this.rWhenTypedModel != null || this.rWhereTypedModel != null);
        assert (!this.isRoot);
        return Strategy.OTHER_BOTTOM;
    }

    public TypedModel getrEnforcedTypedModel() {
        return this.rEnforcedTypedModel;
    }

    public Key getrKey() {
        return this.rKey;
    }

    public TemplateExp getrTemplateExp() {
        return this.rTemplateExp;
    }

    public TypedModel getrOtherBound() {
        return this.rOtherBound;
    }

    public TypedModel getrOtherReferred() {
        return this.rOtherReferred;
    }

    public TypedModel getrPredicate() {
        return this.rPredicateTypedModel;
    }

    public TypedModel getrWhenTypedModel() {
        return this.rWhenTypedModel;
    }

    public TypedModel getrWhereTypedModel() {
        return this.rWhereTypedModel;
    }

    @Override
    public @NonNull VariableDeclaration getRelationVariable() {
        return this.rVariable;
    }

    public @NonNull Strategy getStrategy() {
        Strategy strategy2 = this.strategy;
        if (strategy2 == null) {
            this.strategy = strategy2 = this.computeStrategy();
        }
        return strategy2;
    }

    @Override
    public boolean hasWhenDomain() {
        return this.rWhenTypedModel != null;
    }

    public boolean isRealized() {
        switch (this.getStrategy()) {
            case REALIZED_BOTTOM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setIsEnforcedBound(@Nullable TemplateExp rTemplateExp, @NonNull TypedModel rEnforcedTypedModel, @Nullable Key rKey) {
        assert (this.strategy == null);
        assert (!this.isEnforcedBound);
        assert (this.rOtherBound == null);
        assert (this.rEnforcedTypedModel == null);
        assert (this.rKey == null);
        assert (this.rTemplateExp == null);
        this.isEnforcedBound = true;
        this.rTemplateExp = rTemplateExp;
        this.rEnforcedTypedModel = rEnforcedTypedModel;
        this.rKey = rKey;
    }

    @Override
    public void setIsEnforcedReferred() {
        assert (this.strategy == null);
        this.isEnforcedReferred = true;
    }

    @Override
    public void setIsRoot() {
        assert (this.strategy == null);
        this.isRoot = true;
    }

    @Override
    public void setOtherBound(@NonNull TypedModel rOtherTypedModel) {
        assert (this.strategy == null);
        assert (!this.isEnforcedBound);
        assert (this.rOtherBound == null);
        this.rOtherBound = rOtherTypedModel;
    }

    @Override
    public void setOtherReferred(@NonNull TypedModel rOtherTypedModel) {
        assert (this.strategy == null);
        assert (this.rOtherReferred == null || this.rOtherReferred == rOtherTypedModel);
        this.rOtherReferred = rOtherTypedModel;
    }

    @Override
    public void setPredicate(@NonNull TypedModel rPredicateTypedModel) {
        assert (this.strategy == null);
        this.rPredicateTypedModel = rPredicateTypedModel;
    }

    @Override
    public void setWhen(@NonNull TypedModel rWhenTypedModel) {
        assert (this.strategy == null);
        assert (this.rWhenTypedModel == null || this.rWhenTypedModel == rWhenTypedModel);
        this.rWhenTypedModel = rWhenTypedModel;
    }

    @Override
    public void setWhere(@NonNull TypedModel rWhereTypedModel) {
        assert (this.strategy == null);
        assert (this.rWhereTypedModel == null || this.rWhereTypedModel == rWhereTypedModel);
        this.rWhereTypedModel = rWhereTypedModel;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.rVariable.toString());
        if (this.rWhenTypedModel != null) {
            s.append(" WHEN:" + this.rWhenTypedModel.getName());
        }
        if (this.rWhereTypedModel != null) {
            s.append(" WHERE:" + this.rWhereTypedModel.getName());
        }
        if (this.variablesAnalysis.isWhened()) {
            s.append(" WHENED");
        }
        if (this.variablesAnalysis.isWhered()) {
            s.append(" WHERED");
        }
        if (this.rPredicateTypedModel != null) {
            s.append(" PREDICATE:" + this.rPredicateTypedModel.getName());
        }
        if (this.isRoot) {
            s.append(" ROOT");
        }
        if (this.rKey != null) {
            s.append(" KEYED");
        }
        if (this.isEnforcedBound) {
            s.append(" ENFORCED");
        } else if (this.isEnforcedReferred) {
            s.append(" enforced");
        }
        if (this.rOtherBound != null) {
            s.append(" OTHER:" + this.rOtherBound.getName());
        } else if (this.rOtherReferred != null) {
            s.append(" other:" + this.rOtherReferred.getName());
        }
        if (this.rTemplateExp != null) {
            s.append(" " + this.rTemplateExp);
        }
        return s.toString();
    }

    public static enum Strategy {
        ENFORCED_BOTTOM,
        ENFORCED_GUARD,
        KEYED,
        OTHER_BOTTOM,
        OTHER_GUARD,
        REALIZED_BOTTOM,
        SHARED_BOTTOM;

    }
}

