/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

public class HTMLBuffer {
    protected final StringBuilder s = new StringBuilder();
    private boolean inPara = false;

    public void append(String string) {
        int i = 0;
        while (i < string.length()) {
            this.append(string.charAt(i));
            ++i;
        }
    }

    public void append(char c) {
        switch (c) {
            case '&': {
                this.s.append("&amp;");
                break;
            }
            case '<': {
                this.s.append("&lt;");
                break;
            }
            case '>': {
                this.s.append("&gt;");
                break;
            }
            default: {
                this.s.append(c);
            }
        }
    }

    public void appendFigure(String src, String alt, String width, String height) {
        this.s.append("<img");
        this.appendValue("src", src);
        this.appendValue("alt", alt);
        this.appendValue("width", width);
        this.appendValue("height", height);
        this.s.append(">");
    }

    public void appendLabelDef(String value) {
        this.s.append("<a");
        this.appendValue("name", value);
        this.s.append("></a>");
    }

    public void appendLabelRef(String value) {
        this.s.append("<a");
        this.appendValue("href", "#" + value);
        this.s.append("></a>");
    }

    protected void appendTag(String tag) {
        this.s.append("<");
        this.s.append(tag);
        this.s.append(">");
    }

    protected void appendUntag(String tag) {
        this.s.append("</");
        this.s.append(tag);
        this.s.append(">");
    }

    protected void appendValue(String name, String value) {
        if (value != null) {
            this.s.append(" ");
            this.s.append(name);
            this.s.append("=\"");
            this.s.append(value);
            this.s.append("\"");
        }
    }

    public void endBulletLevel(Integer level) {
        this.appendUntag("li");
        this.appendUntag("ul");
    }

    public void endFontColor() {
        this.appendUntag("font");
    }

    public void endFontName(String fontName) {
        this.appendUntag(fontName);
    }

    public void endFootnote() {
        this.appendUntag("footnote");
    }

    public void endHeadingLevel(String level) {
        this.appendUntag("h" + level);
    }

    public void endParagraph() {
        if (this.inPara) {
            this.appendUntag("p");
            this.inPara = false;
        }
    }

    public void endUnderline() {
        this.appendUntag("u");
    }

    public void startBulletLevel(Integer level) {
        this.appendTag("ul");
        this.appendTag("li");
    }

    public void startFontColor(String colorName) {
        this.appendTag("font color=\"" + colorName + "\"");
    }

    public void startFontName(String fontName) {
        this.appendTag(fontName);
    }

    public void startFootnote() {
        this.appendTag("footnote");
    }

    public void startHeadingLevel(String level) {
        this.appendTag("h" + level);
    }

    public void startParagraph() {
        if (!this.inPara) {
            this.appendTag("p");
            this.inPara = true;
        }
    }

    public void startUnderline() {
        this.appendTag("u");
    }

    public String toString() {
        return this.s.toString();
    }
}

