/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayIterator;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.MappedByRelationship;
import org.eclipse.jpt.jpa.core.context.MappingRelationship;
import org.eclipse.jpt.jpa.core.context.OptionalMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SingleRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditor;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.facade.EclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.GraphicalRemoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveAttributeFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RemoveRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorDiagramTypeProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.AbstractRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IBidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IsARelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.EntityChangeListener;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJpaSolver;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorConstants;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtilImpl;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class JPASolver
implements IResourceChangeListener,
IJpaSolver {
    private static Set<JPASolver> solversSet = new HashSet<JPASolver>();
    private static WorkingCopyChangeListener wclsnr = null;
    private Hashtable<String, Object> keyToBO;
    private WeakHashMap<JpaProject, WeakReference<CollectionChangeListener>> projectToEntityListener;
    private WeakHashMap<PersistentType, WeakReference<PropertyChangeListener>> entityToPropListener;
    private WeakHashMap<PersistentAttribute, WeakReference<AttributePropertyChangeListener>> attributeToPropListener;
    private WeakHashMap<PersistentAttribute, WeakReference<AttributeMappingOptionalityChangeListener>> attributeMappingOptionalityToPropListener;
    private WeakHashMap<PersistentAttribute, WeakReference<AttributeJoiningStrategyPropertyChangeListener>> attributeJoiningStrategyToPropListener;
    private WeakHashMap<PersistentAttribute, WeakReference<AttributeRelationshipReferencePropertyChangeListener>> attributeRelationshipReferenceToPropListener;
    private WeakHashMap<PersistentType, WeakReference<ListChangeListener>> entityToAtListener;
    private WeakHashMap<PersistentType, WeakReference<ListChangeListener>> entityToOrmAtListener;
    private WeakHashMap<PersistentType, WeakReference<StateChangeListener>> entityToStateListener;
    private EntityChangeListener entityNameListener;
    private IJPAEditorFeatureProvider featureProvider;
    private HashSet<String> removeIgnore = new HashSet();
    private HashSet<String> removeRelIgnore = new HashSet();
    private Collection<PersistentType> persistentTypes = new HashSet<PersistentType>();
    private HashSet<String> addIgnore = new HashSet();
    private Hashtable<String, IRelation> attribToRel;
    private Hashtable<String, HasReferanceRelation> attribToEmbeddedRel = new Hashtable();
    private Hashtable<String, IsARelation> attribToIsARel = new Hashtable();
    private static final String SEPARATOR = "-";
    private IEclipseFacade eclipseFacade;
    private IJPAEditorUtil util = null;
    public static boolean ignoreEvents = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPASolver() {
        this(EclipseFacade.INSTANCE, new JPAEditorUtilImpl());
        Class<JPASolver> clazz = JPASolver.class;
        synchronized (JPASolver.class) {
            if (wclsnr == null) {
                wclsnr = new WorkingCopyChangeListener();
                JavaCore.addElementChangedListener((IElementChangedListener)wclsnr, (int)5);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            solversSet.add(this);
            return;
        }
    }

    public JPASolver(IEclipseFacade eclipseFacade, IJPAEditorUtil util) {
        this.eclipseFacade = eclipseFacade;
        eclipseFacade.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 22);
        this.keyToBO = new Hashtable();
        this.attribToRel = new Hashtable();
        this.projectToEntityListener = new WeakHashMap();
        this.entityToPropListener = new WeakHashMap();
        this.attributeToPropListener = new WeakHashMap();
        this.attributeMappingOptionalityToPropListener = new WeakHashMap();
        this.attributeJoiningStrategyToPropListener = new WeakHashMap();
        this.attributeRelationshipReferenceToPropListener = new WeakHashMap();
        this.entityToAtListener = new WeakHashMap();
        this.entityToOrmAtListener = new WeakHashMap();
        this.entityToStateListener = new WeakHashMap();
        this.entityNameListener = new EntityChangeListener(this);
        this.entityNameListener.setName("Entity Name Change Listener");
        this.util = util;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.closeDiagramEditorIfProjectIsDeleted(event);
        this.unregisterDeltedEntity(event);
        IMarkerDelta[] markerDeltas = event.findMarkerDeltas(null, true);
        HashSet<IFile> filesToUpdate = new HashSet<IFile>();
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().getType() == 1) {
                filesToUpdate.add((IFile)delta.getResource());
            }
            ++n2;
        }
        boolean updateEditor = false;
        block1: for (IFile file : filesToUpdate) {
            for (PersistentType jpt : this.entityToPropListener.keySet()) {
                if (!jpt.getResource().equals((Object)file)) continue;
                PictogramElement element = this.featureProvider.getPictogramElementForBusinessObject(jpt);
                if (element == null) continue block1;
                updateEditor = true;
                break block1;
            }
        }
        if (updateEditor) {
            this.eclipseFacade.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (JPASolver.this.featureProvider != null) {
                        try {
                            JPASolver.this.featureProvider.getDiagramTypeProvider().getDiagramBehavior().refresh();
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    public void addRemoveIgnore(String atName) {
        this.removeIgnore.add(atName);
    }

    public void addRemoveRelIgnore(String atName) {
        this.removeRelIgnore.add(atName);
    }

    public void addJPTForUpdate(String jptName) {
        this.entityNameListener.addJPTForUpdate(jptName);
    }

    public void addAddIgnore(String atName) {
        this.addIgnore.add(atName);
    }

    public HashSet<String> getAddIgnore() {
        return this.addIgnore;
    }

    public void stopThread() {
        this.entityNameListener.stopThread();
        this.entityNameListener = null;
    }

    public synchronized EntityChangeListener getMonitor() {
        if (this.entityNameListener == null) {
            this.entityNameListener = new EntityChangeListener(this);
            this.entityNameListener.setName("Entity Name Change Listener");
        }
        return this.entityNameListener;
    }

    @Override
    public void setFeatureProvider(IJPAEditorFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
        this.entityNameListener.setFeatureProvider(featureProvider);
        this.entityNameListener.setDaemon(true);
        this.entityNameListener.start();
    }

    public String getKeyForBusinessObject(Object bo) {
        if (bo == null) {
            return "";
        }
        if (bo instanceof PersistentType) {
            PersistentType jpt = (PersistentType)bo;
            String name = jpt.getName();
            return name;
        }
        if (bo instanceof AbstractRelation) {
            return ((AbstractRelation)bo).getId();
        }
        if (bo instanceof HasReferanceRelation) {
            return ((HasReferanceRelation)bo).getId();
        }
        if (bo instanceof IsARelation) {
            return ((IsARelation)bo).getId();
        }
        if (bo instanceof PersistentAttribute) {
            PersistentAttribute at = (PersistentAttribute)bo;
            return String.valueOf(((PersistentType)at.getParent()).getName()) + SEPARATOR + at.getName();
        }
        return bo.toString();
    }

    public Object getBusinessObjectForKey(String key) {
        if (key == null) {
            return null;
        }
        return this.keyToBO.get(key);
    }

    protected String produceOwnerKeyForRel(AbstractRelation rel) {
        return this.produceKeyForRel(rel.getOwner(), rel.getOwnerAttributeName());
    }

    protected String produceKeyForEmbeddedRel(HasReferanceRelation rel) {
        return this.produceKeyForRel(rel.getEmbeddingEntity(), rel.getEmbeddedAnnotatedAttribute().getName());
    }

    protected String produceKeyForIsARel(IsARelation rel) {
        return this.produceKeyForRel(rel.getSubclass(), rel.getSuperclass().getName());
    }

    protected String produceInverseKeyForRel(AbstractRelation rel) {
        return this.produceKeyForRel(rel.getInverse(), rel.getInverseAttributeName());
    }

    private String produceKeyForRel(PersistentType jpt, String attributeName) {
        return String.valueOf(jpt.getName()) + SEPARATOR + attributeName;
    }

    public void addKeyBusinessObject(String key, Object bo) {
        this.keyToBO.put(key, bo);
        if (bo instanceof PersistentType) {
            PersistentType jpt = (PersistentType)bo;
            JpaProject proj = jpt.getJpaProject();
            this.addListenersToProject(proj);
            this.addListenersToEntity(jpt);
            PictogramElement pe = this.featureProvider.getPictogramElementForBusinessObject(jpt);
            if (pe == null) {
                return;
            }
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, JPAEditorConstants.PROP_ENTITY_CLASS_NAME, jpt.getName());
            this.persistentTypes.add(jpt);
        } else if (bo instanceof AbstractRelation) {
            AbstractRelation rel = (AbstractRelation)bo;
            this.attribToRel.put(this.produceOwnerKeyForRel(rel), rel);
            if (rel instanceof IBidirectionalRelation) {
                this.attribToRel.put(this.produceInverseKeyForRel(rel), rel);
            }
        } else if (bo instanceof HasReferanceRelation) {
            HasReferanceRelation rel = (HasReferanceRelation)bo;
            this.attribToEmbeddedRel.put(this.produceKeyForEmbeddedRel(rel), rel);
        } else if (bo instanceof IsARelation) {
            IsARelation rel = (IsARelation)bo;
            this.attribToIsARel.put(this.produceKeyForIsARel(rel), rel);
        } else if (bo instanceof PersistentAttribute) {
            this.addPropertiesListenerToAttribute((PersistentAttribute)bo);
        }
    }

    public Object remove(String key) {
        if (key == null) {
            return null;
        }
        Object o = this.keyToBO.remove(key);
        if (o instanceof PersistentType) {
            CollectionChangeListener ch;
            WeakReference<CollectionChangeListener> ref;
            PersistentType jpt = (PersistentType)o;
            for (PersistentAttribute at : jpt.getAttributes()) {
                String k = this.getKeyForBusinessObject(at);
                this.remove(k);
            }
            this.persistentTypes.remove(jpt);
            this.removeListenersFromEntity(jpt);
            Diagram d = this.featureProvider.getDiagramTypeProvider().getDiagram();
            if (d.getChildren().size() == 1 && (ref = this.projectToEntityListener.remove(jpt.getJpaProject())) != null && (ch = (CollectionChangeListener)ref.get()) != null) {
                jpt.getJpaProject().removeCollectionChangeListener("jpaFiles", ch);
            }
        } else if (o instanceof AbstractRelation) {
            AbstractRelation rel = (AbstractRelation)o;
            this.attribToRel.remove(this.produceOwnerKeyForRel(rel));
            if (rel instanceof IBidirectionalRelation) {
                this.attribToRel.remove(this.produceInverseKeyForRel(rel));
            }
        } else if (o instanceof HasReferanceRelation) {
            HasReferanceRelation rel = (HasReferanceRelation)o;
            this.attribToEmbeddedRel.remove(this.produceKeyForEmbeddedRel(rel));
        } else if (o instanceof IsARelation) {
            IsARelation rel = (IsARelation)o;
            this.attribToIsARel.remove(this.produceKeyForIsARel(rel));
        } else if (o instanceof PersistentAttribute) {
            this.removeListenersFromAttribute((PersistentAttribute)o);
        }
        return o;
    }

    public ICompilationUnit getCompilationUnit(PersistentType jpt) {
        return this.util.getCompilationUnit(jpt);
    }

    public boolean isRelationRelatedToAttribute(PersistentAttribute jpa) {
        String key = this.produceKeyForRel(jpa.getDeclaringPersistentType(), jpa.getName());
        return this.attribToRel.containsKey(key);
    }

    public Set<IRelation> getRelationRelatedToAttribute(PersistentAttribute jpa, String typeName, IJPAEditorFeatureProvider fp) {
        Set<String> keys = this.findRelationshipKey(jpa, typeName, fp);
        HashSet<IRelation> relations = new HashSet<IRelation>();
        Iterator<String> iter = keys.iterator();
        while (iter.hasNext()) {
            relations.add(this.attribToRel.get(iter.next()));
        }
        return relations;
    }

    private Set<String> findRelationshipKey(PersistentAttribute jpa, String typeName, IJPAEditorFeatureProvider fp) {
        JpaArtifactFactory jpaFactory = JpaArtifactFactory.instance();
        HashSet<String> relationShipKeys = new HashSet<String>();
        if (jpaFactory.isEmbeddedAttribute(jpa)) {
            PersistentType embeddableClass = null;
            if (typeName != null) {
                embeddableClass = jpaFactory.findJPT(jpa, fp, typeName);
            } else {
                String attributeTypeName = jpaFactory.getRelTypeName(jpa);
                embeddableClass = jpaFactory.findJPT(jpa, fp, attributeTypeName);
            }
            if (embeddableClass == null) {
                return relationShipKeys;
            }
            for (PersistentAttribute relEntAt : embeddableClass.getAttributes()) {
                IResource r = relEntAt.getDeclaringPersistentType().getResource();
                if (!r.exists()) {
                    throw new RuntimeException();
                }
                AttributeMapping relationAttributeMapping = jpaFactory.getAttributeMapping(relEntAt);
                if (!(relationAttributeMapping instanceof RelationshipMapping)) continue;
                PersistentType jpt = jpaFactory.findJPT(relEntAt, fp, jpaFactory.getRelTypeName(relEntAt));
                if (jpt == null) {
                    return relationShipKeys;
                }
                for (PersistentAttribute attribute : jpt.getAttributes()) {
                    String mappedBy;
                    RelationshipMapping relMapping;
                    MappingRelationship mappingRel;
                    AttributeMapping mapping = jpaFactory.getAttributeMapping(attribute);
                    if (!(mapping instanceof RelationshipMapping) || !((mappingRel = (relMapping = (RelationshipMapping)mapping).getRelationship()) instanceof MappedByRelationship) || !(mappedBy = ((MappedByRelationship)mappingRel).getMappedByStrategy().getMappedByAttribute()).equals(String.valueOf(jpa.getName()) + "." + relEntAt.getName())) continue;
                    relationShipKeys.add(this.produceKeyForRel(jpt, attribute.getName()));
                }
            }
        } else {
            relationShipKeys.add(this.produceKeyForRel((PersistentType)jpa.getParent(), jpa.getName()));
        }
        return relationShipKeys;
    }

    public HasReferanceRelation getEmbeddedRelationToAttribute(PersistentAttribute jpa) {
        String key = this.produceKeyForRel((PersistentType)jpa.getParent(), jpa.getName());
        return this.attribToEmbeddedRel.get(key);
    }

    public Collection<Object> getVisualizedObjects() {
        return this.keyToBO.values();
    }

    public void renewAttributeMappingPropListener(PersistentAttribute ropa) {
        JavaSpecifiedPersistentAttribute jpa = ropa.getJavaPersistentAttribute();
        this.renewAttributeJoiningStrategyPropertyListener((PersistentAttribute)jpa);
        this.renewAttributeMappingOptPropListener((PersistentAttribute)jpa);
        PersistentAttribute pa = JpaArtifactFactory.instance().getORMPersistentAttribute(ropa);
        if (pa != null) {
            this.renewAttributeJoiningStrategyPropertyListener(pa);
            this.renewAttributeMappingOptPropListener(pa);
        }
    }

    public void renewAttributeJoiningStrategyPropertyListener(PersistentAttribute jpa) {
        AttributeMapping jam;
        AttributeJoiningStrategyPropertyChangeListener lsn = null;
        if (this.attributeJoiningStrategyToPropListener == null) {
            return;
        }
        WeakReference<AttributeJoiningStrategyPropertyChangeListener> ref = this.attributeJoiningStrategyToPropListener.remove(jpa);
        if (ref != null) {
            lsn = (AttributeJoiningStrategyPropertyChangeListener)ref.get();
        }
        if ((jam = jpa.getMapping()) == null || !RelationshipMapping.class.isInstance(jam)) {
            return;
        }
        MappingRelationship rr = ((RelationshipMapping)jam).getRelationship();
        if (rr == null) {
            return;
        }
        SpecifiedRelationshipStrategy js = rr.getStrategy();
        if (js == null || !SpecifiedMappedByRelationshipStrategy.class.isInstance(js)) {
            return;
        }
        try {
            if (lsn != null) {
                js.removePropertyChangeListener("mappedByAttribute", (PropertyChangeListener)lsn);
            }
        }
        catch (Exception exception) {}
        lsn = new AttributeJoiningStrategyPropertyChangeListener();
        js.addPropertyChangeListener("mappedByAttribute", (PropertyChangeListener)lsn);
        ref = new WeakReference<AttributeJoiningStrategyPropertyChangeListener>(lsn);
        this.attributeJoiningStrategyToPropListener.put(jpa, ref);
    }

    public void renewAttributeMappingOptPropListener(PersistentAttribute jpa) {
        AttributeMapping jam;
        AttributeMappingOptionalityChangeListener lsn = null;
        WeakReference<AttributeMappingOptionalityChangeListener> ref = this.attributeMappingOptionalityToPropListener.remove(jpa);
        if (ref != null) {
            lsn = (AttributeMappingOptionalityChangeListener)ref.get();
        }
        if ((jam = jpa.getMapping()) == null) {
            return;
        }
        if (!SingleRelationshipMapping.class.isInstance(jam)) {
            return;
        }
        try {
            if (lsn != null) {
                jam.removePropertyChangeListener("specifiedOptional", (PropertyChangeListener)lsn);
            }
        }
        catch (Exception exception) {}
        lsn = new AttributeMappingOptionalityChangeListener();
        jam.addPropertyChangeListener("specifiedOptional", (PropertyChangeListener)lsn);
        ref = new WeakReference<AttributeMappingOptionalityChangeListener>(lsn);
        this.attributeMappingOptionalityToPropListener.put(jpa, ref);
    }

    private void addListenersToProject(JpaProject proj) {
        this.addEntitiesListenerToProject(proj);
    }

    private void addEntitiesListenerToProject(JpaProject proj) {
        WeakReference<CollectionChangeListener> lsnrRef = this.projectToEntityListener.get(proj);
        CollectionChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (CollectionChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new JPAProjectListener();
            proj.addCollectionChangeListener("jpaFiles", lsnr);
            lsnrRef = new WeakReference<CollectionChangeListener>(lsnr);
            this.projectToEntityListener.put(proj, lsnrRef);
        }
    }

    private void addListenersToEntity(PersistentType jpt) {
        this.addAtListenerToEntity(jpt);
        this.addOrmAtListenerToEntity(jpt);
        MappingFileRef fileRef = JpaArtifactFactory.instance().getOrmXmlByForPersistentType(jpt);
        if (fileRef != null) {
            PersistentType pt = fileRef.getPersistentType(jpt.getName());
            this.addPropertiesListenerToEntity(pt);
            this.addStateListenerToEntity(pt);
        }
        this.addPropertiesListenerToEntity(jpt);
        this.addStateListenerToEntity(jpt);
    }

    private void addAtListenerToEntity(PersistentType jpt) {
        WeakReference<ListChangeListener> lsnrRef = this.entityToAtListener.get(jpt);
        ListChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (ListChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new EntityAttributesChangeListener();
            jpt.addListChangeListener("attributes", lsnr);
            lsnrRef = new WeakReference<ListChangeListener>(lsnr);
            this.entityToAtListener.put(jpt, lsnrRef);
        }
    }

    private void addOrmAtListenerToEntity(PersistentType jpt) {
        WeakReference<ListChangeListener> lsnrRef = this.entityToOrmAtListener.get(jpt);
        ListChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (ListChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new EntityAttributesChangeListener();
            jpt.addListChangeListener("specifiedAttributes", lsnr);
            jpt.addListChangeListener("defaultAttributes", lsnr);
            lsnrRef = new WeakReference<ListChangeListener>(lsnr);
            this.entityToOrmAtListener.put(jpt, lsnrRef);
        }
    }

    private void addPropertiesListenerToEntity(PersistentType jpt) {
        WeakReference<PropertyChangeListener> lsnrRef = this.entityToPropListener.get(jpt);
        PropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new EntityPropertyChangeListener();
            jpt.getMapping().addPropertyChangeListener("name", lsnr);
            lsnrRef = new WeakReference<PropertyChangeListener>(lsnr);
            this.entityToPropListener.put(jpt, lsnrRef);
        }
    }

    private void addPropertiesListenerToAttribute(PersistentAttribute ropa) {
        JavaSpecifiedPersistentAttribute jpa = ropa.getJavaPersistentAttribute();
        this.addPropertiesListenerToAttributeItself((PersistentAttribute)jpa);
        this.addPropertiesListenerToJoiningStrategy((PersistentAttribute)jpa);
        this.addPropertiesListenerToRelationshipReference((PersistentAttribute)jpa);
        this.addOptPropListenerToAttributeMapping((PersistentAttribute)jpa);
        PersistentAttribute pa = JpaArtifactFactory.instance().getORMPersistentAttribute(ropa);
        if (pa != null) {
            this.addPropertiesListenerToAttributeItself(pa);
            this.addPropertiesListenerToJoiningStrategy(pa);
            this.addPropertiesListenerToRelationshipReference(pa);
            this.addOptPropListenerToAttributeMapping(pa);
        }
    }

    private void addPropertiesListenerToAttributeItself(PersistentAttribute jpa) {
        WeakReference<AttributePropertyChangeListener> lsnrRef = this.attributeToPropListener.get(jpa);
        AttributePropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (AttributePropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributePropertyChangeListener();
            jpa.addPropertyChangeListener("mapping", (PropertyChangeListener)lsnr);
            lsnrRef = new WeakReference<AttributePropertyChangeListener>(lsnr);
            this.attributeToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addOptPropListenerToAttributeMapping(PersistentAttribute jpa) {
        WeakReference<AttributeMappingOptionalityChangeListener> lsnrRef = this.attributeMappingOptionalityToPropListener.get(jpa);
        AttributeMappingOptionalityChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (AttributeMappingOptionalityChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributeMappingOptionalityChangeListener();
            AttributeMapping jam = jpa.getMapping();
            if (jam == null) {
                return;
            }
            if (SingleRelationshipMapping.class.isInstance(jam)) {
                return;
            }
            jam.addPropertyChangeListener("specifiedOptional", (PropertyChangeListener)lsnr);
            lsnrRef = new WeakReference<AttributeMappingOptionalityChangeListener>(lsnr);
            this.attributeMappingOptionalityToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addPropertiesListenerToJoiningStrategy(PersistentAttribute jpa) {
        WeakReference<AttributeJoiningStrategyPropertyChangeListener> lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        AttributeJoiningStrategyPropertyChangeListener lsnr = null;
        lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        if (lsnrRef != null) {
            lsnr = (AttributeJoiningStrategyPropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributeJoiningStrategyPropertyChangeListener();
            AttributeMapping jam = jpa.getMapping();
            if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                return;
            }
            MappingRelationship rr = ((RelationshipMapping)jam).getRelationship();
            if (rr == null) {
                return;
            }
            SpecifiedRelationshipStrategy js = rr.getStrategy();
            if (js == null || !SpecifiedMappedByRelationshipStrategy.class.isInstance(js)) {
                return;
            }
            lsnrRef = new WeakReference<AttributeJoiningStrategyPropertyChangeListener>(lsnr);
            this.attributeJoiningStrategyToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addPropertiesListenerToRelationshipReference(PersistentAttribute jpa) {
        WeakReference<AttributeRelationshipReferencePropertyChangeListener> lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        AttributeRelationshipReferencePropertyChangeListener lsnr = null;
        lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        if (lsnrRef != null) {
            lsnr = (AttributeRelationshipReferencePropertyChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new AttributeRelationshipReferencePropertyChangeListener();
            AttributeMapping jam = jpa.getMapping();
            if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                return;
            }
            MappingRelationship rr = ((RelationshipMapping)jam).getRelationship();
            if (rr == null) {
                return;
            }
            rr.addPropertyChangeListener("strategy", (PropertyChangeListener)lsnr);
            rr.addPropertyChangeListener("specifiedOptional", (PropertyChangeListener)new AttributeMappingOptionalityChangeListener());
            lsnrRef = new WeakReference<AttributeRelationshipReferencePropertyChangeListener>(lsnr);
            this.attributeRelationshipReferenceToPropListener.put(jpa, lsnrRef);
        }
    }

    private void addStateListenerToEntity(PersistentType jpt) {
        WeakReference<StateChangeListener> lsnrRef = this.entityToStateListener.get(jpt);
        StateChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (StateChangeListener)lsnrRef.get();
        }
        if (lsnr == null) {
            lsnr = new EntityStateChangeListener();
            jpt.addStateChangeListener(lsnr);
            lsnrRef = new WeakReference<StateChangeListener>(lsnr);
            this.entityToStateListener.put(jpt, lsnrRef);
        }
    }

    private void removeListenersFromEntity(PersistentType jpt) {
        this.removeAtListenerFromEntity(jpt);
        this.removeOrmAtListenerFromEntity(jpt);
        MappingFileRef fileRef = JpaArtifactFactory.instance().getOrmXmlByForPersistentType(jpt);
        if (fileRef != null) {
            PersistentType pt = fileRef.getPersistentType(jpt.getName());
            this.removePropListenerFromEntity(pt);
            this.removeStateListenerFromEntity(pt);
        }
        this.removePropListenerFromEntity(jpt);
        this.removeStateListenerFromEntity(jpt);
    }

    private void removeListenersFromAttribute(PersistentAttribute ropa) {
        JavaSpecifiedPersistentAttribute jpa = ropa.getJavaPersistentAttribute();
        this.removePropListenerFromAttribute((PersistentAttribute)jpa);
        PersistentAttribute pa = JpaArtifactFactory.instance().getORMPersistentAttribute(ropa);
        if (pa != null) {
            this.removePropListenerFromAttribute(pa);
        }
    }

    private void removeAtListenerFromEntity(PersistentType jpt) {
        WeakReference<ListChangeListener> lsnrRef = this.entityToAtListener.get(jpt);
        ListChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (ListChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.entityToAtListener.remove(jpt);
            jpt.removeListChangeListener("attributes", lsnr);
        }
    }

    private void removeOrmAtListenerFromEntity(PersistentType jpt) {
        WeakReference<ListChangeListener> lsnrRef = this.entityToOrmAtListener.get(jpt);
        ListChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (ListChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.entityToOrmAtListener.remove(jpt);
            jpt.removeListChangeListener("specifiedAttributes", lsnr);
            jpt.removeListChangeListener("defaultAttributes", lsnr);
        }
    }

    private void removePropListenerFromEntity(PersistentType jpt) {
        WeakReference<PropertyChangeListener> lsnrRef = this.entityToPropListener.get(jpt);
        PropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.entityToPropListener.remove(jpt);
            try {
                jpt.getMapping().removePropertyChangeListener("name", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removePropListenerFromAttribute(PersistentAttribute jpa) {
        this.removePropListenerFromAttributeItself(jpa);
        this.removePropListenerFromJoiningStrategy(jpa);
        this.removePropListenerFromRelationshipReference(jpa);
        this.removeOptPropListenerFromAttributeMapping(jpa);
    }

    private void removePropListenerFromAttributeItself(PersistentAttribute jpa) {
        WeakReference<AttributePropertyChangeListener> lsnrRef = this.attributeToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeToPropListener.remove(jpa);
            try {
                jpa.removePropertyChangeListener("mapping", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removePropListenerFromJoiningStrategy(PersistentAttribute jpa) {
        WeakReference<AttributeJoiningStrategyPropertyChangeListener> lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        lsnrRef = this.attributeJoiningStrategyToPropListener.get(jpa);
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeJoiningStrategyToPropListener.remove(jpa);
            try {
                AttributeMapping jam = jpa.getMapping();
                if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                    return;
                }
                MappingRelationship rr = ((RelationshipMapping)jam).getRelationship();
                if (rr == null) {
                    return;
                }
                SpecifiedRelationshipStrategy js = rr.getStrategy();
                if (js == null || !SpecifiedMappedByRelationshipStrategy.class.isInstance(js)) {
                    return;
                }
                js.removePropertyChangeListener("mappedByAttribute", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removeOptPropListenerFromAttributeMapping(PersistentAttribute jpa) {
        WeakReference<AttributeMappingOptionalityChangeListener> lsnrRef = this.attributeMappingOptionalityToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        lsnrRef = this.attributeMappingOptionalityToPropListener.get(jpa);
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeMappingOptionalityToPropListener.remove(jpa);
            try {
                AttributeMapping jam = jpa.getMapping();
                if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                    return;
                }
                jam.removePropertyChangeListener("specifiedOptional", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removePropListenerFromRelationshipReference(PersistentAttribute jpa) {
        WeakReference<AttributeRelationshipReferencePropertyChangeListener> lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        PropertyChangeListener lsnr = null;
        lsnrRef = this.attributeRelationshipReferenceToPropListener.get(jpa);
        if (lsnrRef != null) {
            lsnr = (PropertyChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.attributeRelationshipReferenceToPropListener.remove(jpa);
            try {
                AttributeMapping jam = jpa.getMapping();
                if (jam == null || !RelationshipMapping.class.isInstance(jam)) {
                    return;
                }
                MappingRelationship rr = ((RelationshipMapping)jam).getRelationship();
                if (rr == null) {
                    return;
                }
                rr.removePropertyChangeListener("strategy", lsnr);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void removeStateListenerFromEntity(PersistentType jpt) {
        WeakReference<StateChangeListener> lsnrRef = this.entityToStateListener.get(jpt);
        StateChangeListener lsnr = null;
        if (lsnrRef != null) {
            lsnr = (StateChangeListener)lsnrRef.get();
        }
        if (lsnr != null) {
            this.entityToStateListener.remove(jpt);
            jpt.removeStateChangeListener(lsnr);
        }
    }

    private void removeEntityStateChangeListeners() {
        Iterator<Object> it = this.entityToStateListener.keySet().iterator();
        HashSet<PersistentType> s = new HashSet<PersistentType>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (PersistentType jpt : s) {
            WeakReference<StateChangeListener> ref = this.entityToStateListener.remove(jpt);
            StateChangeListener lsn = (StateChangeListener)ref.get();
            if (lsn == null) continue;
            jpt.removeStateChangeListener(lsn);
        }
        this.entityToStateListener.clear();
        this.entityToStateListener = null;
    }

    private void removeEntityPropChangeListeners() {
        Iterator<Object> it = this.entityToPropListener.keySet().iterator();
        HashSet<PersistentType> s = new HashSet<PersistentType>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (PersistentType jpt : s) {
            WeakReference<PropertyChangeListener> ref = this.entityToPropListener.remove(jpt);
            PropertyChangeListener lsn = (PropertyChangeListener)ref.get();
            if (lsn == null) continue;
            jpt.getMapping().removePropertyChangeListener("name", lsn);
        }
        this.entityToPropListener.clear();
        this.entityToPropListener = null;
    }

    private void removeAttributePropChangeListeners() {
        Iterator<Object> it = this.attributeToPropListener.keySet().iterator();
        HashSet<PersistentAttribute> s = new HashSet<PersistentAttribute>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (PersistentAttribute jpa : s) {
            WeakReference<AttributePropertyChangeListener> ref = this.attributeToPropListener.remove(jpa);
            PropertyChangeListener lsn = (PropertyChangeListener)ref.get();
            if (lsn == null) continue;
            try {
                jpa.removePropertyChangeListener("mapping", lsn);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.attributeToPropListener.clear();
        this.attributeToPropListener = null;
    }

    private void removeAttributeJoiningStrategyPropChangeListeners() {
        Iterator<Object> it = this.attributeJoiningStrategyToPropListener.keySet().iterator();
        HashSet<PersistentAttribute> s = new HashSet<PersistentAttribute>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (PersistentAttribute jpa : s) {
            WeakReference<AttributeJoiningStrategyPropertyChangeListener> ref = this.attributeJoiningStrategyToPropListener.remove(jpa);
            PropertyChangeListener lsn = (PropertyChangeListener)ref.get();
            if (lsn == null) continue;
            try {
                jpa.getMapping().removePropertyChangeListener("mappedByAttribute", lsn);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.attributeJoiningStrategyToPropListener.clear();
        this.attributeJoiningStrategyToPropListener = null;
    }

    private void removeOptPropListeners() {
        Iterator<Object> it = this.attributeMappingOptionalityToPropListener.keySet().iterator();
        HashSet<PersistentAttribute> s = new HashSet<PersistentAttribute>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (PersistentAttribute jpa : s) {
            AttributeMapping jam;
            PropertyChangeListener lsn;
            WeakReference<AttributeMappingOptionalityChangeListener> ref = this.attributeMappingOptionalityToPropListener.remove(jpa);
            if (ref == null || (lsn = (PropertyChangeListener)ref.get()) == null || (jam = jpa.getMapping()) == null || !RelationshipMapping.class.isInstance(jam)) continue;
            try {
                jam.removePropertyChangeListener("specifiedOptional", lsn);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.attributeRelationshipReferenceToPropListener.clear();
        this.attributeRelationshipReferenceToPropListener = null;
    }

    private void removeEntityAttributeChangeListeners() {
        Iterator<Object> it = this.entityToAtListener.keySet().iterator();
        HashSet<PersistentType> s = new HashSet<PersistentType>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (PersistentType jpt : s) {
            WeakReference<ListChangeListener> ref1;
            ListChangeListener lsn1;
            WeakReference<ListChangeListener> ref = this.entityToAtListener.remove(jpt);
            ListChangeListener lsn = (ListChangeListener)ref.get();
            if (lsn != null) {
                jpt.removeListChangeListener("attributes", lsn);
            }
            if ((lsn1 = (ListChangeListener)(ref1 = this.entityToOrmAtListener.remove(jpt)).get()) == null) continue;
            jpt.removeListChangeListener("specifiedAttributes", lsn1);
        }
        this.entityToAtListener.clear();
        this.entityToOrmAtListener.clear();
        this.entityToAtListener = null;
        this.entityToOrmAtListener = null;
    }

    private void removeProjectListeners() {
        Iterator<Object> it = this.projectToEntityListener.keySet().iterator();
        HashSet<JpaProject> s = new HashSet<JpaProject>();
        while (it.hasNext()) {
            s.add(it.next());
        }
        for (JpaProject project : s) {
            WeakReference<CollectionChangeListener> ref = this.projectToEntityListener.remove(project);
            CollectionChangeListener lsn = (CollectionChangeListener)ref.get();
            if (lsn == null) continue;
            project.removeCollectionChangeListener("jpaFiles", lsn);
        }
        this.projectToEntityListener.clear();
        this.projectToEntityListener = null;
    }

    private void removeAllListeners() {
        this.removeOptPropListeners();
        this.removeAttributeJoiningStrategyPropChangeListeners();
        this.removeAttributePropChangeListeners();
        this.removeEntityStateChangeListeners();
        this.removeEntityPropChangeListeners();
        this.removeEntityAttributeChangeListeners();
        this.removeProjectListeners();
        this.eclipseFacade.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        for (Object bo : this.keyToBO.values()) {
            ICompilationUnit cu;
            if (!PersistentType.class.isInstance(bo) || (cu = this.util.getCompilationUnit((PersistentType)bo)) == null) continue;
            this.util.discardWorkingCopyOnce(cu);
        }
        this.util = null;
        this.keyToBO.clear();
        this.attribToRel.clear();
        this.attribToEmbeddedRel.clear();
        this.attribToIsARel.clear();
        this.persistentTypes.clear();
        this.keyToBO = null;
        this.attribToRel = null;
        this.persistentTypes = null;
        this.removeAllListeners();
        this.featureProvider = null;
        Class<JPASolver> clazz = JPASolver.class;
        synchronized (JPASolver.class) {
            solversSet.remove(this);
            if (solversSet.isEmpty()) {
                JavaCore.removeElementChangedListener((IElementChangedListener)wclsnr);
                wclsnr = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean containsKey(String key) {
        return this.keyToBO.containsKey(key);
    }

    public void restoreEntity(PersistentType jpt) {
        if (jpt == null) {
            return;
        }
        ICompilationUnit cu = this.getCompilationUnit(jpt);
        JPAEditorUtil.discardWorkingCopyOnce(cu);
        JPAEditorUtil.becomeWorkingCopy(cu);
    }

    public void addAttribForUpdate(PersistenceUnit pu, String entAtMappedBy) {
        this.entityNameListener.addAttribForUpdate(pu, entAtMappedBy);
    }

    private void updateJPTName(PersistentType jpt) {
        String entName = JpaArtifactFactory.instance().getEntityName(jpt);
        entName = JPAEditorUtil.returnSimpleName(entName);
        ContainerShape entShape = (ContainerShape)this.featureProvider.getPictogramElementForBusinessObject(jpt);
        JPAEditorUtil.setJPTNameInShape(entShape, entName);
    }

    private void closeDiagramEditorIfProjectIsDeleted(IResourceChangeEvent event) {
        final IResource resource = event.getResource();
        if ((resource != null && !resource.exists() || event.getType() == 2 || event.getType() == 4) && resource instanceof IProject) {
            ModelIntegrationUtil.deleteDiagramXMIFile(ModelIntegrationUtil.getDiagramByProject((IProject)resource));
            IDiagramTypeProvider provider = this.featureProvider.getDiagramTypeProvider();
            if (provider instanceof JPAEditorDiagramTypeProvider) {
                final JPADiagramEditor diagramBySelectedProject = ((JPAEditorDiagramTypeProvider)provider).getDiagramEditor();
                final Diagram diagram = ((JPAEditorDiagramTypeProvider)provider).getDiagram();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        JpaProject jpaProject = ModelIntegrationUtil.getProjectByDiagram(diagram.getName());
                        if (jpaProject != null && jpaProject.getProject().equals((Object)resource)) {
                            page.closeEditor((IEditorPart)diagramBySelectedProject, false);
                        }
                    }
                });
            }
        }
    }

    private void unregisterDeltedEntity(IResourceChangeEvent event) {
        IResourceDelta[] deltas;
        if (event.getType() == 2 || event.getType() == 4) {
            return;
        }
        IResourceDelta changedDelta = event.getDelta();
        IResourceDelta[] iResourceDeltaArray = deltas = changedDelta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource resource = delta.getResource();
            if (resource != null && resource.exists() && resource instanceof IProject) {
                IProject project = (IProject)resource;
                IResourceDelta[] iResourceDeltaArray2 = delta.getAffectedChildren();
                int n3 = iResourceDeltaArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResourceDelta deltaResource = iResourceDeltaArray2[n4];
                    List<IResourceDelta> resources = new ArrayList<IResourceDelta>();
                    resources = this.findDeletedResource(deltaResource, resources);
                    for (IResourceDelta resourceDelta : resources) {
                        IFile file;
                        if (!(resourceDelta.getResource() instanceof File) || (file = this.eclipseFacade.getWorkspace().getRoot().getFile(((File)resourceDelta.getResource()).getFullPath())).exists() || !file.getFileExtension().equals("java")) continue;
                        try {
                            IPackageFragmentRoot[] fragmentRoots;
                            JpaProject jpaProject = JpaArtifactFactory.instance().getJpaProject((IProject)resource);
                            if (jpaProject == null) continue;
                            IJavaProject javaProject = JavaCore.create((IProject)project);
                            IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots = javaProject.getAllPackageFragmentRoots();
                            int n5 = fragmentRoots.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IPackageFragmentRoot fragmentRoot = iPackageFragmentRootArray[n6];
                                if (fragmentRoot instanceof PackageFragmentRoot && fragmentRoot.getKind() == 1) {
                                    PackageFragmentRoot packageFragmentRoot = (PackageFragmentRoot)fragmentRoot;
                                    String sourcefolder = packageFragmentRoot.getResource().getName();
                                    String[] fq = file.getFullPath().toString().split(sourcefolder);
                                    String fqName = fq[1].replace("/", ".");
                                    fqName = fqName.replaceFirst(".", "").replace(".java", "");
                                }
                                ++n6;
                            }
                        }
                        catch (CoreException e) {
                            JPADiagramEditorPlugin.logError(e);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private List<IResourceDelta> findDeletedResource(IResourceDelta delta, List<IResourceDelta> resources) {
        IResourceDelta[] deltas;
        IResourceDelta[] iResourceDeltaArray = deltas = delta.getAffectedChildren();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta del = iResourceDeltaArray[n2];
            this.findDeletedResource(del, resources);
            if (del.getAffectedChildren().length == 0) {
                resources.add(del);
            }
            ++n2;
        }
        return resources;
    }

    public Collection<PersistentType> getPersistentTypes() {
        return this.persistentTypes;
    }

    public class AddEntityAttributes
    implements Runnable {
        ListAddEvent event = null;

        public AddEntityAttributes(ListAddEvent event) {
            this.event = event;
        }

        @Override
        public synchronized void run() {
            try {
                PersistentType jpt = (PersistentType)this.event.getSource();
                ContainerShape entShape = (ContainerShape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(jpt);
                ArrayIterator it = (ArrayIterator)this.event.getItems().iterator();
                while (it.hasNext()) {
                    PersistentAttribute at = (PersistentAttribute)it.next();
                    if (JPASolver.this.addIgnore.remove(String.valueOf(at.getDeclaringPersistentType().getName()) + "." + at.getName())) continue;
                    AddContext ctx = new AddContext();
                    ctx.setNewObject((Object)at);
                    ctx.setTargetContainer(entShape);
                    AddAttributeFeature ft = new AddAttributeFeature(JPASolver.this.featureProvider);
                    ft.add((IAddContext)ctx);
                }
                JPASolver.this.featureProvider.addJPTForUpdate(jpt.getName());
            }
            catch (Exception exception) {}
        }
    }

    public class AttributeJoiningStrategyPropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            Model m = event.getSource();
            if (!SpecifiedMappedByRelationshipStrategy.class.isInstance(m)) {
                return;
            }
            SpecifiedMappedByRelationshipStrategy js = (SpecifiedMappedByRelationshipStrategy)m;
            JpaContextModel nd = js.getParent();
            if (nd == null) {
                return;
            }
            if ((nd = nd.getParent()) == null) {
                return;
            }
            if ((nd = nd.getParent()) == null || !PersistentAttribute.class.isInstance(nd)) {
                return;
            }
            PersistentAttribute at = (PersistentAttribute)nd;
            if (!at.getDeclaringPersistentType().getParent().getResource().exists()) {
                return;
            }
            PictogramElement pe = JPASolver.this.featureProvider.getPictogramElementForBusinessObject(at.getDeclaringPersistentType());
            final GraphicalRemoveAttributeFeature remove = new GraphicalRemoveAttributeFeature(JPASolver.this.featureProvider);
            final CustomContext ctx = new CustomContext();
            ctx.setInnerPictogramElement(pe);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        remove.execute((ICustomContext)ctx);
                    }
                    catch (Exception exception) {}
                }
            };
            Display.getDefault().asyncExec(runnable);
        }
    }

    public class AttributeMappingOptionalityChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            Boolean optional = (Boolean)event.getNewValue();
            boolean isOptional = optional == null ? true : optional;
            OptionalMapping nm = (OptionalMapping)event.getSource();
            PersistentAttribute jpa = (PersistentAttribute)nm.getParent();
            IRelation rel = JPASolver.this.featureProvider.getRelationRelatedToAttribute(jpa, JpaArtifactFactory.instance().getRelTypeName(jpa)).iterator().next();
            boolean atBeginning = !rel.getOwner().getName().equals(jpa.getDeclaringPersistentType().getName()) || !rel.getOwnerAttributeName().equals(jpa.getName());
            final Connection c = (Connection)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel);
            EList conDecs = c.getConnectionDecorators();
            Iterator it = conDecs.iterator();
            final String newLabelText = isOptional ? JPAEditorConstants.CARDINALITY_ZERO_ONE : JPAEditorConstants.CARDINALITY_ONE;
            while (it.hasNext()) {
                final ConnectionDecorator cd = (ConnectionDecorator)it.next();
                if (!JPAEditorUtil.isCardinalityDecorator(cd)) continue;
                double d = cd.getLocation();
                if (atBeginning && d > 0.5 || !atBeginning && d <= 0.5) continue;
                TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)cd);
                ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                    protected void doExecute() {
                        Text txt = (Text)cd.getGraphicsAlgorithm();
                        txt.setValue(newLabelText);
                        Point pt = JPAEditorUtil.recalcTextDecoratorPosition((FreeFormConnection)c, cd);
                        Graphiti.getGaService().setLocation((GraphicsAlgorithm)txt, pt.x, pt.y, false);
                    }
                });
                break;
            }
        }
    }

    public class AttributePropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            Model source = event.getSource();
            if (!PersistentAttribute.class.isInstance(source)) {
                return;
            }
            PictogramElement pe = JPASolver.this.featureProvider.getPictogramElementForBusinessObject(((PersistentAttribute)source).getDeclaringPersistentType());
            final GraphicalRemoveAttributeFeature remove = new GraphicalRemoveAttributeFeature(JPASolver.this.featureProvider);
            final CustomContext ctx = new CustomContext();
            ctx.setInnerPictogramElement(pe);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    remove.execute((ICustomContext)ctx);
                }
            };
            Display.getDefault().asyncExec(runnable);
            String propName = event.getPropertyName();
            if (propName.equals("mapping")) {
                JPASolver.this.renewAttributeMappingPropListener((PersistentAttribute)source);
            }
        }
    }

    public class AttributeRelationshipReferencePropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            SpecifiedRelationship rr = (SpecifiedRelationship)event.getSource();
            JpaContextModel p = rr.getParent();
            if (p == null) {
                return;
            }
            if ((p = p.getParent()) == null) {
                return;
            }
            if (!PersistentAttribute.class.isInstance(p)) {
                return;
            }
            PersistentAttribute jpa = (PersistentAttribute)p;
            JPASolver.this.renewAttributeJoiningStrategyPropertyListener(jpa);
            if (!jpa.getDeclaringPersistentType().getParent().getResource().exists()) {
                return;
            }
            if (JPASolver.this.featureProvider == null) {
                return;
            }
            PictogramElement pe = JPASolver.this.featureProvider.getPictogramElementForBusinessObject(jpa.getDeclaringPersistentType());
            final GraphicalRemoveAttributeFeature remove = new GraphicalRemoveAttributeFeature(JPASolver.this.featureProvider);
            final CustomContext ctx = new CustomContext();
            ctx.setInnerPictogramElement(pe);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        remove.execute((ICustomContext)ctx);
                    }
                    catch (Exception exception) {}
                }
            };
            Display.getDefault().asyncExec(runnable);
        }
    }

    public class EntityAttributesChangeListener
    implements ListChangeListener {
        public void itemsAdded(ListAddEvent event) {
            AddEntityAttributes task = new AddEntityAttributes(event);
            Display.getDefault().asyncExec((Runnable)task);
        }

        public void itemsRemoved(ListRemoveEvent event) {
            RemoveEntityAttributes task = new RemoveEntityAttributes(event);
            Display.getDefault().asyncExec((Runnable)task);
        }

        public void listChanged(ListChangeEvent event) {
        }

        public void itemsMoved(ListMoveEvent arg0) {
        }

        public void itemsReplaced(ListReplaceEvent arg0) {
        }

        public void listCleared(ListClearEvent arg0) {
        }
    }

    public class EntityPropertyChangeListener
    implements PropertyChangeListener {
        public synchronized void propertyChanged(PropertyChangeEvent event) {
            String propName = event.getPropertyName();
            if (propName.equals(JPAEditorConstants.PROP_SPECIFIED_NAME)) {
                final Entity je = (Entity)event.getSource();
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        TransactionalEditingDomain ted = JPASolver.this.featureProvider.getTransactionalEditingDomain();
                        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                            protected void doExecute() {
                                PersistentType jpt = je.getPersistentType();
                                JPASolver.this.updateJPTName(jpt);
                                String tableName = JPAEditorUtil.formTableName(jpt);
                                JpaArtifactFactory.instance().setTableName(jpt, tableName);
                            }
                        });
                    }
                };
                Display.getDefault().syncExec(job);
            }
        }
    }

    public class EntityStateChangeListener
    implements StateChangeListener {
        public void stateChanged(StateChangeEvent event) {
        }
    }

    public class JPAProjectListener
    implements CollectionChangeListener {
        public synchronized void itemsRemoved(CollectionRemoveEvent event) {
            if (ignoreEvents) {
                return;
            }
            for (Object o : event.getItems()) {
                JavaResourceCompilationUnit jrcu;
                IType type;
                if (!(o instanceof JpaFile)) continue;
                JpaFile jpaFile = (JpaFile)o;
                JptResourceModel jrm = ((JpaFile)o).getResourceModel();
                if (!JavaResourceCompilationUnit.class.isInstance(jrm) || (type = (jrcu = (JavaResourceCompilationUnit)jrm).getCompilationUnit().findPrimaryType()) == null) continue;
                String name = type.getFullyQualifiedName();
                JpaProject jpaProject = jpaFile.getJpaProject();
                PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpaProject);
                if (pu == null) continue;
                PersistentType jpt = pu.getPersistentType(name);
                final ContainerShape cs = (ContainerShape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(jpt);
                if (cs == null) {
                    return;
                }
                final RemoveContext ctx = new RemoveContext((PictogramElement)cs);
                final IRemoveFeature ft = JPASolver.this.featureProvider.getRemoveFeature((IRemoveContext)ctx);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)cs);
                        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                            protected void doExecute() {
                                ft.remove((IRemoveContext)ctx);
                            }
                        });
                    }
                };
                Display.getDefault().syncExec(r);
            }
        }

        public void collectionCleared(CollectionClearEvent arg0) {
        }

        public void collectionChanged(CollectionChangeEvent event) {
        }

        public void itemsAdded(CollectionAddEvent event) {
        }
    }

    public class RemoveEntityAttributes
    implements Runnable {
        ListRemoveEvent event = null;

        public RemoveEntityAttributes(ListRemoveEvent event) {
            this.event = event;
        }

        @Override
        public synchronized void run() {
            try {
                ArrayIterator it = (ArrayIterator)this.event.getItems().iterator();
                HashSet<Shape> shapesToRemove = new HashSet<Shape>();
                while (it.hasNext()) {
                    Shape atShape;
                    PersistentAttribute at = (PersistentAttribute)it.next();
                    if (JPASolver.this.removeIgnore.remove(String.valueOf(at.getDeclaringPersistentType().getName()) + "." + at.getName()) || (atShape = (Shape)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(at)) == null) continue;
                    PersistentType jpt = (PersistentType)this.event.getSource();
                    PersistentAttribute newAt = jpt.getAttributeNamed(at.getName());
                    if (newAt != null) {
                        RemoveAttributeFeature ft = new RemoveAttributeFeature(JPASolver.this.featureProvider, true, true);
                        RemoveContext c = new RemoveContext((PictogramElement)atShape);
                        try {
                            ft.remove((IRemoveContext)c);
                        }
                        catch (Exception exception) {}
                        AddAttributeFeature ft1 = new AddAttributeFeature(JPASolver.this.featureProvider);
                        AddContext c1 = new AddContext();
                        c1.setNewObject((Object)newAt);
                        ft1.add((IAddContext)c1);
                        return;
                    }
                    shapesToRemove.add(atShape);
                    Set<IRelation> rels = JPASolver.this.featureProvider.getRelationRelatedToAttribute(at, JpaArtifactFactory.instance().getRelTypeName(at));
                    for (IRelation rel : rels) {
                        Connection conn = (Connection)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel);
                        if (conn == null) {
                            HasReferanceRelation embedRel = JPASolver.this.featureProvider.getEmbeddedRelationRelatedToAttribute(at);
                            if (embedRel == null) continue;
                            conn = (Connection)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(embedRel);
                        }
                        while (conn != null) {
                            RemoveContext ctx = new RemoveContext((PictogramElement)conn);
                            RemoveRelationFeature ft = new RemoveRelationFeature(JPASolver.this.featureProvider);
                            ft.remove((IRemoveContext)ctx);
                            conn = (Connection)JPASolver.this.featureProvider.getPictogramElementForBusinessObject(rel);
                        }
                    }
                }
                for (Shape atShape : shapesToRemove) {
                    RemoveContext ctx = new RemoveContext((PictogramElement)atShape);
                    RemoveAttributeFeature ft = new RemoveAttributeFeature(JPASolver.this.featureProvider, true, true);
                    ft.remove((IRemoveContext)ctx);
                }
                JpaArtifactFactory.instance().addNewRelations(JPASolver.this.featureProvider, (PersistentType)this.event.getSource());
            }
            catch (Exception exception) {}
        }
    }

    public static class WorkingCopyChangeListener
    implements IElementChangedListener {
        public synchronized void elementChanged(ElementChangedEvent event) {
            Object o = event.getSource();
            if (!IJavaElementDelta.class.isInstance(o)) {
                return;
            }
            IJavaElementDelta jed = (IJavaElementDelta)o;
            Set<ICompilationUnit> affectedCompilationUnits = this.getAffectedCompilationUnits(jed);
            for (ICompilationUnit cu : affectedCompilationUnits) {
                PersistentType jpt = JPAEditorUtil.getJPType(cu);
                for (JPASolver solver : solversSet) {
                    ContainerShape cs = (ContainerShape)solver.featureProvider.getPictogramElementForBusinessObject(jpt);
                    if (cs == null) {
                        return;
                    }
                    String entName = JPAEditorUtil.getText(jpt);
                    try {
                        String newHeader = String.valueOf(cu.hasUnsavedChanges() ? "* " : "") + entName;
                        GraphicsUpdater.updateHeader(cs, newHeader);
                    }
                    catch (JavaModelException e) {
                        JPADiagramEditorPlugin.logError("Cannot check compilation unit for unsaved changes", e);
                    }
                }
            }
        }

        private Set<ICompilationUnit> getAffectedCompilationUnits(IJavaElementDelta delta) {
            IJavaElementDelta[] children;
            HashSet<ICompilationUnit> res = new HashSet<ICompilationUnit>();
            IJavaElement el = delta.getElement();
            if (ICompilationUnit.class.isInstance(el)) {
                res.add((ICompilationUnit)el);
            }
            IJavaElementDelta[] iJavaElementDeltaArray = children = delta.getChangedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                Set<ICompilationUnit> cus = this.getAffectedCompilationUnits(child);
                res.addAll(cus);
                ++n2;
            }
            return res;
        }
    }
}

