/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.internal.provider.FilteredViewProviderAdapter;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.EMFFormsFilteredViewService;
import org.eclipse.emf.ecp.view.spi.provider.EMFFormsViewService;
import org.eclipse.emf.ecp.view.spi.provider.IFilteredViewProvider;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;
import org.eclipse.emf.ecp.view.spi.provider.reporting.NoViewProviderFoundReport;
import org.eclipse.emf.ecp.view.spi.provider.reporting.ViewModelIsNullReport;
import org.eclipse.emf.ecp.view.spi.provider.reporting.ViewProviderInitFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="EMFFormsViewService", service={EMFFormsViewService.class, EMFFormsFilteredViewService.class})
public class ViewProviderImpl
implements EMFFormsFilteredViewService {
    private static final String CLASS_CANNOT_BE_RESOLVED = "%1$s cannot be loaded because bundle %2$s cannot be resolved.";
    private static final String CLASS = "class";
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.ecp.ui.view.viewModelProviders";
    private final Set<IFilteredViewProvider> viewProviders = new CopyOnWriteArraySet<IFilteredViewProvider>();
    private ReportService reportService;

    @Activate
    protected void activate() {
        this.readViewProviders();
    }

    private void readViewProviders() {
        IConfigurationElement[] controls;
        IConfigurationElement[] iConfigurationElementArray = controls = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String clazz = e.getAttribute(CLASS);
                Class resolvedClass = ViewProviderImpl.loadClass(e.getContributor().getName(), clazz);
                Constructor controlConstructor = resolvedClass.getConstructor(new Class[0]);
                IViewProvider viewProvider = (IViewProvider)controlConstructor.newInstance(new Object[0]);
                this.viewProviders.add(FilteredViewProviderAdapter.adapt(viewProvider));
            }
            catch (ClassNotFoundException ex) {
                this.report(new ViewProviderInitFailedReport(ex));
            }
            catch (NoSuchMethodException ex) {
                this.report(new ViewProviderInitFailedReport(ex));
            }
            catch (SecurityException ex) {
                this.report(new ViewProviderInitFailedReport(ex));
            }
            catch (InstantiationException ex) {
                this.report(new ViewProviderInitFailedReport(ex));
            }
            catch (IllegalAccessException ex) {
                this.report(new ViewProviderInitFailedReport(ex));
            }
            catch (IllegalArgumentException ex) {
                this.report(new ViewProviderInitFailedReport(ex));
            }
            catch (InvocationTargetException ex) {
                this.report(new ViewProviderInitFailedReport(ex));
            }
            ++n2;
        }
    }

    private void report(AbstractReport reportEntity) {
        this.reportService.report(reportEntity);
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.format(CLASS_CANNOT_BE_RESOLVED, clazz, bundleName));
        }
        return bundle.loadClass(clazz);
    }

    @Override
    public VView getView(EObject object, VViewModelProperties properties, Collection<String> requiredKeys) {
        VView result = null;
        if (this.viewProviders.isEmpty()) {
            this.report(new NoViewProviderFoundReport());
            return result;
        }
        double highestPrio = -1.0;
        IFilteredViewProvider selectedProvider = null;
        if (properties == null) {
            properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        }
        for (IFilteredViewProvider viewProvider : this.viewProviders) {
            double prio = viewProvider.canProvideViewModel(object, properties, requiredKeys);
            if (!(prio > highestPrio)) continue;
            highestPrio = prio;
            selectedProvider = viewProvider;
        }
        if (selectedProvider != null && (result = selectedProvider.provideViewModel(object, properties, requiredKeys)) == null) {
            this.report(new ViewModelIsNullReport());
        }
        return result;
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addProvider(IViewProvider viewProvider) {
        this.viewProviders.add(FilteredViewProviderAdapter.adapt(viewProvider));
    }

    @Override
    public void removeProvider(IViewProvider viewProvider) {
        IFilteredViewProvider filtered = FilteredViewProviderAdapter.adapt(viewProvider);
        this.viewProviders.remove(filtered);
        FilteredViewProviderAdapter.dispose(filtered);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }
}

