/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.ui;

import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.internal.core.model.CodanProblemMarker;
import org.eclipse.cdt.codan.ui.CodanEditorUtility;
import org.eclipse.core.resources.IMarker;

public abstract class AbstractCodanProblemDetailsProvider {
    protected IMarker marker;

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    protected String getProblemMessage() {
        String message = this.marker.getAttribute("message", "");
        return message;
    }

    protected String getProblemId() {
        String id = this.marker.getAttribute("id", null);
        return id;
    }

    public abstract boolean isApplicable(String var1);

    public String getProblemArgument(int index) {
        return CodanProblemMarker.getProblemArgument((IMarker)this.marker, (int)index);
    }

    public String[] getProblemArguments() {
        return CodanProblemMarker.getProblemArguments((IMarker)this.marker);
    }

    public String getStyledProblemMessage() {
        String message = this.escapeForLink(this.getProblemMessage());
        String href = this.getLocationHRef();
        String link = this.getLocation();
        return "<a href=\"" + href + "\">" + link + "</a> \n" + message + "\n";
    }

    protected String getLocationHRef() {
        return CodanEditorUtility.getLocationHRef(this.marker);
    }

    protected String getLocation() {
        return CodanEditorUtility.getLocation(this.marker);
    }

    public String getStyledProblemDescription() {
        String id = this.getProblemId();
        if (id == null) {
            return "";
        }
        IProblem problem = CodanRuntime.getInstance().getCheckersRegistry().getDefaultProfile().findProblem(id);
        String desc = problem.getDescription();
        if (desc == null) {
            return "";
        }
        return this.escapeForLink(desc);
    }

    protected String escapeForLink(String text) {
        return text.replaceAll("&", "&&");
    }
}

