/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.project.facet;

import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.StringTokenizer;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.project.facet.ISimpleWebFacetInstallDataModelProperties;
import org.eclipse.wst.project.facet.ProductManager;
import org.eclipse.wst.web.internal.ResourceHandler;

public class SimpleWebFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements ISimpleWebFacetInstallDataModelProperties {
    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("IStaticWebFacetInstallDataModelProperties.CONTENT_DIR");
        names.add("IStaticWebFacetInstallDataModelProperties.CONTEXT_ROOT");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IStaticWebFacetInstallDataModelProperties.CONTENT_DIR")) {
            return ProductManager.getProperty("staticWebContent");
        }
        if (propertyName.equals("IStaticWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME").replace(' ', '_');
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "wst.web";
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("IStaticWebFacetInstallDataModelProperties.CONTEXT_ROOT", 4);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        if (name.equals("IStaticWebFacetInstallDataModelProperties.CONTEXT_ROOT")) {
            return this.validateContextRoot(this.getStringProperty("IStaticWebFacetInstallDataModelProperties.CONTEXT_ROOT"));
        }
        if (name.equals("IStaticWebFacetInstallDataModelProperties.CONTENT_DIR")) {
            String folderName = this.model.getStringProperty("IStaticWebFacetInstallDataModelProperties.CONTENT_DIR");
            if (folderName == null || folderName.length() == 0 || folderName.equals("/") || folderName.equals("\\")) {
                String errorMessage = WTPCommonPlugin.getResourceString((String)"40");
                return WTPCommonPlugin.createErrorStatus((String)errorMessage);
            }
            IStatus status = this.validateFolderName(folderName);
            if (status.isOK() && folderName.indexOf(35) != -1) {
                String message = NLS.bind((String)Messages.resources_invalidCharInName, (Object)"#", (Object)folderName);
                status = new ResourceStatus(77, null, message);
            }
            return status;
        }
        return super.validate(name);
    }

    protected IStatus validateContextRoot(String contextRoot) {
        if (contextRoot == null || contextRoot.length() == 0) {
            return new ResourceStatus(77, null, ResourceHandler.Context_Root_cannot_be_empty_2);
        }
        if (contextRoot.trim().equals(contextRoot)) {
            StringTokenizer stok = new StringTokenizer(contextRoot, ".");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                int i = 0;
                while (i < token.length()) {
                    int cp = UTF16.charAt((String)token, (int)i);
                    if (token.charAt(i) == ' ') {
                        return new ResourceStatus(77, null, ResourceHandler.Names_cannot_contain_whitespace);
                    }
                    if (token.charAt(i) != '_' && token.charAt(i) != '-' && token.charAt(i) != '/' && !Character.isLetterOrDigit(token.charAt(i))) {
                        String invalidCharString = null;
                        invalidCharString = UTF16.getCharCount((int)cp) > 1 ? UTF16.valueOf((int)cp) : new Character(token.charAt(i)).toString();
                        Object[] invalidChar = new Object[]{invalidCharString};
                        String errorStatus = ResourceHandler.getString(ResourceHandler.The_character_is_invalid_in_a_context_root, invalidChar);
                        return new ResourceStatus(77, null, errorStatus);
                    }
                    i += UTF16.getCharCount((int)cp);
                }
            }
        } else {
            return new ResourceStatus(77, null, ResourceHandler.Names_cannot_contain_whitespace);
        }
        return OK_STATUS;
    }

    protected IStatus validateFolderName(String folderName) {
        if (folderName == null || folderName.length() == 0) {
            return OK_STATUS;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path path = new Path(folderName);
        int i = 0;
        int max = path.segmentCount();
        while (i < max) {
            IStatus status = workspace.validateName(path.segment(i), 2);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return OK_STATUS;
    }
}

