/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.utils;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAddProperties;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;

public abstract class CopyPropertyTopAbstractSupport {
    private final String m_prefix;
    private final Map<XmlObjectInfo, List<CopyProcessor>> processorsMap = new MapMaker().weakKeys().makeMap();

    protected CopyPropertyTopAbstractSupport(ObjectInfo root, String prefix) {
        this.m_prefix = prefix;
        root.addBroadcastListener((Object)new XmlObjectAddProperties(){

            @Override
            public void invoke(XmlObjectInfo object, List<Property> properties) throws Exception {
                List<CopyProcessor> processors = CopyPropertyTopAbstractSupport.this.processorsMap.get((Object)object);
                if (processors == null) {
                    processors = CopyPropertyTopAbstractSupport.this.createProcessors(object);
                    CopyPropertyTopAbstractSupport.this.processorsMap.put(object, processors);
                }
                for (CopyProcessor processor : processors) {
                    processor.addCopy(object, properties);
                }
            }
        });
    }

    private List<CopyProcessor> createProcessors(XmlObjectInfo object) {
        ArrayList<CopyProcessor> processors = new ArrayList<CopyProcessor>();
        Predicate<XmlObjectInfo> targetPredicate = this.createTargetPredicate(object);
        for (String parameter : object.getDescription().getParameters().keySet()) {
            String[] parts;
            String sourcePath = null;
            String copyTitle = null;
            PropertyCategory category = PropertyCategory.NORMAL;
            if (!parameter.startsWith(this.m_prefix)) continue;
            String[] stringArray = parts = StringUtils.split((String)parameter);
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.startsWith("from=")) {
                    sourcePath = StringUtils.removeStart((String)part, (String)"from=");
                }
                if (part.startsWith("to=")) {
                    copyTitle = StringUtils.removeStart((String)part, (String)"to=");
                }
                if (part.startsWith("category=")) {
                    String categoryText = StringUtils.removeStart((String)part, (String)"category=");
                    category = PropertyCategory.get((String)categoryText, (PropertyCategory)category);
                }
                ++n2;
            }
            if (sourcePath == null || copyTitle == null) continue;
            processors.add(new CopyProcessor(object, targetPredicate, sourcePath, copyTitle, category));
        }
        return processors;
    }

    protected abstract Predicate<XmlObjectInfo> createTargetPredicate(XmlObjectInfo var1);

    static class CopyProcessor {
        private final Predicate<XmlObjectInfo> m_targetPredicate;
        private final String m_sourcePath;
        private final String m_copyTitle;
        private final PropertyCategory m_category;
        private Property m_oldSource;
        private Property m_oldCopy;

        CopyProcessor(XmlObjectInfo hierarchyObject, Predicate<XmlObjectInfo> targetPredicate, String sourcePath, String copyTitle, PropertyCategory category) {
            this.m_targetPredicate = targetPredicate;
            this.m_sourcePath = sourcePath;
            this.m_copyTitle = copyTitle;
            this.m_category = category;
        }

        public void addCopy(XmlObjectInfo object, List<Property> properties) throws Exception {
            Property copy;
            if (this.m_targetPredicate.test(object) && (copy = this.getCopy(properties)) != null) {
                properties.add(copy);
            }
        }

        private Property getCopy(List<Property> properties) throws Exception {
            Property source = PropertyUtils.getByPath(properties, (String)this.m_sourcePath);
            if (this.m_oldSource != source) {
                this.m_oldSource = source;
                this.m_oldCopy = this.createCopy(source);
            }
            return this.m_oldCopy;
        }

        /*
         * WARNING - void declaration
         */
        private Property createCopy(Property source) {
            Property property = source;
            if (property instanceof GenericPropertyImpl) {
                void genericProperty;
                GenericPropertyImpl genericPropertyImpl = (GenericPropertyImpl)property;
                GenericPropertyImpl cfr_ignored_0 = (GenericPropertyImpl)property;
                GenericPropertyImpl copy = new GenericPropertyImpl((GenericPropertyImpl)genericProperty, this.m_copyTitle);
                copy.setCategory(this.m_category);
                return copy;
            }
            return null;
        }
    }
}

