/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property.event;

import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.event.AbstractEventProperty;
import org.eclipse.wb.internal.core.xml.model.property.event.AbstractListenerProperty;
import org.eclipse.wb.internal.core.xml.model.property.event.EventsPropertyEditor;

public final class EventsProperty
extends AbstractEventProperty {
    private final XmlObjectInfo m_object;

    public EventsProperty(XmlObjectInfo object) {
        super(object, "Events", (PropertyEditor)EventsPropertyEditor.INSTANCE);
        this.m_object = object;
        this.setCategory(PropertyCategory.HIDDEN);
        this.installDecoratorListener();
        this.installContextMenuListener();
        this.installDeleteListener();
    }

    private void installDecoratorListener() {
        this.m_object.addBroadcastListener(new ObjectInfoPresentationDecorateIcon(){

            public void invoke(ObjectInfo object, ImageDescriptor[] icon) throws Exception {
                IPreferenceStore preferences;
                if (object == EventsProperty.this.m_object && (preferences = EventsProperty.this.m_object.getDescription().getToolkit().getPreferences()).getBoolean("property.events.decorateIcon") && EventsProperty.this.isModified()) {
                    ImageDescriptor decorator = DesignerPlugin.getImageDescriptor((String)"events/decorator.gif");
                    icon[0] = new DecorationOverlayIcon(icon[0], decorator, 0);
                }
            }
        });
    }

    private void installContextMenuListener() {
        this.m_object.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (object == EventsProperty.this.m_object) {
                    EventsProperty.this.contributeActions(manager, Messages.EventsProperty_addEventHandlerManager);
                }
            }
        });
    }

    private void installDeleteListener() {
        this.m_object.addBroadcastListener(new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                if (child == EventsProperty.this.m_object) {
                    AbstractListenerProperty[] abstractListenerPropertyArray = EventsProperty.this.getSubProperties();
                    int n = abstractListenerPropertyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractListenerProperty listenerProperty = abstractListenerPropertyArray[n2];
                        if (listenerProperty.isModified()) {
                            listenerProperty.removeListener();
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public boolean isModified() throws Exception {
        AbstractListenerProperty[] properties;
        AbstractListenerProperty[] abstractListenerPropertyArray = properties = this.getSubProperties();
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractListenerProperty property = abstractListenerPropertyArray[n2];
            if (property.isModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private AbstractListenerProperty[] getSubProperties() throws Exception {
        return EventsPropertyEditor.INSTANCE.getProperties((Property)this);
    }

    private void contributeActions(IMenuManager manager, String implementTitle) throws Exception {
        AbstractListenerProperty[] listenerProperties;
        MenuManager implementMenuManager = new MenuManager(implementTitle);
        AbstractListenerProperty[] abstractListenerPropertyArray = listenerProperties = this.getSubProperties();
        int n = listenerProperties.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractListenerProperty listenerProperty = abstractListenerPropertyArray[n2];
            listenerProperty.addListenerActions(manager, (IMenuManager)implementMenuManager);
            ++n2;
        }
        manager.appendToGroup("org.eclipse.wb.popup.group.events", (IContributionItem)implementMenuManager);
    }

    public void openListener(String listenerPath) throws Exception {
        String eventListenerPath = "Events/" + listenerPath;
        AbstractListenerProperty property = (AbstractListenerProperty)PropertyUtils.getByPath((ObjectInfo)this.m_object, (String)eventListenerPath);
        if (property != null) {
            property.openListener();
        }
    }
}

