/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public final class StatementTarget {
    private final Block m_block;
    private Statement m_statement;
    private final boolean m_before;

    public StatementTarget(MethodDeclaration method, boolean beginning) {
        this(method.getBody(), beginning);
    }

    public StatementTarget(Block block, boolean beginning) {
        this(block, null, beginning);
    }

    public StatementTarget(Statement statement, boolean before) {
        this(null, statement, before);
    }

    public StatementTarget(ASTNode node, boolean before) {
        this(null, AstNodeUtils.getEnclosingStatement(node), before);
    }

    public StatementTarget(Block block, Statement statement, boolean before) {
        this.m_block = block;
        this.m_statement = statement;
        this.m_before = before;
    }

    public String toString() {
        if (this.m_statement != null) {
            return (this.m_before ? "before " : "after ") + String.valueOf(this.m_statement);
        }
        return (this.m_before ? "begin " : "end ") + String.valueOf(this.m_block);
    }

    public int getPosition() {
        if (this.m_statement != null) {
            return this.m_before ? AstNodeUtils.getSourceBegin((ASTNode)this.m_statement) : AstNodeUtils.getSourceEnd((ASTNode)this.m_statement);
        }
        return this.m_before ? AstNodeUtils.getSourceBegin((ASTNode)this.m_block) : AstNodeUtils.getSourceEnd((ASTNode)this.m_block) - 1;
    }

    public ASTNode getNode() {
        return this.m_statement != null ? this.m_statement : this.m_block;
    }

    public Block getBlock() {
        return this.m_block;
    }

    public Statement getStatement() {
        return this.m_statement;
    }

    public void setStatement(Statement statement) {
        this.m_statement = statement;
    }

    public boolean isBefore() {
        return this.m_before;
    }

    public boolean isAfter() {
        return !this.m_before;
    }
}

