/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.launcher.VMHelper;
import org.osgi.framework.Bundle;

public class LaunchArgumentsHelper {
    private static final Pattern COMMA = Pattern.compile(",");

    public static String getWorkspaceLocation(ILaunchConfiguration configuration) throws CoreException {
        String[] userArgs = LaunchArgumentsHelper.getUserProgramArgumentArray(configuration);
        int i = 0;
        while (i < userArgs.length) {
            if (userArgs[i].equals("-data") && i + 1 < userArgs.length && userArgs[i + 1].equals("@none")) {
                return "";
            }
            ++i;
        }
        String location = configuration.getAttribute("location", null);
        if (location == null && (location = configuration.getAttribute("location0", null)) != null) {
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute("location0", null);
            wc.setAttribute("location", location);
            wc.doSave();
        }
        return LaunchArgumentsHelper.getSubstitutedString(location);
    }

    public static String[] getUserProgramArgumentArray(ILaunchConfiguration configuration) throws CoreException {
        String args = LaunchArgumentsHelper.getUserProgramArguments(configuration);
        return new ExecutionArguments("", args).getProgramArgumentsArray();
    }

    public static String getUserProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        if (args == null && (args = configuration.getAttribute("progargs", null)) != null) {
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute("progargs", null);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            wc.doSave();
        }
        return args == null ? "" : LaunchArgumentsHelper.getSubstitutedString(args);
    }

    public static String getUserVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        if (args == null && (args = configuration.getAttribute("vmargs", null)) != null) {
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute("vmargs", null);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, args);
            wc.doSave();
        }
        return args == null ? "" : LaunchArgumentsHelper.getSubstitutedString(args);
    }

    public static String getInitialVMArguments() {
        Object result = "";
        try {
            ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
            if (service != null) {
                result = service.getWorkspaceTargetDefinition().getVMArguments();
                result = result != null ? result : "";
            }
        }
        catch (CoreException e) {
            PDECore.log((Throwable)e);
        }
        if (LaunchArgumentsHelper.getAddSwtNonDisposalReportingPreference() && ((String)result).indexOf("-Dorg.eclipse.swt.graphics.Resource.reportNonDisposed") == -1) {
            if (((String)result).length() > 0) {
                result = (String)result + " ";
            }
            result = (String)result + "-Dorg.eclipse.swt.graphics.Resource.reportNonDisposed=true";
        }
        return result;
    }

    public static String getInitialProgramArguments() {
        StringBuilder buffer = new StringBuilder("-os ${target.os} -ws ${target.ws} -arch ${target.arch} -nl ${target.nl} -consoleLog");
        try {
            String result;
            ITargetPlatformService service = (ITargetPlatformService)PDECore.getDefault().acquireService(ITargetPlatformService.class);
            if (service != null && (result = service.getWorkspaceTargetDefinition().getProgramArguments()) != null) {
                buffer.append(' ').append(result);
            }
        }
        catch (CoreException e) {
            PDECore.log((Throwable)e);
        }
        return buffer.toString();
    }

    public static File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String working;
        try {
            working = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            working = "${workspace_loc}/../";
        }
        File dir = new File(LaunchArgumentsHelper.getSubstitutedString(working));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static Map<String, Object> getVMSpecificAttributesMap(ILaunchConfiguration config) throws CoreException {
        HashMap<String, Object> map;
        block6: {
            String javaVersion;
            String[] javaVersionSegments;
            IVMInstall vmInstall;
            ModelEntry entry;
            map = new HashMap<String, Object>(2);
            String javaCommand = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, null);
            map.put(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, javaCommand);
            if (TargetPlatform.getOS().equals("macosx") && (entry = PluginRegistry.findEntry((String)"org.eclipse.jdt.debug")) != null && (vmInstall = VMHelper.getVMInstall(config)) instanceof AbstractVMInstall && (javaVersionSegments = (javaVersion = ((AbstractVMInstall)vmInstall).getJavaVersion()).split("\\.")).length >= 2) {
                try {
                    IPluginModelBase[] models;
                    if (Integer.parseInt(javaVersionSegments[0]) != 1 || Integer.parseInt(javaVersionSegments[1]) >= 7) break block6;
                    IPluginModelBase[] iPluginModelBaseArray = models = entry.getExternalModels();
                    int n = models.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPluginModelBase model = iPluginModelBaseArray[n2];
                        File file = new File(model.getInstallLocation());
                        if (!file.isFile()) {
                            file = new File(file, "jdi.jar");
                        }
                        if (file.exists()) {
                            map.put(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND, new String[]{file.getAbsolutePath()});
                            break;
                        }
                        ++n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return map;
    }

    public static String getTracingFileArgument(ILaunchConfiguration config, Path optionsFile) {
        try {
            TracingOptionsManager mng = PDECore.getDefault().getTracingOptionsManager();
            Map options = config.getAttribute("tracingOptions", null);
            String selected = config.getAttribute("checked", null);
            if (selected == null) {
                mng.save(optionsFile, options);
            } else if (!selected.equals("[NONE]")) {
                Set result = LaunchArgumentsHelper.splitElementsByComma(selected).collect(Collectors.toSet());
                mng.save(optionsFile, options, result);
            }
        }
        catch (CoreException coreException) {
            return "";
        }
        return optionsFile.toString();
    }

    public static String[] constructClasspath(ILaunchConfiguration configuration) throws CoreException {
        String jarPath;
        double targetVersion = TargetPlatformHelper.getTargetVersion();
        String string = jarPath = targetVersion >= 3.3 ? LaunchArgumentsHelper.getEquinoxStartupPath("org.eclipse.equinox.launcher") : LaunchArgumentsHelper.getStartupJarPath();
        if (jarPath == null && targetVersion < 3.3) {
            jarPath = LaunchArgumentsHelper.getEquinoxStartupPath("org.eclipse.core.launcher");
        }
        if (jarPath == null) {
            return null;
        }
        String bootstrap = configuration.getAttribute("bootstrap", "");
        Stream<String> bootstrapElements = LaunchArgumentsHelper.splitElementsByComma(LaunchArgumentsHelper.getSubstitutedString(bootstrap));
        return (String[])Stream.concat(Stream.of(jarPath), bootstrapElements).toArray(String[]::new);
    }

    public static Stream<String> splitElementsByComma(String value) {
        return COMMA.splitAsStream(value).map(String::trim);
    }

    private static String getEquinoxStartupPath(String packageName) throws CoreException {
        Bundle bundle;
        IPluginModelBase model = PluginRegistry.findModel((String)"org.eclipse.equinox.launcher");
        if (model != null) {
            IResource resource = model.getUnderlyingResource();
            if (resource == null) {
                File[] files;
                String installLocation = model.getInstallLocation();
                if (installLocation == null) {
                    return null;
                }
                File bundleFile = new File(installLocation);
                if (!bundleFile.isDirectory()) {
                    return installLocation;
                }
                File[] fileArray = files = bundleFile.listFiles((dir, name) -> name.contains("org.eclipse.equinox.launcher"));
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        return file.getPath();
                    }
                    ++n2;
                }
                File binFolder = new File(bundleFile, "bin");
                if (binFolder.isDirectory()) {
                    return binFolder.getPath();
                }
                return null;
            }
            IProject project = resource.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IClasspathEntry[] entries;
                IJavaProject jProject = JavaCore.create((IProject)project);
                IClasspathEntry[] iClasspathEntryArray = entries = jProject.getRawClasspath();
                int n = entries.length;
                int n3 = 0;
                while (n3 < n) {
                    IClasspathEntry entrie = iClasspathEntryArray[n3];
                    int kind = entrie.getEntryKind();
                    if (kind == 3 || kind == 1) {
                        IPackageFragmentRoot[] roots;
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jProject.findPackageFragmentRoots(entrie);
                        int n4 = roots.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            IPackageFragmentRoot root = iPackageFragmentRootArray[n5];
                            if (root.getPackageFragment(packageName).exists()) {
                                if (kind == 3) {
                                    IPath path = entrie.getOutputLocation();
                                    if (path == null) {
                                        path = jProject.getOutputLocation();
                                    }
                                    path = path.removeFirstSegments(1);
                                    return project.getLocation().append(path).toOSString();
                                }
                                IResource jar = root.getResource();
                                if (jar != null) {
                                    return jar.getLocation().toOSString();
                                }
                            }
                            ++n5;
                        }
                    }
                    ++n3;
                }
            }
        }
        if ((bundle = Platform.getBundle((String)"org.eclipse.equinox.launcher")) != null) {
            try {
                URL url = FileLocator.resolve((URL)bundle.getEntry("/"));
                url = FileLocator.toFileURL((URL)url);
                String path = url.getFile();
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if ((path = new File(path).getAbsolutePath()).endsWith("!")) {
                    path = path.substring(0, path.length() - 1);
                }
                return path;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static String getStartupJarPath() throws CoreException {
        File startupJar;
        IPluginModelBase model = PluginRegistry.findModel((String)"org.eclipse.platform");
        if (model != null && model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IPackageFragmentRoot[] roots;
                IJavaProject jProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jProject.getPackageFragmentRoots();
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 && root.getPackageFragment("org.eclipse.core.launcher").exists()) {
                        IPath path = jProject.getOutputLocation().removeFirstSegments(1);
                        return project.getLocation().append(path).toOSString();
                    }
                    ++n2;
                }
            }
            if (project.getFile("startup.jar").exists()) {
                return project.getFile("startup.jar").getLocation().toOSString();
            }
        }
        if (!(startupJar = IPath.fromOSString((String)TargetPlatform.getLocation()).append("startup.jar").toFile()).exists()) {
            startupJar = IPath.fromOSString((String)TargetPlatform.getDefaultLocation()).append("startup.jar").toFile();
        }
        return startupJar.exists() ? startupJar.getAbsolutePath() : null;
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    public static String getDefaultWorkspaceLocation(String uniqueName) {
        return LaunchArgumentsHelper.getDefaultWorkspaceLocation(uniqueName, false);
    }

    public static String getDefaultWorkspaceLocation(String uniqueName, boolean isJUnit) {
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        String location = launchingStore.getString(isJUnit ? "Preferences.MainPage.junitWorkspaceLocation" : "Preferences.MainPage.runtimeWorkspaceLocation");
        if (launchingStore.getBoolean(isJUnit ? "Preferences.MainPage.junitWorkspaceLocationIsContainer" : "Preferences.MainPage.runtimeWorkspaceLocationIsContainer")) {
            return location + uniqueName.replaceAll("\\s", "");
        }
        return location;
    }

    public static boolean getDefaultJUnitWorkspaceIsContainer() {
        PDEPreferencesManager launchingStore = PDELaunchingPlugin.getDefault().getPreferenceManager();
        return launchingStore.getBoolean("Preferences.MainPage.junitWorkspaceLocationIsContainer");
    }

    public static String getDefaultJUnitConfigurationLocation() {
        return "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/pde-junit";
    }

    public static boolean getAddSwtNonDisposalReportingPreference() {
        PDEPreferencesManager prefs = PDECore.getDefault().getPreferencesManager();
        return prefs.getBoolean("Preferences.MainPage.addSwtNonDisposalReporting ");
    }
}

