/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public abstract class AbstractApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private volatile List<IApiTypeContainer> fApiTypeContainers;

    protected AbstractApiTypeContainer(IApiElement parent, int type, String name) {
        super(parent, type, name);
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        IApiTypeContainer[] containers;
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            container.accept(visitor);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CoreException {
        if (this.fApiTypeContainers == null) {
            return;
        }
        MultiStatus multi = null;
        IStatus single = null;
        AbstractApiTypeContainer abstractApiTypeContainer = this;
        synchronized (abstractApiTypeContainer) {
            IApiTypeContainer[] containers;
            if (this.fApiTypeContainers == null) {
                return;
            }
            ApiModelCache.getCache().removeElementInfo(this);
            IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IApiTypeContainer container = iApiTypeContainerArray[n2];
                try {
                    container.close();
                }
                catch (CoreException e) {
                    if (single == null) {
                        single = e.getStatus();
                    }
                    if (multi == null) {
                        multi = new MultiStatus("org.eclipse.pde.api.tools", single.getCode(), single.getMessage(), single.getException());
                    }
                    multi.add(e.getStatus());
                }
                ++n2;
            }
        }
        if (multi != null) {
            throw new CoreException(multi);
        }
        if (single != null) {
            throw new CoreException(single);
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IApiTypeContainer[] containers;
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            IApiTypeRoot file = container.findTypeRoot(qualifiedName);
            if (file != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        String origin = null;
        IApiComponent comp = null;
        IApiTypeContainer[] iApiTypeContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeRoot file;
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            comp = (IApiComponent)container.getAncestor(1);
            if (comp != null && (origin = comp.getSymbolicName()) != null && !origin.equals(id) && comp.isFragment()) {
                IApiComponent rootComp = comp;
                while (rootComp != null && rootComp.isFragment()) {
                    rootComp = rootComp.getHost();
                }
                if (rootComp != null) {
                    origin = rootComp.getSymbolicName();
                }
            }
            if (origin == null ? (file = container.findTypeRoot(qualifiedName)) != null : origin.equals(id) && (file = container.findTypeRoot(qualifiedName, id)) != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        IApiTypeContainer[] containers;
        TreeSet names = new TreeSet();
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            String[] packageNames = container.getPackageNames();
            Collections.addAll(names, packageNames);
            ++n2;
        }
        return (String[])names.toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IApiTypeContainer[] getApiTypeContainers() throws CoreException {
        List<IApiTypeContainer> typeContainers = this.fApiTypeContainers;
        if (typeContainers == null) {
            AbstractApiTypeContainer abstractApiTypeContainer = this;
            synchronized (abstractApiTypeContainer) {
                if (typeContainers == null) {
                    this.fApiTypeContainers = typeContainers = this.createApiTypeContainers();
                }
            }
        }
        return typeContainers.toArray(new IApiTypeContainer[typeContainers.size()]);
    }

    protected IApiTypeContainer[] getApiTypeContainers(String id) throws CoreException {
        IApiTypeContainer[] typeContainers = this.getApiTypeContainers();
        ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
        IApiTypeContainer[] iApiTypeContainerArray = typeContainers;
        int n = typeContainers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            String origin = ((IApiComponent)container.getAncestor(1)).getSymbolicName();
            if (origin != null && origin.equals(id)) {
                containers.add(container);
            }
            ++n2;
        }
        return containers.toArray(new IApiTypeContainer[containers.size()]);
    }

    protected abstract List<IApiTypeContainer> createApiTypeContainers() throws CoreException;

    protected synchronized void setApiTypeContainers(IApiTypeContainer[] containers) {
        if (this.fApiTypeContainers != null) {
            try {
                this.close();
            }
            catch (CoreException coreException) {}
            this.fApiTypeContainers.clear();
        } else {
            this.fApiTypeContainers = new ArrayList<IApiTypeContainer>(containers.length);
        }
        Collections.addAll(this.fApiTypeContainers, containers);
    }

    @Override
    public int getContainerType() {
        return 0;
    }
}

