/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox.access;

import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.passage.lic.equinox.access.Interaction;

public final class ConsoleInteraction
implements Interaction {
    private final int stop = this.stop();

    @Override
    public void prompt(String information) {
        System.out.printf("%s\n", information);
    }

    @Override
    public String input() {
        byte[] bytes = new byte[1024];
        int length = 0;
        try {
            int symbol = System.in.read();
            while (symbol != this.stop) {
                bytes[length++] = (byte)symbol;
                symbol = System.in.read();
            }
        }
        catch (IOException e) {
            this.swear(e);
            return e.getClass().getName();
        }
        return new String(bytes, 0, length);
    }

    @Override
    public void swear(Throwable thro) {
        thro.printStackTrace(System.err);
    }

    private int stop() {
        if (Platform.getOS().equals("win32")) {
            return 13;
        }
        return 10;
    }
}

