/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;

public abstract class BufferProvider
extends Notifier
implements IBufferProvider.Introspection,
IBufferProvider.Notification {
    private short bufferCapacity;
    private long providedBuffers;
    private long retainedBuffers;

    public BufferProvider(short bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    @Override
    public final long getProvidedBuffers() {
        return this.providedBuffers;
    }

    @Override
    public final long getRetainedBuffers() {
        return this.retainedBuffers;
    }

    @Override
    public final short getBufferCapacity() {
        return this.bufferCapacity;
    }

    @Override
    public final IBuffer provideBuffer() {
        IBuffer buffer = this.doProvideBuffer();
        ++this.providedBuffers;
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent(new BufferProviderEvent.Provided(this, buffer), listeners);
        }
        return buffer;
    }

    @Override
    public final void retainBuffer(IBuffer buffer) {
        IListener[] listeners = this.getListeners();
        if (listeners.length != 0) {
            this.fireEvent(new BufferProviderEvent.Retaining(this, buffer), listeners);
        }
        this.doRetainBuffer(buffer);
        ++this.retainedBuffers;
    }

    public String toString() {
        return "BufferProvider[capacity=" + this.bufferCapacity + "]";
    }

    protected abstract IBuffer doProvideBuffer();

    protected abstract void doRetainBuffer(IBuffer var1);

    protected static abstract class BufferProviderEvent
    extends Event {
        private static final long serialVersionUID = 1L;
        private final IBuffer buffer;

        public BufferProviderEvent(IBufferProvider.Notification bufferProvider, IBuffer buffer) {
            super((INotifier)bufferProvider);
            this.buffer = buffer;
        }

        public IBufferProvider.Notification getSource() {
            return (IBufferProvider.Notification)super.getSource();
        }

        public IBuffer getBuffer() {
            return this.buffer;
        }

        protected String formatAdditionalParameters() {
            return "buffer=" + this.buffer;
        }

        private static final class Provided
        extends BufferProviderEvent
        implements IBufferProvider.Notification.BufferProvidedEvent {
            private static final long serialVersionUID = 1L;

            public Provided(IBufferProvider.Notification bufferProvider, IBuffer buffer) {
                super(bufferProvider, buffer);
            }

            protected String formatEventName() {
                return "BufferProvidedEvent";
            }
        }

        private static final class Retaining
        extends BufferProviderEvent
        implements IBufferProvider.Notification.BufferRetainingEvent {
            private static final long serialVersionUID = 1L;

            public Retaining(IBufferProvider.Notification bufferProvider, IBuffer buffer) {
                super(bufferProvider, buffer);
            }

            protected String formatEventName() {
                return "BufferRetainingEvent";
            }
        }
    }
}

