/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.util.Map;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection4;
import org.eclipse.linuxtools.docker.core.IDockerProgressHandler;
import org.eclipse.osgi.util.NLS;

public class ContainerLaunchUtils {
    private static final String LATEST = ":latest";

    public static final String toDockerPath(IPath path) {
        String pathstring = path.toPortableString();
        if (path.getDevice() != null && pathstring.charAt(0) != '/') {
            pathstring = String.valueOf('/') + pathstring;
        }
        return ContainerLaunchUtils.toDockerPath(pathstring);
    }

    public static final String toDockerPath(String path) {
        if (Platform.getOS().equals("win32")) {
            path = path.replace(':', '/');
            path = path.replace("//WSL$/", "/WSL/");
        }
        return path;
    }

    public static final String toDockerVolume(Map<String, String> pMap, IPath path) {
        String dhPath = path.makeAbsolute().toString();
        for (Map.Entry<String, String> me : pMap.entrySet()) {
            String elp = me.getKey();
            String edhp = me.getValue();
            if (!dhPath.startsWith(elp)) continue;
            dhPath = String.valueOf(edhp) + dhPath.substring(elp.length());
            break;
        }
        String rv = ContainerLaunchUtils.toDockerPath(path.makeAbsolute());
        rv = String.valueOf(rv) + ":HOST_FILE_SYSTEM:";
        rv = String.valueOf(rv) + dhPath;
        rv = String.valueOf(rv) + ":false:true";
        return rv;
    }

    public static @NonNull IStatus provideDockerImage(IProgressMonitor monitor, @NonNull String connectionName, @NonNull String imageName) {
        IDockerConnection4 connection = (IDockerConnection4)DockerConnectionManager.getInstance().getConnectionByName(connectionName);
        if (connection == null) {
            return new Status(4, "org.eclipse.cdt.docker.launcher", NLS.bind((String)Messages.ContainerCommandLauncher_pullerr_noConn, (Object)imageName, (Object)connectionName));
        }
        if (imageName.lastIndexOf(58) <= imageName.lastIndexOf(47)) {
            imageName = String.valueOf(imageName) + LATEST;
        }
        if (connection.getImageInfo(imageName) != null) {
            return Status.OK_STATUS;
        }
        try {
            IDockerProgressHandler prghandler = connection.getDefaultPullImageProgressHandler(imageName, monitor);
            connection.pullImage(imageName, prghandler);
            return Status.OK_STATUS;
        }
        catch (DockerException e) {
            Throwable causeE = e.getCause();
            Status rv = causeE != null && causeE.getClass().getName().startsWith("org.mandas.docker.client.exceptions") ? new Status(4, "org.eclipse.cdt.docker.launcher", String.valueOf(causeE.getMessage()) + " (" + connectionName + ')') : new Status(4, "org.eclipse.cdt.docker.launcher", NLS.bind((String)Messages.ContainerCommandLauncher_pullerr, (Object)imageName, (Object)e.getMessage()));
            ManagedBuilderCorePlugin.log((IStatus)rv);
            return rv;
        }
        catch (InterruptedException e) {
            return new Status(8, "org.eclipse.cdt.docker.launcher", Messages.ContainerCommandLauncher_pullint);
        }
    }
}

