/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleValueProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Sets;
import org.eclipse.viatra.query.runtime.rete.eval.IEvaluatorNode;

public abstract class EvaluatorCore {
    protected Logger logger;
    protected IExpressionEvaluator evaluator;
    protected int sourceTupleWidth;
    private Map<String, Integer> parameterPositions;
    protected IQueryRuntimeContext runtimeContext;
    protected IEvaluatorNode evaluatorNode;

    public EvaluatorCore(Logger logger, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
        this.logger = logger;
        this.evaluator = evaluator;
        this.parameterPositions = parameterPositions;
        this.sourceTupleWidth = sourceTupleWidth;
    }

    public void init(IEvaluatorNode evaluatorNode) {
        this.evaluatorNode = evaluatorNode;
        this.runtimeContext = evaluatorNode.getReteContainer().getNetwork().getEngine().getRuntimeContext();
    }

    public abstract Iterable<Tuple> performEvaluation(Tuple var1);

    protected abstract String evaluationKind();

    public Object evaluateTerm(Tuple input) {
        Object result = null;
        try {
            TupleValueProvider tupleParameters = new TupleValueProvider((ITuple)this.runtimeContext.unwrapTuple(input), this.parameterPositions);
            result = this.evaluator.evaluateExpression((IValueProvider)tupleParameters);
        }
        catch (Exception e) {
            this.logger.warn((Object)String.format("The incremental pattern matcher encountered an error during %s evaluation for pattern(s) %s over values %s. Error message: %s. (Developer note: %s in %s)", this.evaluationKind(), this.evaluatorNode.prettyPrintTraceInfoPatternList(), this.prettyPrintTuple(input), e.getMessage(), e.getClass().getSimpleName(), this.evaluatorNode), (Throwable)e);
            result = this.errorResult();
        }
        return result;
    }

    protected String prettyPrintTuple(Tuple tuple) {
        return tuple.toString();
    }

    protected Object errorResult() {
        return null;
    }

    public static class FunctionEvaluatorCore
    extends EvaluatorCore {
        protected final boolean isUnwinding;

        public FunctionEvaluatorCore(Logger logger, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
            this(logger, evaluator, parameterPositions, sourceTupleWidth, false);
        }

        public FunctionEvaluatorCore(Logger logger, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth, boolean isUnwinding) {
            super(logger, evaluator, parameterPositions, sourceTupleWidth);
            this.isUnwinding = isUnwinding;
        }

        @Override
        public Iterable<Tuple> performEvaluation(final Tuple input) {
            Object result = this.evaluateTerm(input);
            if (result != null) {
                if (this.isUnwinding) {
                    Set resultAsSet;
                    Set set = result instanceof Set ? (Set)result : (resultAsSet = result instanceof Iterable ? Sets.newSet((Iterable)((Iterable)result)) : null);
                    if (resultAsSet != null) {
                        return () -> {
                            final Iterator wrapped = resultAsSet.iterator();
                            return new Iterator<Tuple>(){

                                @Override
                                public boolean hasNext() {
                                    return wrapped.hasNext();
                                }

                                @Override
                                public Tuple next() {
                                    Object next = wrapped.next();
                                    return Tuples.staticArityLeftInheritanceTupleOf((Tuple)input, (Object)runtimeContext.wrapElement(next));
                                }
                            };
                        };
                    }
                    throw new IllegalStateException("This is an unwinding evaluator, which expects the evaluation result to either be a set or an iterable, but it was " + result);
                }
                return Collections.singleton(Tuples.staticArityLeftInheritanceTupleOf((Tuple)input, (Object)this.runtimeContext.wrapElement(result)));
            }
            return null;
        }

        @Override
        protected String evaluationKind() {
            return "eval" + (this.isUnwinding ? "Unwind" : "") + "()";
        }
    }

    public static class PredicateEvaluatorCore
    extends EvaluatorCore {
        public PredicateEvaluatorCore(Logger logger, IExpressionEvaluator evaluator, Map<String, Integer> parameterPositions, int sourceTupleWidth) {
            super(logger, evaluator, parameterPositions, sourceTupleWidth);
        }

        @Override
        public Iterable<Tuple> performEvaluation(Tuple input) {
            Object result = this.evaluateTerm(input);
            if (Boolean.TRUE.equals(result)) {
                return Collections.singleton(input);
            }
            return null;
        }

        @Override
        protected String evaluationKind() {
            return "check()";
        }
    }
}

