/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.internal.ui.IJobManager;
import org.eclipse.ptp.internal.ui.PTPUIDebugOptions;
import org.eclipse.ptp.internal.ui.PTPUIPlugin;
import org.eclipse.ptp.internal.ui.actions.ParallelAction;
import org.eclipse.ptp.internal.ui.actions.RemoveAllTerminatedAction;
import org.eclipse.ptp.internal.ui.listeners.IJobChangedListener;
import org.eclipse.ptp.internal.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.AbstractParallelSetView;
import org.eclipse.ptp.internal.ui.views.IToolTipProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.WorkbenchJob;

public class ParallelJobsView
extends AbstractParallelSetView
implements ISelectionProvider {
    private ISelection selection = null;
    private final ListenerList listeners = new ListenerList();
    protected String cur_selected_element_id = "";
    protected Menu jobPopupMenu = null;
    protected SashForm sashForm = null;
    protected TableViewer jobTableViewer = null;
    protected Composite elementViewComposite = null;
    protected JobViewUpdateWorkbenchJob jobViewUpdateJob = new JobViewUpdateWorkbenchJob();
    private final IJobChangedListener fJobListener = new JobListener();
    protected ParallelAction terminateAllAction = null;

    public ParallelJobsView() {
        this(PTPUIPlugin.getDefault().getJobManager());
    }

    public ParallelJobsView(IJobManager manager) {
        super(manager);
        manager.addJobChangedListener(this.fJobListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void changeJobRefresh(IJobStatus job) {
        this.changeJobRefresh(job, false);
    }

    public void changeJobRefresh(IJobStatus job, boolean force) {
        IJobStatus cur_job = this.getJobManager().getJob();
        StructuredSelection selection = null;
        if (cur_job == null && job != null) {
            this.doChangeJob(job);
            selection = new StructuredSelection((Object)job);
        } else if (cur_job != null && job == null) {
            this.doChangeJob((IJobStatus)null);
            selection = new StructuredSelection();
        } else if (cur_job != null && job != null) {
            if (!cur_job.getJobId().equals(job.getJobId())) {
                this.doChangeJob(job);
            }
            selection = new StructuredSelection((Object)job);
        } else {
            selection = new StructuredSelection();
        }
        this.jobViewUpdateJob.schedule((ISelection)selection, force);
    }

    @Override
    public void dispose() {
        this.getJobManager().removeJobChangedListener(this.fJobListener);
        this.elementViewComposite.dispose();
        super.dispose();
    }

    public void doChangeJob(final IJobStatus job) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ParallelJobsView.this.selectJob(job);
                ParallelJobsView.this.update();
            }
        });
    }

    public void doChangeJob(String job_id) {
        this.doChangeJob(((IJobManager)this.manager).findJobById(job_id));
    }

    @Override
    public void doubleClick(int element) {
    }

    @Override
    public synchronized String getCurrentID() {
        IJobStatus job = this.getJobManager().getJob();
        if (job != null) {
            return job.getJobId();
        }
        return "";
    }

    @Override
    public ISelection getSelection() {
        if (this.selection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    @Override
    public String[] getToolTipText(int element) {
        IElementHandler setManager = this.getCurrentElementHandler();
        if (setManager == null || this.cur_element_set == null || !this.cur_element_set.contains(element)) {
            return IToolTipProvider.NO_TOOLTIP;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(Messages.ParallelJobsView_1) + element);
        buffer.append(Messages.ParallelJobsView_2);
        IElementSet[] sets = setManager.getSetsContaining(element);
        if (sets.length > 1) {
            buffer.append(Messages.ParallelJobsView_4);
        }
        int i = 0;
        int c = 0;
        while (i < sets.length) {
            String id = sets[i].getID();
            if (!id.equals("Root")) {
                buffer.append(sets[i].getID());
                if (c++ < sets.length - 2) {
                    buffer.append(",");
                }
            }
            ++i;
        }
        return new String[]{buffer.toString()};
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void repaint(boolean all) {
        if (all && !this.jobTableViewer.getTable().isDisposed()) {
            this.jobTableViewer.refresh(true);
        }
        this.update();
        this.refresh(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        this.setSelection(this.selection);
    }

    @Override
    public void setFocus() {
        super.setFocus();
        if (this.getJobManager().getJob() == null) {
            this.changeJobRefresh(null);
        }
    }

    public void setSelection(ISelection selection) {
        Object[] array;
        final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = array = this.listeners.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)element;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(e);
                }
            });
            ++n2;
        }
    }

    @Override
    public void updateAction() {
        super.updateAction();
        if (this.terminateAllAction != null) {
            ISelection selection = this.jobTableViewer.getSelection();
            if (selection.isEmpty()) {
                this.terminateAllAction.setEnabled(false);
            } else {
                IJobStatus job = (IJobStatus)((IStructuredSelection)selection).getFirstElement();
                this.terminateAllAction.setEnabled(!job.getLaunchMode().equals("debug") && !job.getState().equals("COMPLETED"));
            }
        }
    }

    public void updateJobSet() {
        IElementHandler setManager = this.getCurrentElementHandler();
        this.selectSet(setManager == null ? null : setManager.getSet("Root"));
    }

    protected void createJobContextMenu() {
        MenuManager menuMgr = new MenuManager("#jobpopupmenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("actiongroup"));
                manager.add((IContributionItem)new Separator("emptygroup"));
                ParallelJobsView.this.fillJobContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.jobTableViewer.getTable());
        this.jobTableViewer.getTable().setMenu(menu);
    }

    @Override
    protected void createToolBarActions(IToolBarManager toolBarMgr) {
        super.buildInToolBarActions(toolBarMgr);
    }

    @Override
    protected void createView(Composite parent) {
        parent.setLayout((Layout)new FillLayout(512));
        parent.setLayoutData((Object)new GridData(1808));
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new FillLayout(512));
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.jobTableViewer = new TableViewer((Composite)this.sashForm, 2052);
        this.jobTableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.jobTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.jobTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IJobManager) {
                    return ((IJobManager)inputElement).getJobs();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.jobTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object j1, Object j2) {
                return ((IJobStatus)j1).getJobId().compareTo(((IJobStatus)j2).getJobId());
            }
        });
        this.jobTableViewer.setInput((Object)this.manager);
        this.jobTableViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ISelection selection = ParallelJobsView.this.jobTableViewer.getSelection();
                TableItem item = ParallelJobsView.this.jobTableViewer.getTable().getItem(new Point(e.x, e.y));
                if (item == null && !selection.isEmpty()) {
                    ParallelJobsView.this.jobTableViewer.getTable().deselectAll();
                    ParallelJobsView.this.doChangeJob((IJobStatus)null);
                } else if (item != null) {
                    IJobStatus job = (IJobStatus)item.getData();
                    if (job == null) {
                        ParallelJobsView.this.doChangeJob((IJobStatus)null);
                    } else if (selection.isEmpty()) {
                        ParallelJobsView.this.doChangeJob(job);
                    } else {
                        String cur_id = ParallelJobsView.this.getCurrentID();
                        if (cur_id == null || !cur_id.equals(job.getJobId())) {
                            ParallelJobsView.this.doChangeJob(job);
                        }
                    }
                    ParallelJobsView.this.update();
                }
            }
        });
        this.jobTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.createJobContextMenu();
        this.elementViewComposite = this.createElementView((Composite)this.sashForm);
        this.jobTableViewer.getTable().setVisible(true);
        this.elementViewComposite.setVisible(true);
        this.sashForm.setWeights(new int[]{1, 2});
    }

    protected void fillJobContextMenu(IMenuManager menuManager) {
        RemoveAllTerminatedAction removeAllTerminatedAction = new RemoveAllTerminatedAction(this);
        removeAllTerminatedAction.setEnabled(this.getJobManager().hasStoppedJob());
        menuManager.add((IAction)removeAllTerminatedAction);
    }

    protected IJobManager getJobManager() {
        return (IJobManager)this.manager;
    }

    @Override
    protected void initialElement() {
        this.changeJobRefresh(null, true);
    }

    @Override
    protected void initialView() {
        this.initialElement();
    }

    protected void refreshJobView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!ParallelJobsView.this.jobTableViewer.getTable().isDisposed()) {
                    ParallelJobsView.this.jobTableViewer.refresh(true);
                }
            }
        });
    }

    protected void selectJob(IJobStatus job) {
        this.getJobManager().setJob(job);
        this.updateJobSet();
    }

    private class JobListener
    implements IJobChangedListener {
        private JobListener() {
        }

        @Override
        public void jobChangedEvent(int type, String cur_job_id, String pre_job_id) {
            if (type == 1 && cur_job_id == null) {
                ParallelJobsView.this.changeJobRefresh(null);
            }
        }
    }

    private class JobViewUpdateWorkbenchJob
    extends WorkbenchJob {
        private final ReentrantLock waitLock;
        private final List<ISelection> refreshJobList;

        public JobViewUpdateWorkbenchJob() {
            super(Messages.ParallelJobsView_0);
            this.waitLock = new ReentrantLock();
            this.refreshJobList = new ArrayList<ISelection>();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.size() == 0) {
                return Status.CANCEL_STATUS;
            }
            ISelection selection = this.getLastJobSelection();
            PTPUIDebugOptions.trace("/debug/views/jobs/tracing", "============= JobViewUpdateWorkbenchJob refresh: " + selection, new String[0]);
            if (!ParallelJobsView.this.jobTableViewer.getTable().isDisposed()) {
                ParallelJobsView.this.jobTableViewer.setSelection(selection, true);
                ParallelJobsView.this.jobTableViewer.refresh(true);
            }
            ISelection lastSelection = this.getLastJobSelection();
            this.waitLock.lock();
            try {
                this.refreshJobList.clear();
                if (!selection.equals(lastSelection)) {
                    this.refreshJobList.add(lastSelection);
                    this.schedule();
                }
            }
            finally {
                this.waitLock.unlock();
            }
            return Status.OK_STATUS;
        }

        public void schedule(ISelection selection, boolean force) {
            this.waitLock.lock();
            try {
                if (force) {
                    this.refreshJobList.clear();
                }
                if (!this.refreshJobList.contains(selection)) {
                    this.refreshJobList.add(selection);
                }
            }
            finally {
                this.waitLock.unlock();
            }
            this.schedule();
        }

        public boolean shouldSchedule() {
            int size = this.size();
            PTPUIDebugOptions.trace("/debug/views/jobs/tracing", "============= JobViewUpdateWorkbenchJob: " + this.refreshJobList.size(), new String[0]);
            return size == 1;
        }

        private ISelection getLastJobSelection() {
            this.waitLock.lock();
            try {
                ISelection iSelection = this.refreshJobList.get(this.refreshJobList.size() - 1);
                return iSelection;
            }
            finally {
                this.waitLock.unlock();
            }
        }

        private int size() {
            this.waitLock.lock();
            try {
                int n = this.refreshJobList.size();
                return n;
            }
            finally {
                this.waitLock.unlock();
            }
        }
    }
}

