/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.common.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SuperListIterableWrapper;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiableCollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.NamedNativeQuery;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.QueryContainer;
import org.eclipse.jpt.jpa.core.jpa2_1.context.QueryContainer2_1;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.AddQueryDialog;
import org.eclipse.jpt.jpa.ui.internal.details.NamedNativeQueryPropertyComposite;
import org.eclipse.jpt.jpa.ui.internal.details.NamedQueryPropertyComposite;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public class QueriesComposite
extends Pane<QueryContainer> {
    Pane<? extends NamedNativeQuery> namedNativeQueryPane;
    Pane<? extends NamedQuery> namedQueryPane;
    private ModifiableCollectionValueModel<Query> selectedQueriesModel;
    private PropertyValueModel<Query> selectedQueryModel;

    public QueriesComposite(Pane<?> parentPane, PropertyValueModel<? extends QueryContainer> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initialize() {
        super.initialize();
        this.selectedQueriesModel = this.buildSelectedQueriesModel();
        this.selectedQueryModel = this.buildSelectedQueryModel((CollectionValueModel<Query>)this.selectedQueriesModel);
    }

    private ModifiableCollectionValueModel<Query> buildSelectedQueriesModel() {
        return new SimpleCollectionValueModel();
    }

    private PropertyValueModel<Query> buildSelectedQueryModel(CollectionValueModel<Query> selectedQueriesModel) {
        return new CollectionPropertyValueModelAdapter<Query, Query>(selectedQueriesModel){

            protected Query buildValue() {
                if (this.collectionModel.size() == 1) {
                    return (Query)this.collectionModel.iterator().next();
                }
                return null;
            }
        };
    }

    protected PropertyValueModel<Query> getSelectedQueryModel() {
        return this.selectedQueryModel;
    }

    protected void initializeLayout(Composite container) {
        this.addListPane(container);
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.installPaneSwitcher(pageBook);
    }

    private AddRemoveListPane<QueryContainer, Query> addListPane(Composite container) {
        return new AddRemoveListPane((Pane)this, container, this.buildQueriesAdapter(), this.buildDisplayableQueriesListHolder(), this.selectedQueriesModel, this.buildQueriesListLabelProvider(), JpaHelpContextIds.MAPPING_NAMED_QUERIES);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        SWTBindingTools.bind(this.getSelectedQueryModel(), this.buildPaneTransformer(pageBook), (PageBook)pageBook);
    }

    protected Query addQuery() {
        return this.addQueryFromDialog(this.buildAddQueryDialog());
    }

    protected AddQueryDialog buildAddQueryDialog() {
        return new AddQueryDialog(this.getShell(), this.getResourceManager(), ((QueryContainer)this.getSubject()).getPersistenceUnit());
    }

    protected Query addQueryFromDialog(AddQueryDialog dialog) {
        NamedQuery query;
        if (dialog.open() != 0) {
            return null;
        }
        String queryType = dialog.getQueryType();
        if (queryType == "namedQuery") {
            query = ((QueryContainer)this.getSubject()).addNamedQuery();
        } else if (queryType == "namedNativeQuery") {
            query = ((QueryContainer)this.getSubject()).addNamedNativeQuery();
        } else if (queryType == "namedNativeQuery") {
            query = ((QueryContainer2_1)this.getSubject()).addNamedStoredProcedureQuery();
        } else {
            throw new IllegalArgumentException();
        }
        query.setName(dialog.getName());
        return query;
    }

    private ListValueModel<Query> buildDisplayableQueriesListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildQueriesListHolder(), new String[]{"name"});
    }

    protected ListValueModel<NamedNativeQuery> buildNamedNativeQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, NamedNativeQuery>(this.getSubjectHolder(), new String[]{"namedNativeQueries"}){

            protected ListIterable<NamedNativeQuery> getListIterable() {
                return new SuperListIterableWrapper(((QueryContainer)this.subject).getNamedNativeQueries());
            }

            protected int size_() {
                return ((QueryContainer)this.subject).getNamedNativeQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedNativeQuery> buildSelectedNamedNativeQueryModel() {
        return new TransformationPropertyValueModel<Query, NamedNativeQuery>(this.getSelectedQueryModel()){

            protected NamedNativeQuery transform_(Query value) {
                return value instanceof NamedNativeQuery ? (NamedNativeQuery)value : null;
            }
        };
    }

    protected ListValueModel<NamedQuery> buildNamedQueriesListHolder() {
        return new ListAspectAdapter<QueryContainer, NamedQuery>(this.getSubjectHolder(), new String[]{"namedQueries"}){

            protected ListIterable<NamedQuery> getListIterable() {
                return new SuperListIterableWrapper(((QueryContainer)this.subject).getNamedQueries());
            }

            protected int size_() {
                return ((QueryContainer)this.subject).getNamedQueriesSize();
            }
        };
    }

    private PropertyValueModel<NamedQuery> buildSelectedNamedQueryModel() {
        return new TransformationPropertyValueModel<Query, NamedQuery>(this.getSelectedQueryModel()){

            protected NamedQuery transform_(Query value) {
                return value instanceof NamedQuery ? (NamedQuery)value : null;
            }
        };
    }

    protected Transformer<Query, Control> buildPaneTransformer(PageBook pageBook) {
        return new PaneTransformer(pageBook);
    }

    protected AddRemovePane.Adapter<Query> buildQueriesAdapter() {
        return new AddRemovePane.AbstractAdapter<Query>(){

            public Query addNewItem() {
                return QueriesComposite.this.addQuery();
            }

            public PropertyValueModel<Boolean> buildRemoveButtonEnabledModel(CollectionValueModel<Query> selectedItemsModel) {
                return this.buildSingleSelectedItemEnabledModel(selectedItemsModel);
            }

            public void removeSelectedItems(CollectionValueModel<Query> selectedItemsModel) {
                Query item = (Query)selectedItemsModel.iterator().next();
                if (item instanceof NamedQuery) {
                    ((QueryContainer)QueriesComposite.this.getSubject()).removeNamedQuery((NamedQuery)item);
                } else {
                    ((QueryContainer)QueriesComposite.this.getSubject()).removeNamedNativeQuery((NamedNativeQuery)item);
                }
            }
        };
    }

    protected ListValueModel<Query> buildQueriesListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildNamedQueriesListHolder());
        list.add(this.buildNamedNativeQueriesListHolder());
        return CompositeListValueModel.forModels(list);
    }

    protected ILabelProvider buildQueriesListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Query query = (Query)element;
                String name = query.getName();
                if (name == null) {
                    int index = -1;
                    index = query instanceof NamedQuery ? IterableTools.indexOf((Iterable)((QueryContainer)QueriesComposite.this.getSubject()).getNamedQueries(), (Object)query) : IterableTools.indexOf((Iterable)((QueryContainer)QueriesComposite.this.getSubject()).getNamedNativeQueries(), (Object)query);
                    name = NLS.bind((String)JptJpaUiDetailsMessages.QUERIES_COMPOSITE_DISPLAY_STRING, (Object)index);
                }
                return name;
            }
        };
    }

    public Pane<? extends NamedQuery> getNamedQueryPropertyComposite(PageBook pageBook) {
        if (this.namedQueryPane == null) {
            this.namedQueryPane = this.buildNamedQueryPropertyComposite(pageBook);
        }
        return this.namedQueryPane;
    }

    protected Pane<? extends NamedQuery> buildNamedQueryPropertyComposite(PageBook pageBook) {
        return new NamedQueryPropertyComposite<NamedQuery>(this, this.buildSelectedNamedQueryModel(), (Composite)pageBook);
    }

    public Pane<? extends NamedNativeQuery> getNamedNativeQueryPropertyComposite(PageBook pageBook) {
        if (this.namedNativeQueryPane == null) {
            this.namedNativeQueryPane = this.buildNamedNativeQueryPropertyComposite(pageBook);
        }
        return this.namedNativeQueryPane;
    }

    public Pane<? extends NamedNativeQuery> buildNamedNativeQueryPropertyComposite(PageBook pageBook) {
        return new NamedNativeQueryPropertyComposite(this, this.buildSelectedNamedNativeQueryModel(), (Composite)pageBook);
    }

    protected class PaneTransformer
    extends AbstractTransformer<Query, Control> {
        private final PageBook pageBook;

        protected PaneTransformer(PageBook pageBook) {
            this.pageBook = pageBook;
        }

        public Control transform_(Query query) {
            if (query instanceof NamedNativeQuery) {
                return QueriesComposite.this.getNamedNativeQueryPropertyComposite(this.pageBook).getControl();
            }
            return QueriesComposite.this.getNamedQueryPropertyComposite(this.pageBook).getControl();
        }
    }
}

