/*
 * generated by Xtext 2.26.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.color.ColorPackage;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.services.DotColorGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotColorSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotColorGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == ColorPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ColorPackage.HSV_COLOR:
				sequence_HSVColor(context, (HSVColor) semanticObject); 
				return; 
			case ColorPackage.RGB_COLOR:
				sequence_RGBColor(context, (RGBColor) semanticObject); 
				return; 
			case ColorPackage.STRING_COLOR:
				sequence_StringColor(context, (StringColor) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     Color returns HSVColor
	 *     HSVColor returns HSVColor
	 *
	 * Constraint:
	 *     (h=COLOR_NUMBER s=COLOR_NUMBER v=COLOR_NUMBER)
	 * </pre>
	 */
	protected void sequence_HSVColor(ISerializationContext context, HSVColor semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, ColorPackage.Literals.HSV_COLOR__H) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ColorPackage.Literals.HSV_COLOR__H));
			if (transientValues.isValueTransient(semanticObject, ColorPackage.Literals.HSV_COLOR__S) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ColorPackage.Literals.HSV_COLOR__S));
			if (transientValues.isValueTransient(semanticObject, ColorPackage.Literals.HSV_COLOR__V) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ColorPackage.Literals.HSV_COLOR__V));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getHSVColorAccess().getHCOLOR_NUMBERTerminalRuleCall_0_0(), semanticObject.getH());
		feeder.accept(grammarAccess.getHSVColorAccess().getSCOLOR_NUMBERTerminalRuleCall_2_0(), semanticObject.getS());
		feeder.accept(grammarAccess.getHSVColorAccess().getVCOLOR_NUMBERTerminalRuleCall_4_0(), semanticObject.getV());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Color returns RGBColor
	 *     RGBColor returns RGBColor
	 *
	 * Constraint:
	 *     (r=hex g=hex b=hex a=hex?)
	 * </pre>
	 */
	protected void sequence_RGBColor(ISerializationContext context, RGBColor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     Color returns StringColor
	 *     StringColor returns StringColor
	 *
	 * Constraint:
	 *     (scheme=COLOR_STRING? (name=HEXADECIMAL_DIGIT | name=COLOR_STRING | name=COLOR_NUMBER))
	 * </pre>
	 */
	protected void sequence_StringColor(ISerializationContext context, StringColor semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
