/**
 */
package org.eclipse.gef.dot.internal.language.fontname.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.gef.dot.internal.language.fontname.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.gef.dot.internal.language.fontname.FontnamePackage
 * @generated
 */
public class FontnameSwitch<T> extends Switch<T>
{
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static FontnamePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FontnameSwitch()
	{
		if (modelPackage == null)
		{
			modelPackage = FontnamePackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage)
	{
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject)
	{
		switch (classifierID)
		{
			case FontnamePackage.FONT_NAME:
			{
				FontName fontName = (FontName)theEObject;
				T result = caseFontName(fontName);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.POST_SCRIPT_FONT_NAME:
			{
				PostScriptFontName postScriptFontName = (PostScriptFontName)theEObject;
				T result = casePostScriptFontName(postScriptFontName);
				if (result == null) result = caseFontName(postScriptFontName);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.PANGO_FONT_NAME:
			{
				PangoFontName pangoFontName = (PangoFontName)theEObject;
				T result = casePangoFontName(pangoFontName);
				if (result == null) result = caseFontName(pangoFontName);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.STYLE_OPTIONS_ELEMENT:
			{
				StyleOptionsElement styleOptionsElement = (StyleOptionsElement)theEObject;
				T result = caseStyleOptionsElement(styleOptionsElement);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.STYLE_OPTION:
			{
				StyleOption styleOption = (StyleOption)theEObject;
				T result = caseStyleOption(styleOption);
				if (result == null) result = caseStyleOptionsElement(styleOption);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.VARIANT_OPTION:
			{
				VariantOption variantOption = (VariantOption)theEObject;
				T result = caseVariantOption(variantOption);
				if (result == null) result = caseStyleOptionsElement(variantOption);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.WEIGHT_OPTION:
			{
				WeightOption weightOption = (WeightOption)theEObject;
				T result = caseWeightOption(weightOption);
				if (result == null) result = caseStyleOptionsElement(weightOption);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.STRETCH_OPTION:
			{
				StretchOption stretchOption = (StretchOption)theEObject;
				T result = caseStretchOption(stretchOption);
				if (result == null) result = caseStyleOptionsElement(stretchOption);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case FontnamePackage.GRAVITY_OPTION:
			{
				GravityOption gravityOption = (GravityOption)theEObject;
				T result = caseGravityOption(gravityOption);
				if (result == null) result = caseStyleOptionsElement(gravityOption);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Font Name</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Font Name</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFontName(FontName object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Post Script Font Name</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Post Script Font Name</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePostScriptFontName(PostScriptFontName object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Pango Font Name</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Pango Font Name</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePangoFontName(PangoFontName object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Style Options Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Style Options Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStyleOptionsElement(StyleOptionsElement object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Style Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Style Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStyleOption(StyleOption object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Variant Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Variant Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseVariantOption(VariantOption object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Weight Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Weight Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseWeightOption(WeightOption object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Stretch Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Stretch Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStretchOption(StretchOption object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gravity Option</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gravity Option</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGravityOption(GravityOption object)
	{
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object)
	{
		return null;
	}

} //FontnameSwitch
