/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AdHocOrdering implements Enumerator
{
    PARALLEL(0, "Parallel", "Parallel"),
    SEQUENTIAL(1, "Sequential", "Sequential");

    public static final int PARALLEL_VALUE = 0;
    public static final int SEQUENTIAL_VALUE = 1;
    private static final AdHocOrdering[] VALUES_ARRAY;
    public static final List<AdHocOrdering> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AdHocOrdering[]{PARALLEL, SEQUENTIAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AdHocOrdering get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AdHocOrdering result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AdHocOrdering getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AdHocOrdering result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AdHocOrdering get(int value) {
        switch (value) {
            case 0: {
                return PARALLEL;
            }
            case 1: {
                return SEQUENTIAL;
            }
        }
        return null;
    }

    private AdHocOrdering(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

