/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class NodeRunDAPDebugDelegate
extends DSPLaunchDelegate {
    public static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.nodeDebug";
    public static final String ARGUMENTS = "args";
    private static final String CWD = "cwd";
    private static final String ENV = "env";
    private static final String RUNTIME_EXECUTABLE = "runtimeExecutable";
    public static final String NODE_DEBUG_CMD = "/node_modules/node-debug2/out/src/nodeDebug.js";
    public static final String TYPESCRIPT_CONTENT_TYPE = "org.eclipse.wildwebdeveloper.ts";
    public static final String JAVACRIPT_CONTENT_TYPE = "org.eclipse.wildwebdeveloper.js";
    public static final String JAVACRIPT_DEBUGGABLE_PATTERNS = "__debuggablePatterns";
    public static final String JAVACRIPT_DEBUGGABLE_PATTERNS_DEFAULT = "[\"*.js\",\"*.es6\",\"*.jsx\",\"*.mjs\".\"*.cjs\"]";
    private static final String TS_CONFIG_NAME = "tsconfig.json";
    private static final String COMPILER_OPTIONS = "compilerOptions";
    private static final String SOURCE_MAP = "sourceMap";
    private static final String SOURCE_MAPS = "sourceMaps";
    private static final String MODULE = "module";
    private static final String MODULE_AMD = "amd";
    private static final String MODULE_SYSTEM = "system";
    private static final String OUT_DIR = "outDir";
    private static final String OUT_FILE = "outFile";
    private static final String ROOT_DIR = "rootDir";
    private static final Pattern BlockCommentPattern = Pattern.compile("(?<!//.*)/\\*(?:.|\\R)*?\\*/");
    private static final Pattern LineCommentPattern = Pattern.compile("\\s*//.*");
    private static final Pattern TrailingCommaPattern = Pattern.compile(",(\\s*)\\}");

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File runtimeExecutable;
        String cwd;
        Map env;
        Object[] args;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("program", VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute("program", "no program path defined")));
        String argsString = configuration.getAttribute(ARGUMENTS, "").trim();
        if (!argsString.isEmpty() && (args = Arrays.asList(argsString.split(" ")).stream().filter(s -> !s.trim().isEmpty()).map(s -> {
            try {
                return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
            }
            catch (CoreException e) {
                Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)errorStatus);
                return s;
            }
        }).toArray()).length > 0) {
            param.put(ARGUMENTS, args);
        }
        if (!(env = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.emptyMap())).isEmpty()) {
            JsonObject envJson = new JsonObject();
            for (Map.Entry entry : env.entrySet()) {
                envJson.addProperty((String)entry.getKey(), VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution((String)entry.getValue()));
            }
            param.put(ENV, envJson);
        }
        if (!(cwd = configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "").trim()).isEmpty()) {
            param.put(CWD, VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(cwd));
        }
        if ((runtimeExecutable = NodeJSManager.getNodeJsLocation()) != null) {
            param.put(RUNTIME_EXECUTABLE, runtimeExecutable.getAbsolutePath());
        }
        if (!this.configureAdditionalParameters(param)) {
            return;
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource(NODE_DEBUG_CMD));
            File file = new File(fileURL.getPath());
            List<String> debugCmdArgs = Collections.singletonList(file.getAbsolutePath());
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setLaunchDebugAdapter(NodeJSManager.getNodeJsLocation().getAbsolutePath(), debugCmdArgs);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            builder.setDspParameters(param);
            super.launch(builder);
        }
        catch (IOException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(() -> NodeRunDAPDebugDelegate.lambda$2(e, (IStatus)errorStatus));
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean configureAdditionalParameters(Map<String, Object> param) {
        String program = (String)param.get("program");
        String cwd = (String)param.get(CWD);
        if (program == null) {
            return false;
        }
        File programFile = new File(program);
        if (Platform.getContentTypeManager().getContentType(TYPESCRIPT_CONTENT_TYPE).isAssociatedWith(programFile.getName())) {
            void o;
            String e3;
            Object v;
            String rootDir;
            void o2;
            String e22;
            Object v2;
            String outFile;
            void o3;
            String string;
            String outDir;
            void o4;
            String string2;
            HashMap co;
            File parentDirectory = cwd == null ? programFile.getParentFile() : new File(cwd);
            File tsConfigFile = this.findTSConfigFile(parentDirectory);
            if (tsConfigFile != null && tsConfigFile.exists()) {
                parentDirectory = tsConfigFile.getParentFile();
            }
            String errorMessage = null;
            Map<String, Object> tsConfig = this.readJSonFile(tsConfigFile);
            HashMap hashMap = co = tsConfig == null ? null : (HashMap)tsConfig.get(COMPILER_OPTIONS);
            if (co == null) {
                errorMessage = Messages.NodeDebug_TSConfirError_NoTsConfig;
                co = new HashMap();
            }
            param.putAll(co);
            if (errorMessage == null) {
                void b;
                Boolean bl;
                boolean sourceMap;
                Object option = co.get(SOURCE_MAP);
                Object v3 = option;
                boolean bl2 = sourceMap = v3 instanceof Boolean && (bl = (Boolean)v3) == (Boolean)v3 && b.booleanValue();
                if (!sourceMap) {
                    errorMessage = Messages.NodeDebug_TSConfirError_SourceMapIsNotEnabled;
                }
            }
            boolean outDirOrFileIsSet = false;
            Object option = co.get(MODULE);
            Object v4 = option;
            String module = v4 instanceof String && (string2 = (String)v4) == (String)v4 ? o4.trim() : null;
            Object v5 = option = co.get(OUT_DIR);
            String string3 = outDir = v5 instanceof String && (string = (String)v5) == (String)v5 ? o3.trim() : null;
            if (outDir != null && outDir.length() > 0 && !".".equals(outDir) && !"./".equals(outDir)) {
                File outDirFile = new File(parentDirectory, outDir);
                try {
                    outDir = outDirFile.getCanonicalPath();
                }
                catch (IOException e22) {
                    outDir = outDirFile.getAbsolutePath();
                }
                param.put(OUT_DIR, outDir);
                outDirOrFileIsSet = true;
            }
            String string4 = outFile = (v2 = (option = co.get(OUT_FILE))) instanceof String && (e22 = (String)v2) == (String)v2 ? o2.trim() : null;
            if (outFile != null && outFile.length() != 0) {
                File outFileFile = new File(parentDirectory, outFile);
                try {
                    outFile = outFileFile.getCanonicalPath();
                }
                catch (IOException e3) {
                    outFile = outFileFile.getAbsolutePath();
                }
                param.put(OUT_FILE, outFile);
                outDirOrFileIsSet = true;
                if (!MODULE_AMD.equalsIgnoreCase(module) && !MODULE_SYSTEM.equalsIgnoreCase(module)) {
                    errorMessage = Messages.NodeDebug_TSConfigError_OutDirNotSupportedModule;
                }
            }
            String string5 = rootDir = (v = (option = co.get(ROOT_DIR))) instanceof String && (e3 = (String)v) == (String)v ? o.trim() : null;
            if (rootDir != null && rootDir.length() > 0 && !".".equals(outDir) && !"./".equals(outDir)) {
                File rootDirFile = new File(parentDirectory, rootDir);
                try {
                    rootDir = rootDirFile.getCanonicalPath();
                }
                catch (IOException e4) {
                    rootDir = rootDirFile.getAbsolutePath();
                }
                param.put(ROOT_DIR, rootDir);
            }
            if (!outDirOrFileIsSet && errorMessage == null) {
                errorMessage = Messages.NodeDebug_TSConfigError_OutDirIsNotSet;
            }
            if (errorMessage != null) {
                int[] result = new int[1];
                String dialogMessage = errorMessage;
                String editTSConfig = tsConfigFile.exists() && tsConfigFile.isFile() ? Messages.NodeDebug_TSConfirError_OpenTSConfigInEditor : Messages.NodeDebug_TSConfirError_CreateAndOpenTSConfigInEditor;
                final File directory = parentDirectory;
                Display.getDefault().syncExec(() -> {
                    MessageDialog dialog = new MessageDialog(DebugUIPlugin.getShell(), Messages.NodeDebug_TSConfirError_Title, null, dialogMessage, 6, 2, new String[]{editTSConfig, Messages.NodeDebug_TSConfirError_StartDebuggingAsIs, Messages.NodeDebug_TSConfirError_Cancel});
                    nArray[0] = dialog.open();
                });
                if (result[0] == 0) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IFile file = this.createNewEmptyFile(new File(directory, NodeRunDAPDebugDelegate.TS_CONFIG_NAME));
                            if (file != null) {
                                try {
                                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new FileEditorInput(file), (String)"org.eclipse.ui.genericeditor.GenericEditor", (boolean)true);
                                }
                                catch (PartInitException e1) {
                                    Activator.getDefault().getLog().error(e1.getMessage(), (Throwable)e1);
                                }
                            }
                        }

                        private IFile createNewEmptyFile(File fsFile) {
                            IWorkspace ws = ResourcesPlugin.getWorkspace();
                            IWorkspaceRoot wr = ws.getRoot();
                            IFile file = wr.getFileForLocation((IPath)new Path(fsFile.getAbsolutePath()));
                            if (!file.exists() || !file.isAccessible()) {
                                IFile[] result = new IFile[1];
                                try {
                                    ws.run(monitor -> {
                                        iFileArray[0] = null;
                                        try {
                                            Throwable throwable = null;
                                            Object var5_7 = null;
                                            try (ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);){
                                                this.createContainers((IResource)file);
                                                file.create((InputStream)is, true, null);
                                                file.refreshLocal(0, null);
                                                iFileArray[0] = file;
                                            }
                                            catch (Throwable throwable2) {
                                                if (throwable == null) {
                                                    throwable = throwable2;
                                                } else if (throwable != throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                                throw throwable;
                                            }
                                        }
                                        catch (IOException | CoreException e) {
                                            Activator.getDefault().getLog().error(e.getMessage(), e);
                                        }
                                    }, null);
                                }
                                catch (CoreException e) {
                                    Activator.getDefault().getLog().error(e.getMessage(), (Throwable)e);
                                }
                                return result[0];
                            }
                            return file;
                        }

                        void createContainers(IResource resource) throws CoreException {
                            IContainer container = resource.getParent();
                            if (container instanceof IFolder var3_4 && !parent.exists()) {
                                this.createContainers((IResource)parent);
                                parent.create(false, true, null);
                            }
                        }
                    });
                } else if (result[0] == 1) {
                    return true;
                }
                return false;
            }
            return true;
        }
        if (Platform.getContentTypeManager().getContentType(JAVACRIPT_CONTENT_TYPE).isAssociatedWith(programFile.getName())) {
            param.put(SOURCE_MAPS, false);
            param.put(JAVACRIPT_DEBUGGABLE_PATTERNS, JAVACRIPT_DEBUGGABLE_PATTERNS_DEFAULT);
            return true;
        }
        return false;
    }

    private File findTSConfigFile(File parentDirectory) {
        do {
            File tsConfigFile;
            if (!(tsConfigFile = new File(parentDirectory, TS_CONFIG_NAME)).isFile()) continue;
            return tsConfigFile;
        } while ((parentDirectory = parentDirectory.getParentFile()) != null && parentDirectory.isDirectory());
        return null;
    }

    private String getSanitisedTSConfigForGson(String tsConfgContent) {
        tsConfgContent = BlockCommentPattern.matcher(tsConfgContent).replaceAll("");
        tsConfgContent = LineCommentPattern.matcher(tsConfgContent).replaceAll("");
        tsConfgContent = TrailingCommaPattern.matcher(tsConfgContent).replaceAll("$1}");
        return tsConfgContent;
    }

    public Map<String, Object> readJSonFile(File tsConfgFile) {
        if (tsConfgFile == null || !tsConfgFile.isFile()) {
            return Map.of();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = new BufferedReader(new FileReader(tsConfgFile));){
                String inputLine;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine).append('\n');
                }
                Type type = new TypeToken<Map<String, Object>>(){}.getType();
                return (Map)new Gson().fromJson(this.getSanitisedTSConfigForGson(response.toString()), type);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return Map.of();
        }
    }

    private static /* synthetic */ void lambda$2(IOException iOException, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)iOException.getMessage(), (IStatus)iStatus);
    }
}

