/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import java.util.HashSet;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.Agenda;
import org.eclipse.viatra.transformation.evm.api.event.ActivationState;
import org.eclipse.viatra.transformation.evm.api.event.EventType;
import org.eclipse.viatra.transformation.evm.notification.IActivationNotificationListener;

public final class DefaultActivationNotificationListener
implements IActivationNotificationListener {
    private Agenda agenda;

    DefaultActivationNotificationListener(Agenda agenda) {
        this.agenda = agenda;
    }

    @Override
    public void activationChanged(Activation<?> activation, ActivationState oldState, EventType event) {
        if (this.agenda.getLogger().isDebugEnabled()) {
            this.agenda.getLogger().debug((Object)String.format("%s -- %s --> %s on %s", oldState, event, activation.getState(), activation));
        }
        this.agenda.getActivations().get(oldState).remove(activation);
        ActivationState state = activation.getState();
        if (!state.isInactive()) {
            this.agenda.getActivations().computeIfAbsent(state, st -> new HashSet()).add(activation);
        }
        this.agenda.getConflictSetUpdater().activationChanged(activation, oldState, event);
    }

    @Override
    public void activationCreated(Activation<?> activation, ActivationState inactiveState) {
        if (this.agenda.getLogger().isDebugEnabled()) {
            this.agenda.getLogger().debug((Object)String.format("%s -- CREATE --> %s on %s", inactiveState, activation.getState(), activation));
        }
        this.agenda.getConflictSetUpdater().activationCreated(activation, inactiveState);
        ActivationState state = activation.getState();
        this.agenda.getActivations().computeIfAbsent(state, st -> new HashSet()).add(activation);
    }

    @Override
    public void activationRemoved(Activation<?> activation, ActivationState oldState) {
        if (this.agenda.getLogger().isDebugEnabled()) {
            this.agenda.getLogger().debug((Object)String.format("%s -- REMOVE --> %s on %s", oldState, activation.getState(), activation));
        }
        this.agenda.getActivations().remove(oldState, activation);
        this.agenda.getConflictSetUpdater().activationRemoved(activation, oldState);
    }
}

