/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core;

import org.apache.log4j.Logger;
import org.eclipse.viatra.addon.validation.core.ValidationEngine;
import org.eclipse.viatra.addon.validation.core.api.IValidationEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class ValidationEngineBuilder {
    private ViatraQueryEngine queryEngine = null;
    private Logger logger = null;

    protected ValidationEngineBuilder() {
    }

    public static ValidationEngineBuilder create() {
        return new ValidationEngineBuilder();
    }

    public IValidationEngine build() {
        Preconditions.checkState((this.queryEngine != null ? 1 : 0) != 0, (String)"Must initialize engine before building!");
        if (this.logger == null) {
            this.logger = ViatraQueryLoggingUtil.getLogger(ValidationEngine.class);
        }
        Preconditions.checkState((this.logger != null ? 1 : 0) != 0, (String)"Must initialize logger before building!");
        return new ValidationEngine(this.queryEngine, this.logger);
    }

    public ValidationEngineBuilder setEngine(ViatraQueryEngine engine) {
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (String)"Engine cannot be null!");
        this.queryEngine = engine;
        return this;
    }

    public ValidationEngineBuilder setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }
}

