/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColorCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.internal.support.SeriesLabelProvider;

public class SeriesEditingSupport
extends EditingSupport {
    private TableViewer tableViewer;
    private String title = "";

    public SeriesEditingSupport(TableViewer tableViewer, String title) {
        super((ColumnViewer)tableViewer);
        this.tableViewer = tableViewer;
        this.title = title;
    }

    protected boolean canEdit(Object element) {
        boolean canEdit;
        switch (this.title) {
            case "Visible": {
                canEdit = true;
                break;
            }
            case "Visible In Legend": {
                canEdit = true;
                break;
            }
            case "Color": {
                canEdit = true;
                break;
            }
            case "Description": {
                canEdit = true;
                break;
            }
            default: {
                canEdit = false;
            }
        }
        return canEdit;
    }

    protected CellEditor getCellEditor(Object element) {
        CheckboxCellEditor cellEditor;
        switch (this.title) {
            case "Visible": {
                cellEditor = new CheckboxCellEditor((Composite)this.tableViewer.getTable());
                break;
            }
            case "Visible In Legend": {
                cellEditor = new CheckboxCellEditor((Composite)this.tableViewer.getTable());
                break;
            }
            case "Color": {
                cellEditor = new ColorCellEditor((Composite)this.tableViewer.getTable());
                break;
            }
            case "Description": {
                cellEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
                break;
            }
            default: {
                cellEditor = null;
            }
        }
        return cellEditor;
    }

    protected Object getValue(Object element) {
        Object object;
        switch (this.title) {
            case "Visible": {
                object = SeriesLabelProvider.isVisible(element);
                break;
            }
            case "Visible In Legend": {
                object = SeriesLabelProvider.isVisibleInLegend(element);
                break;
            }
            case "Color": {
                Color color = SeriesLabelProvider.getColor(element);
                object = color != null ? color.getRGB() : null;
                break;
            }
            case "Description": {
                object = SeriesLabelProvider.getDescription(element);
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    protected void setValue(Object element, Object object) {
        block17: {
            if (!(element instanceof ISeries)) break block17;
            ISeries series = (ISeries)element;
            switch (this.title) {
                case "Visible": {
                    series.setVisible(Boolean.parseBoolean(object.toString()));
                    break;
                }
                case "Visible In Legend": {
                    series.setVisibleInLegend(Boolean.parseBoolean(object.toString()));
                    break;
                }
                case "Color": {
                    if (!(object instanceof RGB)) break;
                    RGB rgb = (RGB)object;
                    Color color = ResourceSupport.getColor(rgb);
                    if (series instanceof IBarSeries) {
                        IBarSeries barSeries = (IBarSeries)element;
                        barSeries.setBarColor(color);
                        break;
                    }
                    if (!(series instanceof ILineSeries)) break;
                    ILineSeries lineSeries = (ILineSeries)element;
                    lineSeries.setLineColor(color);
                    break;
                }
                case "Description": {
                    series.setDescription(object.toString().trim());
                    break;
                }
            }
            this.getViewer().refresh();
        }
    }
}

