/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.core.tags.TagsRegistry;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.editors.INamedElementEditor;
import org.eclipse.rcptt.ui.refactoring.RefactoringUtils;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.swt.widgets.Display;

public final class DeleteTagReferenceChange
extends Change {
    private final IQ7NamedElement element;
    private final Tag tag;

    public DeleteTagReferenceChange(IQ7NamedElement element, Tag tag) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)tag);
        this.element = element;
        this.tag = tag;
    }

    public String getName() {
        if (this.tag.getPath().equals(this.tag.getValue())) {
            return NLS.bind((String)Messages.DeleteTagReferenceChange_Name, (Object[])new Object[]{this.tag.getValue(), RefactoringUtils.elementToString(this.element)});
        }
        return NLS.bind((String)Messages.DeleteTagReferenceChange_Name_Sub, (Object[])new Object[]{this.tag.getValue(), RefactoringUtils.elementToString(this.element)});
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            String tags;
            block17: {
                String newTags;
                pm.beginTask(this.getName(), 1);
                final INamedElementEditor editor = ModelUtils.findEditor(this.element);
                boolean isDirtyInEditor = false;
                if (editor != null && editor.isDirty()) {
                    isDirtyInEditor = true;
                }
                tags = this.element.getTags();
                NamedElement modifiedNamedElement = this.element.getModifiedNamedElement();
                if (modifiedNamedElement != null) {
                    tags = modifiedNamedElement.getTags();
                }
                String path = this.tag.getPath();
                String replaceStr = "";
                if (this.tag.getValue().equals(path)) {
                    newTags = tags.replaceAll(",\\s*" + path, replaceStr);
                    newTags = newTags.replaceAll(String.valueOf(path) + "\\s*,\\s*", replaceStr);
                    newTags = newTags.replaceAll("\\s*" + path + "\\s*", replaceStr);
                } else {
                    replaceStr = path.substring(0, path.length() - this.tag.getValue().length() - 1);
                    newTags = tags.replaceAll(path, replaceStr);
                }
                IQ7NamedElement elementWc = this.element.getWorkingCopy(pm);
                try {
                    try {
                        IProgressMonitor monitor;
                        if (editor != null) {
                            editor.setTags(newTags);
                            monitor = pm;
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    editor.doSave(monitor);
                                }
                            });
                        } else {
                            elementWc.setTags(newTags);
                        }
                        if (!isDirtyInEditor) {
                            if (editor != null) {
                                monitor = pm;
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        editor.doSave(monitor);
                                    }
                                });
                            } else {
                                elementWc.commitWorkingCopy(true, pm);
                            }
                        }
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log(e);
                        elementWc.discardWorkingCopy();
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    elementWc.discardWorkingCopy();
                    throw throwable;
                }
                elementWc.discardWorkingCopy();
            }
            UndoDeleteTagReferenceChange undoDeleteTagReferenceChange = new UndoDeleteTagReferenceChange(this.element, this.tag, tags);
            return undoDeleteTagReferenceChange;
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Tag tag = this.tag;
        synchronized (tag) {
            if (!this.tag.getRefs().contains((Object)this.element)) {
                return RefactoringStatus.createErrorStatus((String)NLS.bind((String)Messages.DeleteTagReferenceChange_NoTagMsg, (Object)RefactoringUtils.elementToString(this.element), (Object)this.tag.getPath()));
            }
        }
        return new RefactoringStatus();
    }

    public Object getModifiedElement() {
        return this.element;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    private static final class UndoDeleteTagReferenceChange
    extends Change {
        private final IQ7NamedElement element;
        private final Tag tag;
        private final String elementTags;

        public UndoDeleteTagReferenceChange(IQ7NamedElement element, Tag tag, String elementTags) {
            Assert.isNotNull((Object)element);
            Assert.isNotNull((Object)tag);
            this.element = element;
            this.tag = tag;
            this.elementTags = elementTags;
        }

        public String getName() {
            return NLS.bind((String)Messages.DeleteTagReferenceChange_UndoName, (Object[])new Object[]{this.tag.getPath(), RefactoringUtils.elementToString(this.element)});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Change perform(IProgressMonitor pm) throws CoreException {
            try {
                TagsRegistry registry;
                block16: {
                    pm.beginTask(this.getName(), 1);
                    final INamedElementEditor editor = ModelUtils.findEditor(this.element);
                    boolean isDirtyInEditor = false;
                    if (editor != null && editor.isDirty()) {
                        isDirtyInEditor = true;
                    }
                    IQ7NamedElement elementWc = this.element.getWorkingCopy(pm);
                    try {
                        try {
                            elementWc.setTags(this.elementTags);
                            if (!isDirtyInEditor) {
                                if (editor != null) {
                                    final IProgressMonitor monitor = pm;
                                    Display.getDefault().syncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            editor.doSave(monitor);
                                        }
                                    });
                                } else {
                                    elementWc.commitWorkingCopy(true, pm);
                                }
                            }
                        }
                        catch (Exception e) {
                            Q7UIPlugin.log(e);
                            elementWc.discardWorkingCopy();
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        elementWc.discardWorkingCopy();
                        throw throwable;
                    }
                    elementWc.discardWorkingCopy();
                }
                Tag restoredTag = this.tag;
                TagsRegistry tagsRegistry = registry = Q7UIPlugin.getDefault().getTags();
                synchronized (tagsRegistry) {
                    for (Tag currentTag : registry.getTags()) {
                        if (!currentTag.getPath().equals(this.tag.getPath())) continue;
                        restoredTag = currentTag;
                        break;
                    }
                }
                DeleteTagReferenceChange deleteTagReferenceChange = new DeleteTagReferenceChange(this.element, restoredTag);
                return deleteTagReferenceChange;
            }
            finally {
                pm.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            Tag tag = this.tag;
            synchronized (tag) {
                if (this.tag.getRefs().contains((Object)this.element)) {
                    return RefactoringStatus.createErrorStatus((String)NLS.bind((String)Messages.DeleteTagReferenceChange_9, (Object)RefactoringUtils.elementToString(this.element), (Object)this.tag.getPath()));
                }
            }
            return new RefactoringStatus();
        }

        public Object getModifiedElement() {
            return this.element;
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }
    }
}

